/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.chart;

import com.ibm.icu.text.DecimalFormatSymbols;
import java.util.Collection;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.AngleType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Interactivity;
import org.eclipse.birt.chart.model.attribute.impl.InteractivityImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartNumberEditor;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainterBase;
import org.eclipse.birt.chart.ui.swt.ChartSpinner;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.LocalizedNumberEditorComposite;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextNumberEditorAssistField;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.InteractivitySheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.BlockPropertiesSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.CustomPropertiesSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.GeneralPropertiesChartSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.VisibilitySheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ChartSheetImpl
extends SubtaskSheetImpl
implements SelectionListener,
Listener {
    protected FillChooserComposite cmbBackground;
    protected FillChooserComposite fccWall;
    protected FillChooserComposite fccFloor;
    private Combo cmbStyle;
    private Button btnEnablePreview;
    private Button btnResetValue;
    private ChartCheckbox btnEnable;
    private AxisRotationChooser xChooser;
    private AxisRotationChooser yChooser;
    private AxisRotationChooser zChooser;
    protected ChartSpinner spnCorverage;
    private ChartCheckbox btnStudyLayout;
    protected static final int DEFAULT_COVERAGE = 50;

    @Override
    public void createControl(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatChartArea_ID");
        Chart defChart = ChartDefaultValueUtil.getDefaultValueChart((Chart)((Chart)this.getChart()));
        this.init();
        Composite cmpBasic = this.createContentComposite(parent);
        this.createAdditionalComposite(cmpBasic);
        this.createChartBackgroundComposite(cmpBasic);
        this.createChartWallNFloorComposite(cmpBasic);
        this.createStyleNPreviewComposite(cmpBasic);
        this.createAngleChooserComposite(this.cmpContent);
        this.createCoverageComposite(cmpBasic);
        this.createInteractivityComposite(defChart, cmpBasic);
        this.createStudyLayoutComposite(defChart, cmpBasic);
        this.populateLists();
        this.createButtonGroup(this.cmpContent);
    }

    protected Composite createContentComposite(Composite parent) {
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(3, true);
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        Composite cmpBasic = new Composite(this.cmpContent, 0);
        cmpBasic.setLayout((Layout)new GridLayout(3, false));
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        cmpBasic.setLayoutData((Object)gd);
        return cmpBasic;
    }

    protected void createChartBackgroundComposite(Composite cmpBasic) {
        Label lblBackground = new Label(cmpBasic, 0);
        lblBackground.setText(Messages.getString("ChartSheetImpl.Label.Background"));
        this.cmbBackground = new FillChooserComposite(cmpBasic, 0, this.getBackgroundFillStyles(), (ChartWizardContext)this.getContext(), ((Chart)this.getChart()).getBlock().getBackground());
        GridData gridData = new GridData(768);
        this.cmbBackground.setLayoutData(gridData);
        this.cmbBackground.addListener(this);
        new Label(cmpBasic, 0);
    }

    protected void createChartWallNFloorComposite(Composite cmpBasic) {
        if (this.hasWallAndFloor()) {
            Label lblWall = new Label(cmpBasic, 0);
            lblWall.setLayoutData((Object)new GridData());
            lblWall.setText(Messages.getString("AttributeSheetImpl.Lbl.ChartWall"));
            this.fccWall = new FillChooserComposite(cmpBasic, 0, (ChartWizardContext)this.getContext(), ((ChartWithAxes)this.getChart()).getWallFill(), true, true, true, true);
            GridData gdFCCWall = new GridData(768);
            this.fccWall.setLayoutData(gdFCCWall);
            this.fccWall.addListener(this);
            new Label(cmpBasic, 0);
            Label lblFloor = new Label(cmpBasic, 0);
            lblFloor.setLayoutData((Object)new GridData());
            lblFloor.setText(Messages.getString("AttributeSheetImpl.Lbl.ChartFloor"));
            this.fccFloor = new FillChooserComposite(cmpBasic, 0, (ChartWizardContext)this.getContext(), ((ChartWithAxes)this.getChart()).getFloorFill(), true, true, true, true);
            GridData gdFCCFloor = new GridData(768);
            this.fccFloor.setLayoutData(gdFCCFloor);
            this.fccFloor.addListener(this);
            new Label(cmpBasic, 0);
        }
    }

    protected void createInteractivityComposite(Chart defChart, Composite cmpBasic) {
        this.btnEnable = ((ChartWizardContext)this.getContext()).getUIFactory().createChartCheckbox(cmpBasic, 0, defChart.getInteractivity().isEnable());
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.btnEnable.setLayoutData((Object)gridData);
        this.btnEnable.setText(Messages.getString("ChartSheetImpl.Label.InteractivityEnable"));
        this.btnEnable.setSelectionState(!((Chart)this.getChart()).getInteractivity().isSetEnable() ? 0 : (((Chart)this.getChart()).getInteractivity().isEnable() ? 1 : 2));
        this.btnEnable.addSelectionListener((SelectionListener)this);
    }

    protected void createStudyLayoutComposite(Chart defChart, Composite cmpBasic) {
        if (this.enableStudyLayout()) {
            this.btnStudyLayout = ((ChartWizardContext)this.getContext()).getUIFactory().createChartCheckbox(cmpBasic, 0, ((ChartWithAxes)defChart).isStudyLayout());
            GridData gridData = new GridData();
            gridData.horizontalSpan = 3;
            this.btnStudyLayout.setLayoutData((Object)gridData);
            this.btnStudyLayout.setText(Messages.getString("ChartSheetImpl.Button.EnableStudyLayout"));
            this.btnStudyLayout.setSelectionState(((ChartWithAxes)this.getChart()).isSetStudyLayout() ? (((ChartWithAxes)this.getChart()).isStudyLayout() ? 1 : 2) : 0);
            this.btnStudyLayout.addSelectionListener((SelectionListener)this);
        }
    }

    protected void createCoverageComposite(Composite cmpBasic) {
        if (!(this.getChart() instanceof ChartWithoutAxes)) {
            return;
        }
        ChartWithoutAxes cwa = (ChartWithoutAxes)this.getChart();
        new Label(cmpBasic, 0).setText(Messages.getString("ChartSheetImpl.Label.Coverage"));
        Composite cmpCoverage = new Composite(cmpBasic, 0);
        cmpCoverage.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cmpCoverage.setLayout((Layout)layout);
        this.spnCorverage = ((ChartWizardContext)this.getContext()).getUIFactory().createChartSpinner(cmpCoverage, 2048, (EObject)cwa, "coverage", true, null, "%");
        this.spnCorverage.setRatio(100.0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.spnCorverage.setLayoutData((Object)gd);
        int spnValue = (int)(cwa.getCoverage() * 100.0);
        if (!cwa.isSetCoverage()) {
            spnValue = 50;
        }
        this.spnCorverage.getWidget().setValues(spnValue, 1, 100, 0, 1, 10);
    }

    protected void createAngleChooserComposite(Composite cmpContent) {
        Composite cmp3D = new Composite(cmpContent, 0);
        cmp3D.setLayout((Layout)new GridLayout());
        cmp3D.setLayoutData((Object)new GridData(1808));
        if (!(this.getChart() instanceof ChartWithAxes) || !this.is3DEnabled()) {
            return;
        }
        Group cmpRotation = new Group(cmp3D, 0);
        GridLayout gl = new GridLayout();
        gl.marginTop = 0;
        gl.verticalSpacing = 0;
        cmpRotation.setLayout((Layout)gl);
        cmpRotation.setLayoutData((Object)new GridData(768));
        cmpRotation.setText(Messages.getString("ChartLegendImpl.Group.Rotation"));
        this.xChooser = new AxisRotationChooser(ChartUIUtil.getAxisXForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart())), 1);
        this.xChooser.placeComponents((Composite)cmpRotation);
        this.yChooser = new AxisRotationChooser(ChartUIUtil.getAxisYForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart()), (int)0), 2);
        this.yChooser.placeComponents((Composite)cmpRotation);
        this.zChooser = new AxisRotationChooser(ChartUIUtil.getAxisZForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart())), 3);
        this.zChooser.placeComponents((Composite)cmpRotation);
        this.btnResetValue = new Button((Composite)cmpRotation, 8);
        this.btnResetValue.setText(Messages.getString("ChartSheetImpl.Label.ResetValue"));
        this.btnResetValue.setSelection(ChartPreviewPainterBase.isProcessorEnabled());
        this.btnResetValue.addSelectionListener((SelectionListener)this);
    }

    protected boolean enableStudyLayout() {
        return ChartUtil.hasMultipleYAxes((Chart)((Chart)this.getChart()));
    }

    protected void createStyleNPreviewComposite(Composite cmpBasic) {
        new Label(cmpBasic, 0).setText(Messages.getString("ChartSheetImpl.Label.Style"));
        this.cmbStyle = new Combo(cmpBasic, 12);
        GridData gridData = new GridData(768);
        this.cmbStyle.setLayoutData((Object)gridData);
        this.cmbStyle.addSelectionListener((SelectionListener)this);
        this.btnEnablePreview = new Button(cmpBasic, 32);
        this.btnEnablePreview.setText(Messages.getString("ChartSheetImpl.Label.EnableInPreview"));
        this.btnEnablePreview.setSelection(ChartPreviewPainterBase.isProcessorEnabled());
        this.btnEnablePreview.addSelectionListener((SelectionListener)this);
    }

    protected boolean is3DEnabled() {
        return ChartUIUtil.is3DType((Chart)((Chart)this.getChart()));
    }

    protected void createAdditionalComposite(Composite cmpBasic) {
    }

    protected void init() {
        if (((Chart)this.getChart()).getInteractivity() == null) {
            Interactivity interactivity = InteractivityImpl.create();
            interactivity.eAdapters().addAll((Collection)((Chart)this.getChart()).eAdapters());
            ((Chart)this.getChart()).setInteractivity(interactivity);
        }
    }

    protected void populateLists() {
        if (this.cmbStyle == null) {
            return;
        }
        IDataServiceProvider idsp = ((ChartWizardContext)this.getContext()).getDataServiceProvider();
        if (idsp != null) {
            String[] allStyleNames = idsp.getAllStyles();
            String[] displayNames = idsp.getAllStyleDisplayNames();
            String[] selection = new String[displayNames.length + 1];
            System.arraycopy(displayNames, 0, selection, 1, displayNames.length);
            selection[0] = Messages.getString("ChartSheetImpl.Label.None");
            this.cmbStyle.setItems(selection);
            this.cmbStyle.setData((Object)allStyleNames);
            String sStyle = idsp.getCurrentStyle();
            int idx = this.getStyleIndex(sStyle);
            this.cmbStyle.select(idx + 1);
        }
    }

    private int getStyleIndex(String style) {
        String[] allStyleNames = (String[])this.cmbStyle.getData();
        if (style != null && allStyleNames != null) {
            int i = 0;
            while (i < allStyleNames.length) {
                if (style.equals(allStyleNames[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected void createButtonGroup(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(5, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        AbstractPopupSheet popup = new BlockPropertiesSheet(Messages.getString("ChartSheetImpl.Text.Outline"), (ChartWizardContext)this.getContext());
        Button btnBlockProp = this.createToggleButton(cmp, ".Outline", Messages.getString("ChartSheetImpl.Text.Outline&"), popup);
        btnBlockProp.addSelectionListener((SelectionListener)this);
        popup = new VisibilitySheet(Messages.getString("ChartSheetImpl.Group.EmptyMessage"), (ChartWizardContext)this.getContext());
        Button btnVisibilityProp = this.createToggleButton(cmp, ".Visibility", Messages.getString("ChartSheetImpl.Group.EmptyMessage&"), popup);
        btnVisibilityProp.addSelectionListener((SelectionListener)this);
        popup = new GeneralPropertiesChartSheet(Messages.getString("ChartSheetImpl.Text.GeneralProperties"), (ChartWizardContext)this.getContext());
        Button btnGeneralProp = this.createToggleButton(cmp, ".General", Messages.getString("ChartSheetImpl.Text.GeneralProperties&"), popup);
        btnGeneralProp.addSelectionListener((SelectionListener)this);
        popup = new CustomPropertiesSheet(Messages.getString("ChartSheetImpl.Text.CustomProperties"), (ChartWizardContext)this.getContext());
        Button btnCustomProp = this.createToggleButton(cmp, ".Custom", Messages.getString("ChartSheetImpl.Text.CustomProperties&"), popup);
        btnCustomProp.addSelectionListener((SelectionListener)this);
        if (((ChartWizardContext)this.getContext()).isInteractivityEnabled()) {
            popup = new InteractivitySheet(Messages.getString("ChartSheetImpl.Label.Interactivity"), (ChartWizardContext)this.getContext(), (EList<Trigger>)((Chart)this.getChart()).getBlock().getTriggers(), (EObject)((Chart)this.getChart()).getBlock(), 4, 16);
            Button btnInteractivity = this.createToggleButton(cmp, ".Interactivity", Messages.getString("SeriesYSheetImpl.Label.Interactivity&"), popup, ((Chart)this.getChart()).getInteractivity().isEnable());
            btnInteractivity.addSelectionListener((SelectionListener)this);
        }
    }

    protected int getBackgroundFillStyles() {
        return 31;
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.cmbBackground)) {
            ((Chart)this.getChart()).getBlock().setBackground((Fill)event.data);
        } else if (event.widget.equals((Object)this.fccWall)) {
            if (this.hasWallAndFloor()) {
                ((ChartWithAxes)this.getChart()).setWallFill((Fill)event.data);
            }
        } else if (event.widget.equals((Object)this.fccFloor) && this.hasWallAndFloor()) {
            ((ChartWithAxes)this.getChart()).setFloorFill((Fill)event.data);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getData().toString());
        }
        if (e.widget.equals(this.cmbStyle)) {
            String[] allStyleNames = (String[])this.cmbStyle.getData();
            String sStyle = null;
            int idx = this.cmbStyle.getSelectionIndex();
            if (idx > 0) {
                sStyle = allStyleNames[idx - 1];
            }
            ((ChartWizardContext)this.getContext()).getDataServiceProvider().setStyle(sStyle);
            if (this.btnEnablePreview.getSelection()) {
                this.refreshPreview();
            }
        } else if (e.widget.equals(this.btnEnablePreview)) {
            ChartPreviewPainterBase.enableProcessor((boolean)this.btnEnablePreview.getSelection());
            this.refreshPreview();
        } else if (e.widget.equals(this.btnEnable)) {
            int state = this.btnEnable.getSelectionState();
            ChartElementUtil.setEObjectAttribute((EObject)((Chart)this.getChart()).getInteractivity(), (String)"enable", (Object)(state == 1 ? 1 : 0), (state == 0 ? 1 : 0) != 0);
            this.setToggleButtonEnabled(".Interactivity", state == 1);
            if (this.getToggleButtonSelection(".Interactivity")) {
                this.detachPopup();
            }
        } else if (e.widget.equals(this.btnResetValue)) {
            if (!this.xChooser.isAutoAngle()) {
                this.setAxisAngle(1, -20);
                this.xChooser.txtRotation.setValue(-20.0);
            }
            if (!this.yChooser.isAutoAngle()) {
                this.setAxisAngle(2, 45);
                this.yChooser.txtRotation.setValue(45.0);
            }
            if (!this.zChooser.isAutoAngle()) {
                this.setAxisAngle(3, 0);
                this.zChooser.txtRotation.setValue(0.0);
            }
        } else if (e.widget == this.btnStudyLayout && this.getChart() instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)this.getChart();
            if (this.btnStudyLayout.getSelectionState() == 0) {
                cwa.unsetStudyLayout();
            } else {
                cwa.setStudyLayout(this.btnStudyLayout.getSelectionState() == 1);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void refreshPreview() {
        boolean currentValue = ((Chart)this.getChart()).getTitle().isVisible();
        ChartAdapter.ignoreNotifications((boolean)true);
        ((Chart)this.getChart()).getTitle().setVisible(!currentValue);
        ChartAdapter.ignoreNotifications((boolean)false);
        ((Chart)this.getChart()).getTitle().setVisible(currentValue);
    }

    protected boolean hasWallAndFloor() {
        return this.getChart() instanceof ChartWithAxes && ((Chart)this.getChart()).getDimension().getValue() != 0;
    }

    private void setAxisAngle(int angleType, int angleDegree) {
        Angle3D angle3D = this.getAngle3D();
        angle3D.setType(AngleType.NONE_LITERAL);
        ((ChartWithAxes)this.getChart()).getRotation().getAngles().clear();
        ((ChartWithAxes)this.getChart()).getRotation().getAngles().add((Object)angle3D);
        switch (angleType) {
            case 1: {
                angle3D.setXAngle((double)angleDegree);
                break;
            }
            case 2: {
                angle3D.setYAngle((double)angleDegree);
                break;
            }
            case 3: {
                angle3D.setZAngle((double)angleDegree);
            }
        }
    }

    private Angle3D getAngle3D() {
        return (Angle3D)((ChartWithAxes)this.getChart()).getRotation().getAngles().get(0);
    }

    @Override
    public void dispose() {
        super.dispose();
        ChartPreviewPainterBase.enableProcessor((boolean)true);
    }

    private class AxisRotationChooser
    implements SelectionListener,
    ModifyListener {
        private Button btnAntiRotation;
        private Button btnRotation;
        private AbstractChartNumberEditor txtRotation;
        private int angleType;

        public AxisRotationChooser(Axis axis, int angleType) {
            this.angleType = angleType;
        }

        public void placeComponents(Composite parent) {
            Composite context = new Composite(parent, 0);
            GridLayout gl = new GridLayout(4, false);
            gl.horizontalSpacing = 8;
            context.setLayout((Layout)gl);
            context.setLayoutData((Object)new GridData(768));
            this.btnAntiRotation = new Button(context, 8);
            GridData gd = new GridData();
            ChartUIUtil.setChartImageButtonSizeByPlatform((GridData)gd);
            this.btnAntiRotation.setLayoutData((Object)gd);
            this.btnAntiRotation.setImage(UIHelper.getImage((String)this.getImagePath(this.angleType, true)));
            this.btnAntiRotation.addSelectionListener((SelectionListener)this);
            this.btnRotation = new Button(context, 8);
            gd = new GridData();
            gd.widthHint = 20;
            gd.heightHint = 20;
            this.btnRotation.setLayoutData((Object)gd);
            this.btnRotation.setImage(UIHelper.getImage((String)this.getImagePath(this.angleType, false)));
            this.btnRotation.addSelectionListener((SelectionListener)this);
            this.txtRotation = ((ChartWizardContext)ChartSheetImpl.this.getContext()).getUIFactory().createChartNumberEditor(context, 2052, null, (EObject)ChartSheetImpl.this.getAngle3D(), this.getAxisAngleProperty(this.angleType));
            new RotationEditorAssistField((LocalizedNumberEditorComposite)this.txtRotation, null);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.txtRotation.setLayoutData((Object)gd);
            this.txtRotation.setValue(this.getAxisAngle(this.angleType));
            this.txtRotation.addModifyListener((ModifyListener)this);
            this.updateUIState(this.txtRotation.getTextControl().isEnabled());
        }

        private boolean isAutoAngle() {
            return !ChartElementUtil.isSetEObjectAttribute((EObject)ChartSheetImpl.this.getAngle3D(), (String)this.getAxisAngleProperty(this.angleType));
        }

        private void updateUIState(boolean enabled) {
            this.btnAntiRotation.setEnabled(enabled);
            this.btnRotation.setEnabled(enabled);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget.equals(this.btnAntiRotation)) {
                ChartSheetImpl.this.setAxisAngle(this.angleType, (int)this.getAxisAngle(this.angleType) - 10);
                this.txtRotation.setValue(this.getAxisAngle(this.angleType));
            } else if (e.widget.equals(this.btnRotation)) {
                ChartSheetImpl.this.setAxisAngle(this.angleType, (int)this.getAxisAngle(this.angleType) + 10);
                this.txtRotation.setValue(this.getAxisAngle(this.angleType));
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget.equals(this.txtRotation)) {
                if (!"Reset".equals(e.data)) {
                    ChartSheetImpl.this.setAxisAngle(this.angleType, (int)this.txtRotation.getValue());
                }
                this.updateUIState(this.txtRotation.getTextControl().isEnabled());
            }
        }

        private String getImagePath(int angleType, boolean bAntiRotation) {
            String basePath = "icons/obj16/";
            String filename = null;
            switch (angleType) {
                case 1: {
                    filename = bAntiRotation ? "x_rotation.gif" : "x_anti_rotation.gif";
                    break;
                }
                case 2: {
                    filename = bAntiRotation ? "y_anti_rotation.gif" : "y_rotation.gif";
                    break;
                }
                case 3: {
                    filename = bAntiRotation ? "z_rotation.gif" : "z_anti_rotation.gif";
                }
            }
            return basePath + filename;
        }

        private double getAxisAngle(int angleType) {
            switch (angleType) {
                case 1: {
                    return ChartSheetImpl.this.getAngle3D().getXAngle();
                }
                case 2: {
                    return ChartSheetImpl.this.getAngle3D().getYAngle();
                }
                case 3: {
                    return ChartSheetImpl.this.getAngle3D().getZAngle();
                }
            }
            return 0.0;
        }

        private String getAxisAngleProperty(int angleType) {
            switch (angleType) {
                case 1: {
                    return "xAngle";
                }
                case 2: {
                    return "yAngle";
                }
                case 3: {
                    return "zAngle";
                }
            }
            return "xAngle";
        }
    }

    static class RotationEditorAssistField
    extends TextNumberEditorAssistField {
        public RotationEditorAssistField(LocalizedNumberEditorComposite numberEditor, Composite composite) {
            super(numberEditor.getTextControl(), composite);
        }

        @Override
        public boolean isValid() {
            String contents = this.getContents();
            if (contents == null || "".equals(contents.trim())) {
                return true;
            }
            char groupingSeparator = DecimalFormatSymbols.getInstance().getGroupingSeparator();
            int length = contents.length();
            int i = 0;
            while (i < length) {
                char ch;
                if (Character.isDigit(ch = contents.charAt(i++)) || ch == '.' || ch == '-' || ch == '+' || ch == groupingSeparator) continue;
                return false;
            }
            return true;
        }

        @Override
        public void quickFix() {
            String contents = this.getContents();
            StringBuilder numbersOnly = new StringBuilder();
            char groupingSeparator = DecimalFormatSymbols.getInstance().getGroupingSeparator();
            int length = contents.length();
            int i = 0;
            while (i < length) {
                char ch;
                if (!Character.isDigit(ch = contents.charAt(i++)) && ch != '.' && ch != '-' && ch != '+' && ch != groupingSeparator) continue;
                numbersOnly.append(ch);
            }
            this.setContents(numbersOnly.toString());
        }
    }
}

