/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.command.CustomMsgException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.CustomMsgRecord;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Translation;

public class CustomMsgCommand
extends AbstractElementCommand {
    public CustomMsgCommand(Module module) {
        super(module, module);
    }

    public void addTranslation(String resourceKey, String locale, String text) throws CustomMsgException {
        assert (this.module != null);
        if (StringUtil.trimString(resourceKey) == null) {
            throw new CustomMsgException(this.element, "Error.CustomMsgException.RESOURCE_KEY_REQUIRED");
        }
        if (!StringUtil.isValidLocale(locale)) {
            throw new CustomMsgException(this.element, "Error.CustomMsgException.INVALID_LOCALE");
        }
        if (this.module.findTranslation(resourceKey, locale) != null) {
            throw new CustomMsgException(this.element, resourceKey, locale, "Error.CustomMsgException.DUPLICATE_LOCALE");
        }
        ActivityStack stack = this.getActivityStack();
        CustomMsgRecord msgRecord = new CustomMsgRecord((ReportDesign)this.element, new Translation(resourceKey, locale, text), 0);
        stack.execute(msgRecord);
    }

    public void dropTranslation(String resourceKey, String locale) throws CustomMsgException {
        assert (this.module != null);
        Translation translation = this.module.findTranslation(resourceKey, locale);
        if (translation == null) {
            throw new CustomMsgException(this.element, "Error.CustomMsgException.TRANSLATION_NOT_FOUND");
        }
        ActivityStack stack = this.getActivityStack();
        CustomMsgRecord msgRecord = new CustomMsgRecord((ReportDesign)this.element, translation, 1);
        stack.execute(msgRecord);
    }

    public void setLocale(Translation translation, String newLocale) throws CustomMsgException {
        assert (this.module != null);
        assert (translation != null);
        if (!this.module.contains(translation)) {
            throw new CustomMsgException(this.element, "Error.CustomMsgException.TRANSLATION_NOT_FOUND");
        }
        String oldLocale = translation.getLocale();
        if (oldLocale == null && newLocale == null || oldLocale != null && oldLocale.equalsIgnoreCase(newLocale)) {
            return;
        }
        if (!StringUtil.isValidLocale(newLocale)) {
            throw new CustomMsgException(this.element, "Error.CustomMsgException.INVALID_LOCALE");
        }
        if (this.module.findTranslation(translation.getResourceKey(), newLocale) != null) {
            throw new CustomMsgException(this.element, translation.getResourceKey(), newLocale, "Error.CustomMsgException.DUPLICATE_LOCALE");
        }
        ActivityStack stack = this.getActivityStack();
        CustomMsgRecord msgRecord = new CustomMsgRecord((ReportDesign)this.element, translation, newLocale, 2);
        stack.execute(msgRecord);
    }

    public void setText(Translation translation, String newText) throws CustomMsgException {
        assert (this.module != null);
        assert (translation != null);
        if (!this.module.contains(translation)) {
            throw new CustomMsgException(this.element, "Error.CustomMsgException.TRANSLATION_NOT_FOUND");
        }
        ActivityStack stack = this.getActivityStack();
        CustomMsgRecord msgRecord = new CustomMsgRecord((ReportDesign)this.element, translation, newText, 3);
        stack.execute(msgRecord);
    }
}

