/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DualRadioButtonPropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DualRadioButtonSection
extends Section {
    private DualRadioButtonPropertyDescriptor descriptor;
    private IDescriptorProvider provider;
    private int width = -1;

    public DualRadioButtonSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    @Override
    public void createSection() {
        this.getLabelControl(this.parent);
        this.getPropertyControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    protected DualRadioButtonPropertyDescriptor getPropertyControl(Composite parent) {
        if (this.descriptor == null) {
            this.descriptor = DescriptorToolkit.createRadioButtonPropertyDescriptor(true);
            if (this.getProvider() != null) {
                this.descriptor.setDescriptorProvider(this.getProvider());
            }
            this.descriptor.createControl(parent);
            this.descriptor.getControl().setLayoutData((Object)new GridData());
            this.descriptor.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    DualRadioButtonSection.this.descriptor = null;
                }
            });
        } else {
            this.checkParent(this.descriptor.getControl(), parent);
        }
        return this.descriptor;
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    @Override
    public void layout() {
        GridData gd = (GridData)this.descriptor.getControl().getLayoutData();
        if (this.width > -1) {
            gd.widthHint = this.width;
        }
        gd.grabExcessHorizontalSpace = false;
    }

    @Override
    public void setInput(Object input) {
        if (input != null) {
            this.descriptor.setInput(input);
        }
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.descriptor != null) {
            this.descriptor.setDescriptorProvider(provider);
        }
    }

    public void setFocus() {
        if (this.descriptor != null) {
            this.descriptor.getControl().setFocus();
        }
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void load() {
        if (this.descriptor != null && !this.descriptor.getControl().isDisposed()) {
            this.descriptor.load();
        }
    }

    @Override
    public void reset() {
        if (this.descriptor != null && !this.descriptor.getControl().isDisposed()) {
            this.descriptor.reset();
        }
    }

    @Override
    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.descriptor != null) {
            this.descriptor.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.descriptor != null) {
            this.descriptor.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }
}

