/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import java.util.Objects;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;

public class XSSFCellBorderExtended
extends XSSFCellBorder {
    private Boolean diagonalBorder = false;
    private Boolean antidiagonalBorder = false;
    private XSSFColor diagonalColor = null;
    private XSSFColor antidiagonalColor = null;
    private BorderStyle diagonalStyle = null;
    private BorderStyle antidiagonalStyle = null;

    public XSSFCellBorderExtended(CTBorder ct, ThemesTable theme, IndexedColorMap colorMap) {
        super(ct, theme, colorMap);
    }

    public void setDiagonal(Boolean use) {
        this.diagonalBorder = use;
    }

    public void setAntidiagonal(Boolean use) {
        this.antidiagonalBorder = use;
    }

    public Boolean isSetDiagonal() {
        return this.diagonalBorder;
    }

    public Boolean isSetAntidiagonal() {
        return this.antidiagonalBorder;
    }

    public void setDiagonalColor(XSSFColor color) {
        this.diagonalColor = color;
    }

    public void setAntidiagonalColor(XSSFColor color) {
        this.antidiagonalColor = color;
    }

    public void setDiagonalStyle(BorderStyle style) {
        this.diagonalStyle = style;
    }

    public void setAntidiagonalStyle(BorderStyle style) {
        this.antidiagonalStyle = style;
    }

    public XSSFColor getDiagonalColor() {
        return this.diagonalColor;
    }

    public XSSFColor getAntidiagonalColor() {
        return this.antidiagonalColor;
    }

    public BorderStyle getDiagonalStyle() {
        return this.diagonalStyle;
    }

    public BorderStyle getAntidiagonalStyle() {
        return this.antidiagonalStyle;
    }

    public boolean equals(Object o) {
        if (!(o instanceof XSSFCellBorderExtended)) {
            return false;
        }
        XSSFCellBorderExtended cf = (XSSFCellBorderExtended)((Object)o);
        boolean equal = true;
        XSSFCellBorder.BorderSide[] borderSideArray = XSSFCellBorder.BorderSide.values();
        int n = borderSideArray.length;
        int n2 = 0;
        while (n2 < n) {
            XSSFCellBorder.BorderSide side = borderSideArray[n2];
            if (!Objects.equals(this.getBorderColor(side), cf.getBorderColor(side)) || !Objects.equals(this.getBorderStyle(side), cf.getBorderStyle(side))) {
                equal = false;
                break;
            }
            ++n2;
        }
        if (!(!equal || Objects.equals(this.getDiagonalColor(), cf.getDiagonalColor()) && Objects.equals(this.getDiagonalStyle(), cf.getDiagonalStyle()) && Objects.equals(this.getAntidiagonalColor(), cf.getAntidiagonalColor()) && Objects.equals(this.getAntidiagonalStyle(), cf.getAntidiagonalStyle()))) {
            equal = false;
        }
        return equal;
    }
}

