/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.editors;

import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Composite;

public class SQLSourceViewer
extends SourceViewer {
    public SQLSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        super(parent, ruler, styles);
    }

    public int getCurrentCaretPosition() {
        return this.getTextWidget().getCaretOffset();
    }

    public boolean findQueryText(String findQueryText, boolean forwardSearch, boolean queryTextCaseSensitive, boolean queryTextWholeWord) {
        int textLength;
        IFindReplaceTarget frt;
        boolean textFound = false;
        int queryTextLength = this.getTextWidget().getText().length();
        int startPosition = this.getCurrentCaretPosition();
        int searchPositionFound = -1;
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        if (!forwardSearch && selection.getLength() > 0) {
            startPosition -= selection.getLength();
        }
        if ((frt = this.getFindReplaceTarget()) != null && frt.canPerformFind() && findQueryText != null && (textLength = findQueryText.length()) > 0 && (searchPositionFound = frt.findAndSelect(startPosition, findQueryText, forwardSearch, queryTextCaseSensitive, queryTextWholeWord)) >= 0) {
            textFound = true;
            if (searchPositionFound + textLength <= queryTextLength) {
                this.getTextWidget().setCaretOffset(searchPositionFound + textLength);
            }
            int[] selectionRange = new int[]{searchPositionFound, textLength};
            this.validateSelectionRange(selectionRange);
            if (selectionRange[0] > 0) {
                this.setSelectedRange(searchPositionFound, textLength);
            }
        }
        return textFound;
    }
}

