/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.bidi.utils.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.data.bidi.utils.core.BidiEngine;

public abstract class BidiTransform {
    public static String transform(String txt, String inFormat, String outFormat) {
        return BidiEngine.INSTANCE.process(txt, inFormat, outFormat);
    }

    public Map<String, String> transform(Map<String, String> map, String inFormat, String outFormat) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            String str = BidiEngine.INSTANCE.process(key, inFormat, outFormat);
            String value = map.get(key);
            resultMap.put(str, value);
        }
        return resultMap;
    }

    public String transformProcName(String procName, String inFormat, String outFormat, boolean isSQLServer) {
        boolean isSpecialCase;
        String specialCaseStr = ";1";
        boolean bl = isSpecialCase = isSQLServer && ((String)procName).endsWith(specialCaseStr);
        if (isSpecialCase) {
            procName = ((String)procName).substring(0, ((String)procName).length() - specialCaseStr.length());
        }
        procName = BidiEngine.INSTANCE.process((String)procName, inFormat, outFormat);
        if (isSpecialCase) {
            procName = (String)procName + specialCaseStr;
        }
        return procName;
    }

    public static String transformURL(String urlStr, String inFormat, String outFormat) {
        if (inFormat.equals(outFormat)) {
            return urlStr;
        }
        Object str = urlStr;
        if (((String)str).contains("db2")) {
            int dbStrStart = ((String)str).lastIndexOf("/");
            if (dbStrStart < 0) {
                return urlStr;
            }
            String dbName = ((String)str).substring(dbStrStart + 1);
            dbName = BidiEngine.INSTANCE.process(dbName, inFormat, outFormat);
            urlStr = ((String)str).substring(0, dbStrStart + 1) + dbName;
        } else if (((String)str).contains("sqlserver")) {
            int dbStrStart = -1;
            if (((String)str).indexOf("databaseName") > 0) {
                dbStrStart = ((String)str).indexOf("databaseName") + "databaseName".length();
            } else if (((String)str).indexOf("database") > 0) {
                dbStrStart = ((String)str).indexOf("database") + "database".length();
            } else {
                return urlStr;
            }
            String dbName = ((String)str).substring(dbStrStart);
            dbName = dbName.trim();
            dbName = dbName.substring(1).trim();
            int indx1 = dbName.indexOf(59);
            int indx2 = dbName.indexOf(44);
            int indx = -1;
            if (indx1 > -1) {
                indx = indx1;
            }
            if (indx2 > -1 && (indx2 < indx || indx == -1)) {
                indx = indx2;
            }
            if (indx == -1) {
                indx = dbName.length();
            }
            dbName = dbName.substring(0, indx);
            String dbNameNew = BidiEngine.INSTANCE.process(dbName, inFormat, outFormat);
            urlStr = ((String)urlStr).replace(dbName, dbNameNew);
        } else if (((String)str).contains("oracle")) {
            int dbStrStart = Math.max(((String)str).lastIndexOf(58), ((String)str).lastIndexOf(47));
            if (dbStrStart < 0) {
                return urlStr;
            }
            String dbName = ((String)str).substring(dbStrStart + 1);
            dbName = BidiEngine.INSTANCE.process(dbName, inFormat, outFormat);
            urlStr = ((String)str).substring(0, dbStrStart + 1) + dbName;
        } else if (((String)str).contains("derby")) {
            int dbStrStart = ((String)str).lastIndexOf(47);
            if (dbStrStart < 0) {
                return urlStr;
            }
            String dbName = ((String)str).substring(dbStrStart + 1);
            dbName = BidiEngine.INSTANCE.process(dbName, inFormat, outFormat);
            urlStr = ((String)str).substring(0, dbStrStart + 1) + dbName;
        } else if (((String)str).contains("mysql")) {
            if (((String)str).indexOf("//") < 0 || ((String)str).substring(((String)str).indexOf("//") + 2).indexOf(47) < 0) {
                return urlStr;
            }
            int dbStrStart = ((String)str).indexOf("//") + 2 + ((String)str).substring(((String)str).indexOf("//") + 2).indexOf(47) + 1;
            int dbStrEnd = ((String)str).length();
            if (((String)str).substring(dbStrStart).contains("?")) {
                dbStrEnd = ((String)str).substring(dbStrStart).indexOf("?");
            }
            String dbName = ((String)str).substring(dbStrStart, dbStrStart + dbStrEnd);
            dbName = BidiEngine.INSTANCE.process(dbName, inFormat, outFormat);
            urlStr = ((String)str).substring(0, dbStrStart) + dbName + ((String)str).substring(dbStrStart + dbStrEnd);
        }
        return urlStr;
    }
}

