/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.model;

import org.eclipse.birt.chart.internal.computations.Matrix;

public class FittingCalculator {
    private double[] fittedValue;

    public FittingCalculator() {
    }

    public FittingCalculator(double[] xa, double[] ya, double windowProportion) {
        this.calculate(xa, ya, windowProportion);
    }

    public double[] getFittedValue() {
        return this.fittedValue;
    }

    public void calculate(double[] xa, double[] ya, double windowProportion) {
        this.fittedValue = new double[xa.length];
        int window = (int)Math.round((double)xa.length * windowProportion);
        if (window > 1) {
            double[] windowXa = new double[window];
            double[] windowYa = new double[window];
            double[] weights = new double[window];
            Matrix X = new Matrix(window, 2);
            Matrix Y = new Matrix(window, 1);
            Matrix W = new Matrix(window, window);
            int index = 0;
            while (index < xa.length) {
                Matrix L;
                int total = xa.length;
                int windowStart = 0;
                double maxDistance = 0.0;
                if (index < window) {
                    i = 0;
                    while (i < window) {
                        if (xa[index] - xa[i] <= xa[window + i] - xa[index]) {
                            windowStart = i;
                            maxDistance = Math.max(xa[index] - xa[windowStart], xa[windowStart + window - 1] - xa[index]);
                            break;
                        }
                        ++i;
                    }
                } else if (index >= window && index < total - window) {
                    i = 0;
                    while (i < window) {
                        if (xa[index] - xa[index - window + 1 + i] <= xa[index + 1 + i] - xa[index]) {
                            windowStart = index - window + 1 + i;
                            maxDistance = Math.max(xa[index] - xa[windowStart], xa[windowStart + window - 1] - xa[index]);
                            break;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < window) {
                        if (xa[total - 1 - i] - xa[index] <= xa[index] - xa[total - window - 1 - i]) {
                            windowStart = total - window - i;
                            maxDistance = Math.max(xa[index] - xa[windowStart], xa[windowStart + window - 1] - xa[index]);
                            break;
                        }
                        ++i;
                    }
                }
                System.arraycopy(xa, windowStart, windowXa, 0, window);
                System.arraycopy(ya, windowStart, windowYa, 0, window);
                int windowIndex = index - windowStart;
                int i = 0;
                while (i < window) {
                    double distance = Math.abs(windowXa[windowIndex] - windowXa[i]);
                    weights[i] = Math.pow(1.0 - Math.pow(distance / maxDistance, 3.0), 3.0);
                    ++i;
                }
                i = 0;
                while (i < window) {
                    X.set(i, 0, 1.0);
                    X.set(i, 1, windowXa[i]);
                    Y.set(i, 0, windowYa[i]);
                    W.set(i, i, weights[i]);
                    ++i;
                }
                Matrix XTW = X.transpose().times(W);
                try {
                    L = XTW.times(X).inverse().times(XTW.times(Y));
                }
                catch (Exception ex) {
                    L = new Matrix(2, 1);
                    L.set(0, 0, ya[index]);
                    L.set(1, 0, 0.0);
                }
                this.fittedValue[index] = L.get(0, 0) + L.get(1, 0) * xa[index];
                ++index;
            }
        } else {
            int i = 0;
            while (i < xa.length) {
                this.fittedValue[i] = ya[i];
                ++i;
            }
        }
    }
}

