/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.NodeEditPartHelper;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editpolicies.TableSelectionEditPolicy;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.figures.TableNodeFigure;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.figures.TablePaneFigure;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DragEditPartsTracker;

public class DatasetNodeEditPart
extends NodeEditPartHelper
implements Listener {
    public TablePaneFigure scrollPane;
    public TableNodeFigure tableNode;
    private TabularCubeHandle cube;

    public DatasetNodeEditPart(EditPart parent, DataSetHandle dataset) {
        this.setModel(dataset);
        this.setParent(parent);
        this.cube = (TabularCubeHandle)parent.getModel();
    }

    @Override
    protected IFigure createFigure() {
        String name = this.cube.getDataSet().getName() + " " + Messages.getString("DatasetNodeEditPart.Primary.Dataset");
        this.tableNode = new TableNodeFigure(name, true);
        this.scrollPane = new TablePaneFigure(name, true);
        this.scrollPane.setContents((IFigure)this.tableNode);
        return this.scrollPane;
    }

    protected List getModelChildren() {
        ArrayList<ResultSetColumnHandle> childList = new ArrayList<ResultSetColumnHandle>();
        ResultSetColumnHandle[] columns = OlapUtil.getDataFields(this.cube.getDataSet());
        if (columns != null) {
            int i = 0;
            while (i < columns.length) {
                childList.add(columns[i]);
                ++i;
            }
        }
        return childList;
    }

    protected void refreshVisuals() {
        Rectangle r;
        if (!UIHelper.existIntProperty(this.cube.getRoot(), UIHelper.getId(this.cube.getDataSet(), this.cube), "x")) {
            int width = this.getWidth();
            int height = this.getHeight();
            int posX = 250 - width / 2 - 40;
            int posY = 200 - height / 2 - 20;
            r = new Rectangle(this.setPosX(posX), this.setPosY(posY), this.getWidth(), this.getHeight());
        } else {
            r = new Rectangle(this.getPosX(), this.getPosY(), this.getWidth(), this.getHeight());
        }
        this.getFigure().setBounds(r);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
    }

    private int getWidth() {
        int width = UIHelper.getIntProperty(this.cube.getRoot(), UIHelper.getId(this.cube.getDataSet(), this.cube), "width");
        return width == 0 ? 150 : width;
    }

    private int getHeight() {
        int height = UIHelper.getIntProperty(this.cube.getRoot(), UIHelper.getId(this.cube.getDataSet(), this.cube), "height");
        return height == 0 ? 200 : height;
    }

    private int getPosX() {
        int x = UIHelper.getIntProperty(this.cube.getRoot(), UIHelper.getId(this.cube.getDataSet(), this.cube), "x");
        return x;
    }

    private int getPosY() {
        int y = UIHelper.getIntProperty(this.cube.getRoot(), UIHelper.getId(this.cube.getDataSet(), this.cube), "y");
        return y;
    }

    private int setPosX(int x) {
        try {
            UIHelper.setIntProperty(this.cube.getRoot(), UIHelper.getId(this.cube.getDataSet(), this.cube), "x", x);
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        return x;
    }

    private int setPosY(int y) {
        try {
            UIHelper.setIntProperty(this.cube.getRoot(), UIHelper.getId(this.cube.getDataSet(), this.cube), "y", y);
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        return y;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new TableSelectionEditPolicy());
    }

    @Override
    public IFigure getChopFigure() {
        return null;
    }

    public IFigure getContentPane() {
        return this.tableNode;
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (this.isActive() && !this.isDelete()) {
            this.refresh();
        }
    }

    public void deactivate() {
        super.deactivate();
        this.cube.getRoot().removeListener((Listener)this);
    }

    public void activate() {
        super.activate();
        this.cube.getRoot().addListener((Listener)this);
    }

    public DragTracker getDragTracker(Request req) {
        DragEditPartsTracker track = new DragEditPartsTracker((EditPart)this);
        return track;
    }

    public TabularCubeHandle getCube() {
        return this.cube;
    }
}

