/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.content;

import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.ContentFactory;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.content.BlockStackingExecutor;

public class BlockStackingExecutorTest
extends TestCase {
    public void testBlockStacking() throws BirtException {
        IReportContent report = ContentFactory.createReportContent();
        IContainerContent container = report.createContainerContent();
        ILabelContent label1 = this.createBlockLabel(report);
        container.getChildren().add(label1);
        ILabelContent label2 = this.createInlineLabel(report);
        container.getChildren().add(label2);
        ILabelContent label3 = this.createInlineLabel(report);
        container.getChildren().add(label3);
        ILabelContent label4 = this.createBlockLabel(report);
        container.getChildren().add(label4);
        ILabelContent label5 = this.createInlineLabel(report);
        container.getChildren().add(label5);
        ILabelContent label6 = this.createBlockLabel(report);
        container.getChildren().add(label6);
        DOMReportItemExecutor executor = new DOMReportItemExecutor((IContent)container);
        BlockStackingExecutor blockStacking = new BlockStackingExecutor(executor.execute(), (IReportItemExecutor)executor);
        BlockStackingExecutorTest.assertTrue((boolean)blockStacking.hasNextChild());
        IReportItemExecutor child = blockStacking.getNextChild();
        BlockStackingExecutorTest.assertTrue((child.execute() == label1 ? 1 : 0) != 0);
        BlockStackingExecutorTest.assertTrue((boolean)blockStacking.hasNextChild());
        child = blockStacking.getNextChild();
        BlockStackingExecutorTest.assertTrue((child.execute() == null ? 1 : 0) != 0);
        BlockStackingExecutorTest.assertTrue((boolean)child.hasNextChild());
        BlockStackingExecutorTest.assertTrue((child.getNextChild().execute() == label2 ? 1 : 0) != 0);
        BlockStackingExecutorTest.assertTrue((child.getNextChild().execute() == label3 ? 1 : 0) != 0);
        BlockStackingExecutorTest.assertFalse((boolean)child.hasNextChild());
        BlockStackingExecutorTest.assertTrue((boolean)blockStacking.hasNextChild());
        child = blockStacking.getNextChild();
        BlockStackingExecutorTest.assertTrue((child.execute() == label4 ? 1 : 0) != 0);
        BlockStackingExecutorTest.assertFalse((boolean)child.hasNextChild());
        BlockStackingExecutorTest.assertTrue((boolean)blockStacking.hasNextChild());
        child = blockStacking.getNextChild();
        BlockStackingExecutorTest.assertTrue((child.execute() == null ? 1 : 0) != 0);
        BlockStackingExecutorTest.assertTrue((boolean)child.hasNextChild());
        BlockStackingExecutorTest.assertTrue((child.getNextChild().execute() == label5 ? 1 : 0) != 0);
        BlockStackingExecutorTest.assertFalse((boolean)child.hasNextChild());
        BlockStackingExecutorTest.assertTrue((boolean)blockStacking.hasNextChild());
        child = blockStacking.getNextChild();
        BlockStackingExecutorTest.assertTrue((child.execute() == label6 ? 1 : 0) != 0);
        BlockStackingExecutorTest.assertFalse((boolean)child.hasNextChild());
        BlockStackingExecutorTest.assertFalse((boolean)blockStacking.hasNextChild());
    }

    protected ILabelContent createBlockLabel(IReportContent report) {
        ILabelContent label = report.createLabelContent();
        label.getStyle().setDisplay("block");
        return label;
    }

    protected ILabelContent createInlineLabel(IReportContent report) {
        ILabelContent label = report.createLabelContent();
        label.getStyle().setDisplay("inline");
        return label;
    }
}

