/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.StyleEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_121524
extends BaseTestCase {
    public void test_regression_121524() throws SemanticException {
        SessionHandle sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.ENGLISH);
        ReportDesignHandle designHandle = sessionHandle.createDesign();
        ElementFactory factory = designHandle.getElementFactory();
        TableHandle tableHandle = factory.newTableItem("table1");
        designHandle.getBody().add((DesignElementHandle)tableHandle);
        MyListener listener = new MyListener();
        tableHandle.addListener((Listener)listener);
        SharedStyleHandle style = factory.newStyle("s1");
        style.setBorderBottomStyle("dotted");
        designHandle.getStyles().add((DesignElementHandle)style);
        tableHandle.setStyleName("s1");
        Regression_121524.assertEquals((String)"dotted", (String)tableHandle.getStringProperty("borderBottomStyle"));
        designHandle.findStyle("s1").drop();
        Regression_121524.assertTrue((boolean)(listener.event instanceof StyleEvent));
        Regression_121524.assertEquals((String)"table1", (String)listener.focus.getName());
        Regression_121524.assertEquals((String)"none", (String)tableHandle.getStringProperty("borderBottomStyle"));
    }

    class MyListener
    implements Listener {
        NotificationEvent event = null;
        DesignElementHandle focus = null;

        MyListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.event = ev;
            this.focus = focus;
        }
    }
}

