/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileDocumentManagerTest {
    protected IDocumentManager documentManager;
    private static final String DOCUMENT_OBJECT = "docObj";
    private int[] ints;
    private double[] doubles;
    private String[] strings;
    private boolean[] booleans;
    private Date[] dates;
    private BigDecimal[] bigDecimals;
    private Bytes[] bytes;

    public FileDocumentManagerTest() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        this.ints = nArray;
        this.doubles = new double[]{0.0, 1.11, 2.22, 3.33, 4.44, 5.55};
        this.strings = new String[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff"};
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        this.booleans = blArray;
        this.dates = new Date[]{new Date(), new Date(), new Date(), new Date(), new Date(), new Date()};
        this.bigDecimals = new BigDecimal[]{new BigDecimal(0.0), new BigDecimal(1.11), new BigDecimal(2.22), new BigDecimal(3.33), new BigDecimal(4.44), new BigDecimal(5.55)};
        this.bytes = new Bytes[6];
        int i = 0;
        while (i < this.bytes.length) {
            this.bytes[i] = new Bytes(this.generateBytes(this.generateRandomInt(100)));
            ++i;
        }
    }

    @Before
    public void fileDocumentManagerSetUp() throws Exception {
        this.documentManager = DocumentManagerFactory.createFileDocumentManager();
    }

    @After
    public void fileDocumentManagerTearDown() throws Exception {
        this.documentManager.close();
    }

    private IDocumentObject[] generateDocumentObjects(int length) throws IOException {
        String[] docObjNames = this.generateDocumentObjectName(length);
        IDocumentObject[] docObjs = new IDocumentObject[length];
        int i = 0;
        while (i < docObjs.length) {
            this.documentManager.createDocumentObject(docObjNames[i]);
            docObjs[i] = this.openIDocumentObject(docObjNames[i]);
            ++i;
        }
        return docObjs;
    }

    protected IDocumentObject openIDocumentObject(String documentObjectName) throws IOException {
        return this.documentManager.openDocumentObject(documentObjectName);
    }

    private String[] generateDocumentObjectName(int length) {
        String[] docObjNames = new String[length];
        int i = 0;
        while (i < docObjNames.length) {
            docObjNames[i] = DOCUMENT_OBJECT + i;
            ++i;
        }
        return docObjNames;
    }

    private byte[] generateBytes(int length) {
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = new Integer(i).byteValue();
            ++i;
        }
        return bytes;
    }

    private void closeDocumentObjects(IDocumentObject[] dos) throws IOException {
        IDocumentObject[] iDocumentObjectArray = dos;
        int n = dos.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentObject ido = iDocumentObjectArray[n2];
            ido.close();
            ++n2;
        }
    }

    protected int generateRandomInt(int limits) {
        return new Double(Math.random() * (double)limits).intValue();
    }

    @Test
    public void testEOFException() throws IOException {
        IDocumentObject[] docObjs = this.generateDocumentObjects(1);
        long pointer = docObjs[0].getFilePointer();
        docObjs[0].writeDouble(this.doubles[0]);
        docObjs[0].seek(pointer);
        docObjs[0].readDouble();
        try {
            docObjs[0].readDouble();
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(e instanceof EOFException));
        }
        this.closeDocumentObjects(docObjs);
    }

    @Test
    public void testZero() throws IOException {
        IDocumentObject[] docObjs = this.generateDocumentObjects(1);
        long pointer = docObjs[0].getFilePointer();
        byte[] out = this.generateBytes(0);
        docObjs[0].write(out, 0, out.length);
        docObjs[0].seek(pointer);
        try {
            docObjs[0].readByte();
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(e instanceof EOFException));
        }
        this.closeDocumentObjects(docObjs);
    }

    @Test
    public void testMinusOne() throws IOException {
        IDocumentObject[] docObjs = this.generateDocumentObjects(1);
        byte[] in = new byte[5];
        docObjs[0].writeInt(this.ints[1]);
        Assert.assertEquals((long)-1L, (long)docObjs[0].read(in, 0, in.length));
        this.closeDocumentObjects(docObjs);
    }

    @Test
    public void testDouble() throws IOException {
        IDocumentObject[] docObjs = this.generateDocumentObjects(1);
        long pointer = docObjs[0].getFilePointer();
        int i = 0;
        while (i < this.doubles.length) {
            docObjs[0].writeDouble(this.doubles[i]);
            ++i;
        }
        docObjs[0].seek(pointer);
        i = 0;
        while (i < this.doubles.length) {
            Assert.assertEquals((double)docObjs[0].readDouble(), (double)this.doubles[i], (double)2.0);
            ++i;
        }
        this.closeDocumentObjects(docObjs);
    }

    @Test
    public void testInt() throws IOException {
        IDocumentObject[] docObjs = this.generateDocumentObjects(1);
        long pointer = docObjs[0].getFilePointer();
        int i = 0;
        while (i < this.ints.length) {
            docObjs[0].writeInt(this.ints[i]);
            ++i;
        }
        docObjs[0].seek(pointer);
        i = 0;
        while (i < this.ints.length) {
            Assert.assertEquals((long)docObjs[0].readInt(), (long)this.ints[i]);
            ++i;
        }
        this.closeDocumentObjects(docObjs);
    }

    @Test
    public void testString() throws IOException {
        IDocumentObject[] docObjs = this.generateDocumentObjects(1);
        long pointer = docObjs[0].getFilePointer();
        int i = 0;
        while (i < this.strings.length) {
            docObjs[0].writeString(this.strings[i]);
            ++i;
        }
        docObjs[0].seek(pointer);
        i = 0;
        while (i < this.strings.length) {
            Assert.assertEquals((Object)docObjs[0].readString(), (Object)this.strings[i]);
            ++i;
        }
        this.closeDocumentObjects(docObjs);
    }

    @Test
    public void testBoolean() throws IOException {
        IDocumentObject[] docObjs = this.generateDocumentObjects(1);
        long pointer = docObjs[0].getFilePointer();
        int i = 0;
        while (i < this.booleans.length) {
            docObjs[0].writeBoolean(this.booleans[i]);
            ++i;
        }
        docObjs[0].seek(pointer);
        i = 0;
        while (i < this.booleans.length) {
            Assert.assertEquals((Object)docObjs[0].readBoolean(), (Object)this.booleans[i]);
            ++i;
        }
        this.closeDocumentObjects(docObjs);
    }

    @Test
    public void testDate() throws IOException {
        IDocumentObject[] docObjs = this.generateDocumentObjects(1);
        long pointer = docObjs[0].getFilePointer();
        int i = 0;
        while (i < this.dates.length) {
            docObjs[0].writeDate(this.dates[i]);
            ++i;
        }
        docObjs[0].seek(pointer);
        i = 0;
        while (i < this.dates.length) {
            Assert.assertEquals((Object)docObjs[0].readDate(), (Object)this.dates[i]);
            ++i;
        }
        this.closeDocumentObjects(docObjs);
    }

    @Test
    public void testBigDecimal() throws IOException {
        IDocumentObject[] docObjs = this.generateDocumentObjects(1);
        long pointer = docObjs[0].getFilePointer();
        int i = 0;
        while (i < this.bigDecimals.length) {
            docObjs[0].writeBigDecimal(this.bigDecimals[i]);
            ++i;
        }
        docObjs[0].seek(pointer);
        i = 0;
        while (i < this.bigDecimals.length) {
            Assert.assertEquals((Object)docObjs[0].readBigDecimal(), (Object)this.bigDecimals[i]);
            ++i;
        }
        this.closeDocumentObjects(docObjs);
    }

    @Test
    public void testBytes() throws IOException {
        IDocumentObject[] docObjs = this.generateDocumentObjects(1);
        long pointer = docObjs[0].getFilePointer();
        int i = 0;
        while (i < this.bytes.length) {
            docObjs[0].writeBytes(this.bytes[i]);
            ++i;
        }
        docObjs[0].seek(pointer);
        i = 0;
        while (i < this.bytes.length) {
            Assert.assertEquals((Object)docObjs[0].readBytes(), (Object)this.bytes[i]);
            ++i;
        }
        this.closeDocumentObjects(docObjs);
    }

    @Test
    public void testShort() throws IOException {
        IDocumentObject[] docObjs = this.generateDocumentObjects(1);
        long pointer = docObjs[0].getFilePointer();
        int i = 0;
        while (i < this.ints.length) {
            docObjs[0].writeShort(this.ints[i]);
            ++i;
        }
        docObjs[0].seek(pointer);
        i = 0;
        while (i < this.ints.length) {
            Assert.assertEquals((long)docObjs[0].readShort(), (long)this.ints[i]);
            ++i;
        }
        this.closeDocumentObjects(docObjs);
    }

    @Test
    public void testMixed() throws IOException {
        IDocumentObject[] docObjs = this.generateDocumentObjects(1);
        long pointer = docObjs[0].getFilePointer();
        int i = 0;
        while (i < this.bigDecimals.length) {
            docObjs[0].writeBigDecimal(this.bigDecimals[i]);
            docObjs[0].writeBoolean(this.booleans[i]);
            docObjs[0].writeBytes(this.bytes[i]);
            docObjs[0].writeDate(this.dates[i]);
            docObjs[0].writeDouble(this.doubles[i]);
            docObjs[0].writeInt(this.ints[i]);
            docObjs[0].writeShort(this.ints[i]);
            docObjs[0].writeString(this.strings[i]);
            ++i;
        }
        docObjs[0].seek(pointer);
        i = 0;
        while (i < this.bigDecimals.length) {
            Assert.assertEquals((Object)docObjs[0].readBigDecimal(), (Object)this.bigDecimals[i]);
            Assert.assertEquals((Object)docObjs[0].readBoolean(), (Object)this.booleans[i]);
            Assert.assertEquals((Object)docObjs[0].readBytes(), (Object)this.bytes[i]);
            Assert.assertEquals((Object)docObjs[0].readDate(), (Object)this.dates[i]);
            Assert.assertEquals((double)docObjs[0].readDouble(), (double)this.doubles[i], (double)2.0);
            Assert.assertEquals((long)docObjs[0].readInt(), (long)this.ints[i]);
            Assert.assertEquals((long)docObjs[0].readShort(), (long)this.ints[i]);
            Assert.assertEquals((Object)docObjs[0].readString(), (Object)this.strings[i]);
            ++i;
        }
        this.closeDocumentObjects(docObjs);
    }

    @Test
    public void testFilePointer() throws IOException {
        IDocumentObject[] docObjs = this.generateDocumentObjects(1);
        byte[] out = this.generateBytes(1023);
        docObjs[0].write(out, 0, out.length);
        Assert.assertEquals((long)out.length, (long)docObjs[0].getFilePointer());
        docObjs[0].write(out, 0, 25);
        Assert.assertEquals((long)1048L, (long)docObjs[0].getFilePointer());
        this.closeDocumentObjects(docObjs);
    }

    @Test
    public void testBuffer() throws IOException {
        IDocumentObject[] docObjs = this.generateDocumentObjects(2);
        long pointer = docObjs[0].getFilePointer();
        byte[] out = this.generateBytes(1025);
        docObjs[0].write(out, 0, 1023);
        docObjs[0].write(out, 1023, 2);
        docObjs[0].seek(pointer);
        int i = 0;
        while (i < out.length) {
            Assert.assertEquals((long)docObjs[0].readByte(), (long)out[i]);
            ++i;
        }
        docObjs[0].close();
        pointer = docObjs[1].getFilePointer();
        docObjs[1].write(out, 0, out.length);
        docObjs[1].seek(pointer);
        i = 0;
        while (i < out.length) {
            Assert.assertEquals((long)docObjs[1].readByte(), (long)out[i]);
            ++i;
        }
        this.closeDocumentObjects(docObjs);
    }

    @Test
    public void testChunk() throws IOException {
        IDocumentObject[] docObjs = this.generateDocumentObjects(2);
        long pointer0 = docObjs[0].getFilePointer();
        long pointer1 = docObjs[1].getFilePointer();
        byte[] out = this.generateBytes(5120);
        docObjs[0].write(out, 0, 4000);
        docObjs[1].write(out, 0, 5120);
        docObjs[0].write(out, 4000, 1120);
        docObjs[0].seek(pointer0);
        int i = 0;
        while (i < out.length) {
            Assert.assertEquals((long)docObjs[0].readByte(), (long)out[i]);
            ++i;
        }
        docObjs[1].seek(pointer1);
        i = 0;
        while (i < out.length) {
            Assert.assertEquals((long)docObjs[1].readByte(), (long)out[i]);
            ++i;
        }
        this.closeDocumentObjects(docObjs);
    }

    @Test
    public void testStressVariable() throws IOException {
        int length = 50;
        IDocumentObject[] docObjs = this.generateDocumentObjects(length);
        long[] pointer = new long[length];
        byte[][] out = new byte[length][];
        int i = 0;
        while (i < docObjs.length) {
            out[i] = this.generateBytes(1024 * this.generateRandomInt(200));
            pointer[i] = docObjs[i].getFilePointer();
            docObjs[i].write(out[i], 0, out[i].length);
            ++i;
        }
        i = 0;
        while (i < docObjs.length) {
            docObjs[i].seek(pointer[i]);
            int j = 0;
            while (j < out[i].length) {
                Assert.assertEquals((long)docObjs[i].readByte(), (long)out[i][j]);
                ++j;
            }
            docObjs[i].close();
            ++i;
        }
    }

    @Test
    public void testStressFixed() throws IOException {
        int length = 100;
        IDocumentObject[] docObjs = this.generateDocumentObjects(length);
        long[] pointer = new long[length];
        byte[] out = this.generateBytes(102400);
        int i = 0;
        while (i < docObjs.length) {
            pointer[i] = docObjs[i].getFilePointer();
            docObjs[i].write(out, 0, out.length);
            ++i;
        }
        i = 0;
        while (i < docObjs.length) {
            docObjs[i].seek(pointer[i]);
            int j = 0;
            while (j < out.length) {
                Assert.assertEquals((long)docObjs[i].readByte(), (long)out[j]);
                ++j;
            }
            docObjs[i].close();
            ++i;
        }
    }

    @Test
    public void testLoadFileDocumentManager() throws IOException, DataException {
        this.documentManager.createDocumentObject(DOCUMENT_OBJECT);
        IDocumentObject obj = this.documentManager.openDocumentObject(DOCUMENT_OBJECT);
        obj.writeBoolean(true);
        obj.close();
        this.documentManager.close();
        this.documentManager = DocumentManagerFactory.loadFileDocumentManager();
        obj = this.documentManager.openDocumentObject(DOCUMENT_OBJECT);
        Assert.assertTrue((boolean)obj.readBoolean());
        obj.close();
    }
}

