/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ExpressionListHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TOCHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.util.BaseTestCase;
import org.eclipse.birt.report.model.util.ModelUtil;

public class ExpressionTest
extends BaseTestCase {
    private static final String INPUT_FILE = "ExpressionTest.xml";

    public void testGetAndSetValuesOnElement() throws Exception {
        this.openDesign(INPUT_FILE);
        ScalarParameterHandle param = (ScalarParameterHandle)this.designHandle.findParameter("Param1");
        List values = (ArrayList<Expression>)param.getProperty("defaultValue");
        ExpressionTest.assertEquals((int)3, (int)values.size());
        ExpressionTest.equals((Expression)values.get(0), "value1", "constant");
        ExpressionTest.equals((Expression)values.get(1), "value2", "constant");
        ExpressionTest.equals((Expression)values.get(2), "value3", "javascript");
        values = new ArrayList<Expression>();
        values.add(new Expression((Object)"value1", "javascript"));
        values.add(new Expression((Object)"123", "constant"));
        param.setProperty("defaultValue", values);
        values = param.getListProperty("defaultValue");
        ExpressionTest.assertEquals((int)2, (int)values.size());
        ExpressionTest.equals((Expression)values.get(0), "value1", "javascript");
        ExpressionTest.equals((Expression)values.get(1), "123", "constant");
        DataItemHandle tmpItem = (DataItemHandle)this.designHandle.findElement("bodyData");
        ExpressionHandle exprHandle = tmpItem.getExpressionProperty("bookmark");
        ExpressionTest.assertEquals((Object)"true", (Object)exprHandle.getExpression());
        ExpressionTest.assertEquals((String)"javascript", (String)exprHandle.getType());
        exprHandle.setExpression((Object)"123");
        exprHandle.setType("constant");
        Expression expr = (Expression)tmpItem.getElement().getProperty((Module)this.design, "bookmark");
        ExpressionTest.equals(expr, "123", "constant");
        Object tmpValue = tmpItem.getProperty("onRender");
        ExpressionTest.assertTrue((boolean)(tmpValue instanceof String));
    }

    private static void equals(Expression expr, Object expr1, String type) {
        assert (expr != null);
        if (!ModelUtil.isEquals((Object)expr.getExpression(), (Object)expr1)) {
            ExpressionTest.assertTrue((boolean)false);
        }
        if (!ModelUtil.isEquals((Object)expr.getType(), (Object)type)) {
            ExpressionTest.assertTrue((boolean)false);
        }
    }

    public void testCopy() throws Exception {
        this.openDesign(INPUT_FILE);
        ScalarParameterHandle param = (ScalarParameterHandle)this.designHandle.findParameter("Param1");
        List values = (List)param.getProperty("defaultValue");
        List cloned = (List)ModelUtil.copyValue((IPropertyDefn)param.getPropertyDefn("defaultValue"), (Object)values);
        ExpressionTest.assertEquals((int)3, (int)cloned.size());
        ExpressionTest.equals((Expression)cloned.get(0), "value1", "constant");
        ExpressionTest.equals((Expression)cloned.get(1), "value2", "constant");
        ExpressionTest.equals((Expression)cloned.get(2), "value3", "javascript");
        ExpressionTest.assertTrue((cloned.get(0) != values.get(0) ? 1 : 0) != 0);
        ExpressionTest.assertTrue((cloned.get(1) != values.get(1) ? 1 : 0) != 0);
        ExpressionTest.assertTrue((cloned.get(2) != values.get(2) ? 1 : 0) != 0);
    }

    public void testGetAndSetValuesOnStructure() throws Exception {
        this.createDesign();
        TableHandle table = this.designHandle.getElementFactory().newTableItem("table1");
        this.designHandle.getBody().add((DesignElementHandle)table);
        PropertyHandle propHandle = table.getPropertyHandle("sort");
        SortKey sortKey = StructureFactory.createSortKey();
        sortKey.setProperty("key", (Object)new Expression((Object)"expression", "javascript"));
        propHandle.addItem((IStructure)sortKey);
        Iterator iter = propHandle.iterator();
        SortKeyHandle sortHandle = (SortKeyHandle)iter.next();
        ExpressionTest.assertEquals((String)"expression", (String)sortHandle.getKey());
        ExpressionHandle tmpExpr = sortHandle.getExpressionProperty("key");
        ExpressionTest.assertEquals((String)"expression", (String)sortHandle.getKey());
        ExpressionTest.assertEquals((String)"expression", (String)tmpExpr.getStringExpression());
        ExpressionTest.assertEquals((String)"javascript", (String)tmpExpr.getType());
        sortHandle.setProperty("key", (Object)new Expression((Object)"new expression", "javascript"));
        ExpressionTest.assertEquals((String)"new expression", (String)sortHandle.getKey());
    }

    public void testExpressionListHandle() throws Exception {
        this.openDesign("CompatibleValue1Test.xml");
        SharedStyleHandle tmpStyle = this.designHandle.findStyle("My-Style");
        Iterator iter1 = tmpStyle.highlightRulesIterator();
        HighlightRuleHandle tmpHighlight = (HighlightRuleHandle)iter1.next();
        ExpressionListHandle tmpHandle = tmpHighlight.getValue1ExpressionList();
        List tmpValues = tmpHandle.getListValue();
        ExpressionTest.equals((Expression)tmpValues.get(0), "hi_value1", "javascript");
        ExpressionTest.equals((Expression)tmpValues.get(1), "hi_value2", "constant");
        iter1 = tmpStyle.mapRulesIterator();
        MapRuleHandle tmpMapRule = (MapRuleHandle)iter1.next();
        tmpHandle = tmpMapRule.getValue1ExpressionList();
        tmpValues = tmpHandle.getListValue();
        ExpressionTest.equals((Expression)tmpValues.get(0), "map_value1", "javascript");
        ExpressionTest.equals((Expression)tmpValues.get(1), "map_value2", "constant");
        ArrayList<Expression> newValues = new ArrayList<Expression>();
        newValues.add(new Expression((Object)"new a", "constant"));
        newValues.add(new Expression((Object)"new b", "constant"));
        newValues.add(new Expression((Object)"new c", "constant"));
        tmpHandle.setListValue(newValues);
        tmpValues = tmpHandle.getListValue();
        ExpressionTest.equals((Expression)tmpValues.get(0), "new a", "constant");
        ExpressionTest.equals((Expression)tmpValues.get(1), "new b", "constant");
        ExpressionTest.equals((Expression)tmpValues.get(2), "new c", "constant");
        DesignElementHandle testTable = this.designHandle.findElement("testTable");
        List valueList = testTable.getListProperty("filter");
        FilterConditionElementHandle filter = (FilterConditionElementHandle)valueList.get(0);
        tmpHandle = filter.getValue1ExpressionList();
        tmpValues = tmpHandle.getListValue();
        ExpressionTest.equals((Expression)tmpValues.get(0), "filter_value1", "javascript");
        ExpressionTest.equals((Expression)tmpValues.get(1), "filter_value2", "javascript");
        tmpHandle.setListValue(newValues);
        tmpValues = tmpHandle.getListValue();
        ExpressionTest.equals((Expression)tmpValues.get(0), "new a", "constant");
        ExpressionTest.equals((Expression)tmpValues.get(1), "new b", "constant");
        ExpressionTest.equals((Expression)tmpValues.get(2), "new c", "constant");
        TableHandle tmpTable = (TableHandle)this.designHandle.findElement("table1");
        iter1 = tmpTable.getPrivateStyle().mapRulesIterator();
        tmpMapRule = (MapRuleHandle)iter1.next();
        tmpHandle = tmpMapRule.getValue1ExpressionList();
        tmpValues = tmpHandle.getListValue();
        ExpressionTest.equals((Expression)tmpValues.get(0), "1", "constant");
        ExpressionTest.equals((Expression)tmpValues.get(1), "2", "constant");
        ExpressionTest.equals((Expression)tmpValues.get(2), "4", "constant");
    }

    public void testConstantTypeOnAction() throws Exception {
        this.openDesign(INPUT_FILE);
        ActionHandle actionHandle = ((ImageHandle)this.designHandle.findElement("Image1")).getActionHandle();
        ExpressionHandle exprHandle = actionHandle.getExpressionProperty("uri");
        ExpressionTest.assertEquals((String)"constant", (String)exprHandle.getType());
    }

    public void testTOC() throws Exception {
        this.openDesign(INPUT_FILE);
        DataItemHandle tmpData = (DataItemHandle)this.designHandle.findElement("bodyData");
        TOCHandle tocHandle = tmpData.getTOC();
        TOC toc = (TOC)tocHandle.getStructure();
        toc.setExpression("new statistics");
        ExpressionHandle exprHandle = tocHandle.getExpressionProperty("expressionValue");
        ExpressionTest.assertEquals((String)"javascript", (String)exprHandle.getType());
    }
}

