/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefPropertyType;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefnFake;
import org.eclipse.birt.report.model.metadata.PropertyTypeTestCase;

public class ElementRefPropertyTypeTest
extends PropertyTypeTestCase {
    ElementRefPropertyType type = new ElementRefPropertyType();
    PropertyDefn propDefn = new PropertyDefnFake();
    OdaDataSource ds1 = null;
    OdaDataSource ds2 = null;
    Label label1 = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.propDefn = (ElementPropertyDefn)MetaDataDictionary.getInstance().getElement("OdaDataSet").getProperty("dataSource");
        ElementDefn elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement("OdaDataSource");
        this.ds1 = new OdaDataSource("ds1");
        this.ds2 = new OdaDataSource("ds2");
        this.label1 = new Label("label1");
        this.design.getNameHelper().getNameSpace(elemDefn.getNameSpaceID()).insert((DesignElement)this.ds1);
        this.design.getNameHelper().getNameSpace(elemDefn.getNameSpaceID()).insert((DesignElement)this.label1);
    }

    @Override
    public void testGetTypeCode() {
        ElementRefPropertyTypeTest.assertEquals((int)15, (int)this.type.getTypeCode());
    }

    @Override
    public void testGetName() {
        ElementRefPropertyTypeTest.assertEquals((String)"elementRef", (String)this.type.getName());
    }

    @Override
    public void testValidateValue() throws PropertyValueException {
        ElementRefPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, this.propDefn, null));
        ElementRefPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)""));
        ElementRefValue refValue = (ElementRefValue)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"ds1");
        ElementRefPropertyTypeTest.assertTrue((this.ds1 == refValue.getElement() ? 1 : 0) != 0);
        refValue = (ElementRefValue)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"ds2");
        ElementRefPropertyTypeTest.assertEquals((String)"ds2", (String)refValue.getName());
        try {
            this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"label1");
            ElementRefPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            ElementRefPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.WRONG_ELEMENT_TYPE", (String)e.getErrorCode());
        }
        refValue = (ElementRefValue)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)this.ds1);
        ElementRefPropertyTypeTest.assertTrue((this.ds1 == refValue.getElement() ? 1 : 0) != 0);
        try {
            this.type.validateValue((Module)this.design, null, this.propDefn, (Object)this.label1);
            ElementRefPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            ElementRefPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.WRONG_ELEMENT_TYPE", (String)e.getErrorCode());
        }
        try {
            this.type.validateValue((Module)this.design, null, this.propDefn, new Object());
            ElementRefPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            ElementRefPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    @Override
    public void testValidateInputString() throws PropertyValueException {
    }

    @Override
    public void testValidateXml() throws PropertyValueException {
    }

    @Override
    public void testToDouble() {
    }

    @Override
    public void testToInteger() {
    }

    @Override
    public void testToXml() {
        ElementRefPropertyTypeTest.assertEquals(null, (String)this.type.toXml((Module)this.design, this.propDefn, null));
        ElementRefPropertyTypeTest.assertEquals((String)"Element", (String)this.type.toXml((Module)this.design, this.propDefn, (Object)new ElementRefValue(null, "Element")));
    }

    @Override
    public void testToString() {
        ElementRefPropertyTypeTest.assertEquals(null, (String)this.type.toString((Module)this.design, this.propDefn, null));
        ElementRefPropertyTypeTest.assertEquals((String)"Element", (String)this.type.toString((Module)this.design, this.propDefn, (Object)new ElementRefValue(null, "Element")));
    }

    @Override
    public void testToDisplayString() {
        ElementRefPropertyTypeTest.assertEquals(null, (String)this.type.toDisplayString((Module)this.design, this.propDefn, null));
        ElementRefPropertyTypeTest.assertEquals((String)"Element", (String)this.type.toDisplayString((Module)this.design, this.propDefn, (Object)new ElementRefValue(null, "Element")));
    }

    public void testResolve() {
        ElementRefValue refValue = new ElementRefValue(null, "ds1");
        this.type.resolve((Module)this.design, null, this.propDefn, refValue);
        ElementRefPropertyTypeTest.assertTrue((boolean)refValue.isResolved());
    }

    @Override
    public void testToNumber() {
    }

    @Override
    public void testToBoolean() {
    }
}

