/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.validators;

import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.validators.DataSetRequiredValidator;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.validators.ValidatorTestCase;

public class DataSetRequiredValidatorTest
extends ValidatorTestCase {
    ValidatorTestCase.MyListener listener = new ValidatorTestCase.MyListener(this);

    public void testDataSetRequiredValidator() throws Exception {
        this.createDesign();
        MetaDataDictionary.getInstance().setUseValidationTrigger(true);
        TableHandle tableHandle = this.designHandle.getElementFactory().newTableItem("table1");
        this.designHandle.addValidationListener((IValidationListener)this.listener);
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        DataSetRequiredValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)tableHandle, DataSetRequiredValidator.getInstance().getName(), "Error.SemanticError.MISSING_DATA_SET"));
        OdaDataSetHandle dataSetHandle = this.designHandle.getElementFactory().newOdaDataSet("dataset1");
        this.designHandle.getDataSets().add((DesignElementHandle)dataSetHandle);
        DataSetRequiredValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)tableHandle, DataSetRequiredValidator.getInstance().getName(), "Error.SemanticError.MISSING_DATA_SET"));
        tableHandle.setDataSet((DataSetHandle)dataSetHandle);
        DataSetRequiredValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)tableHandle, DataSetRequiredValidator.getInstance().getName(), "Error.SemanticError.MISSING_DATA_SET"));
    }
}

