/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.validators;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.MasterPageRequiredValidator;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.validators.ValidatorTestCase;

public class MasterPageRequiredValidatorTest
extends ValidatorTestCase {
    ValidatorTestCase.MyListener listener = new ValidatorTestCase.MyListener(this);

    public void testTriggers() throws Exception {
        this.createDesign();
        MetaDataDictionary.getInstance().setUseValidationTrigger(true);
        this.designHandle.addValidationListener((IValidationListener)this.listener);
        SimpleMasterPageHandle pageHandle = this.designHandle.getElementFactory().newSimpleMasterPage("masterPage1");
        this.designHandle.getMasterPages().add((DesignElementHandle)pageHandle);
        MasterPageRequiredValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)this.designHandle, MasterPageRequiredValidator.getInstance().getName(), "Error.SemanticError.MISSING_MASTER_PAGE"));
        pageHandle.dropAndClear();
        MasterPageRequiredValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)this.designHandle, MasterPageRequiredValidator.getInstance().getName(), "Error.SemanticError.MISSING_MASTER_PAGE"));
        this.designHandle.getMasterPages().add((DesignElementHandle)pageHandle);
        MasterPageRequiredValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)this.designHandle, MasterPageRequiredValidator.getInstance().getName(), "Error.SemanticError.MISSING_MASTER_PAGE"));
    }
}

