/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import java.util.Properties;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.shared.common.error.StandardException;

class IndexToBaseRowNode
extends FromTable {
    protected FromBaseTable source;
    protected ConglomerateDescriptor baseCD;
    protected boolean cursorTargetTable;
    protected PredicateList restrictionList;
    protected boolean forUpdate;
    private FormatableBitSet heapReferencedCols;
    private FormatableBitSet indexReferencedCols;
    private FormatableBitSet allReferencedCols;
    private FormatableBitSet heapOnlyReferencedCols;

    IndexToBaseRowNode(FromBaseTable source, ConglomerateDescriptor baseCD, ResultColumnList resultColumns, boolean cursorTargetTable, FormatableBitSet heapReferencedCols, FormatableBitSet indexReferencedCols, PredicateList restrictionList, boolean forUpdate, Properties tableProperties, ContextManager cm) {
        super(null, tableProperties, cm);
        this.source = source;
        this.baseCD = baseCD;
        this.setResultColumns(resultColumns);
        this.cursorTargetTable = cursorTargetTable;
        this.restrictionList = restrictionList;
        this.forUpdate = forUpdate;
        this.heapReferencedCols = heapReferencedCols;
        this.indexReferencedCols = indexReferencedCols;
        if (this.indexReferencedCols == null) {
            this.allReferencedCols = this.heapReferencedCols;
            this.heapOnlyReferencedCols = this.heapReferencedCols;
        } else {
            this.allReferencedCols = new FormatableBitSet(this.heapReferencedCols);
            this.allReferencedCols.or(this.indexReferencedCols);
            this.heapOnlyReferencedCols = new FormatableBitSet(this.allReferencedCols);
            this.heapOnlyReferencedCols.xor(this.indexReferencedCols);
        }
    }

    @Override
    public boolean forUpdate() {
        return this.source.forUpdate();
    }

    @Override
    public AccessPath getTrulyTheBestAccessPath() {
        return this.source.getTrulyTheBestAccessPath();
    }

    @Override
    CostEstimate getCostEstimate() {
        return this.source.getTrulyTheBestAccessPath().getCostEstimate();
    }

    @Override
    CostEstimate getFinalCostEstimate() {
        return this.source.getFinalCostEstimate();
    }

    @Override
    boolean isOrderedOn(ColumnReference[] crs, boolean permuteOrdering, List<FromBaseTable> fbtHolder) throws StandardException {
        return this.source.isOrderedOn(crs, permuteOrdering, fbtHolder);
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        ValueNode restriction = null;
        this.assignResultSetNumber();
        this.setCostEstimate(this.getFinalCostEstimate());
        if (this.restrictionList != null) {
            restriction = this.restrictionList.restorePredicates();
            this.restrictionList = null;
        }
        int heapColRefItem = -1;
        if (this.heapReferencedCols != null) {
            heapColRefItem = acb.addItem(this.heapReferencedCols);
        }
        int allColRefItem = -1;
        if (this.allReferencedCols != null) {
            allColRefItem = acb.addItem(this.allReferencedCols);
        }
        int heapOnlyColRefItem = -1;
        if (this.heapOnlyReferencedCols != null) {
            heapOnlyColRefItem = acb.addItem(this.heapOnlyReferencedCols);
        }
        int indexColMapItem = acb.addItem(new ReferencedColumnsDescriptorImpl(this.getIndexColMapping()));
        long heapConglomNumber = this.baseCD.getConglomerateNumber();
        StaticCompiledOpenConglomInfo scoci = this.getLanguageConnectionContext().getTransactionCompile().getStaticCompiledConglomInfo(heapConglomNumber);
        acb.pushGetResultSetFactoryExpression(mb);
        mb.push(heapConglomNumber);
        mb.push(acb.addItem(scoci));
        this.source.generate(acb, mb);
        mb.upCast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        boolean skipPropagatedCols = this.indexReferencedCols != null && this.indexReferencedCols.getNumBitsSet() != 0;
        mb.push(acb.addItem(this.getResultColumns().buildRowTemplate(this.heapReferencedCols, skipPropagatedCols)));
        mb.push(this.getResultSetNumber());
        mb.push(this.source.getBaseTableName());
        mb.push(heapColRefItem);
        mb.push(allColRefItem);
        mb.push(heapOnlyColRefItem);
        mb.push(indexColMapItem);
        if (restriction == null) {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            restriction.generate(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        mb.push(this.forUpdate);
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.push(this.source.getTableDescriptor().getNumberOfColumns());
        mb.callMethod((short)185, null, "getIndexRowToBaseRowResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 15);
        if (this.cursorTargetTable) {
            acb.rememberCursorTarget(mb);
        }
    }

    @Override
    boolean isOneRowResultSet() throws StandardException {
        return this.source.isOneRowResultSet();
    }

    @Override
    boolean isNotExists() {
        return this.source.isNotExists();
    }

    @Override
    void decrementLevel(int decrement) {
        this.source.decrementLevel(decrement);
    }

    @Override
    int updateTargetLockMode() {
        return this.source.updateTargetLockMode();
    }

    @Override
    void adjustForSortElimination() {
        this.source.disableBulkFetch();
    }

    @Override
    void adjustForSortElimination(RequiredRowOrdering rowOrdering) throws StandardException {
        this.adjustForSortElimination();
        this.source.adjustForSortElimination(rowOrdering);
    }

    private int[] getIndexColMapping() {
        int rclSize = this.getResultColumns().size();
        int[] indexColMapping = new int[rclSize];
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)this.getResultColumns().elementAt(index);
            if (this.indexReferencedCols != null && rc.getExpression() instanceof VirtualColumnNode) {
                VirtualColumnNode vcn = (VirtualColumnNode)rc.getExpression();
                indexColMapping[index] = vcn.getSourceColumn().getVirtualColumnId() - 1;
                continue;
            }
            indexColMapping[index] = -1;
        }
        return indexColMapping;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.source != null) {
            this.source = (FromBaseTable)this.source.accept(v);
        }
    }
}

