/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.ui.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.net4j.buddies.IBuddySession;
import org.eclipse.net4j.buddies.ISessionManager;
import org.eclipse.net4j.buddies.ISessionManagerEvent;
import org.eclipse.net4j.buddies.common.IBuddyStateEvent;
import org.eclipse.net4j.buddies.internal.ui.BuddiesItemProvider;
import org.eclipse.net4j.buddies.internal.ui.actions.ConnectAction;
import org.eclipse.net4j.buddies.internal.ui.actions.DisconnectAction;
import org.eclipse.net4j.buddies.internal.ui.actions.FlashAction;
import org.eclipse.net4j.buddies.internal.ui.actions.ReconnectAction;
import org.eclipse.net4j.buddies.internal.ui.actions.StateAction;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.ContainerView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class SessionManagerView
extends ContainerView
implements IListener {
    private IBuddySession session;
    private ConnectAction connectAction = new ConnectAction();
    private DisconnectAction disconnectAction = new DisconnectAction();
    private ReconnectAction reconnectAction = new ReconnectAction();
    private FlashAction flashAction = new FlashAction();
    private StateAction.DropDownAction dropDownAction = new StateAction.DropDownAction();
    private Control control;

    public IBuddySession getSession() {
        return this.session;
    }

    public void dispose() {
        ISessionManager.INSTANCE.removeListener((IListener)this);
        this.session = null;
        super.dispose();
    }

    public void notifyEvent(IEvent event) {
        if (event instanceof ISessionManagerEvent) {
            this.queryBuddiesManager();
        } else if (event instanceof IBuddyStateEvent && this.session != null && event.getSource() == this.session.getSelf()) {
            this.updateState();
        }
    }

    protected final Control createUI(Composite parent) {
        this.control = this.createControl(parent);
        this.queryBuddiesManager();
        ISessionManager.INSTANCE.addListener((IListener)this);
        return this.control;
    }

    protected Control createControl(Composite parent) {
        return super.createUI(parent);
    }

    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        return new BuddiesItemProvider();
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        super.fillLocalToolBar(manager);
        manager.add((IAction)this.dropDownAction);
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.connectAction);
        manager.add((IAction)this.disconnectAction);
        manager.add((IAction)this.reconnectAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.flashAction);
        super.fillLocalPullDown(manager);
    }

    protected void queryBuddiesManager() {
        IBuddySession oldSession = this.session;
        this.session = ISessionManager.INSTANCE.getSession();
        if (oldSession != this.session) {
            if (oldSession != null) {
                oldSession.removeListener((IListener)this);
                oldSession.getSelf().removeListener((IListener)this);
            }
            if (this.session != null) {
                this.session.addListener((IListener)this);
                this.session.getSelf().addListener((IListener)this);
            }
        }
        this.resetInput();
        this.updateState();
    }

    protected void updateState() {
        this.connectAction.setEnabled(this.session == null);
        this.disconnectAction.setEnabled(this.session != null);
        this.reconnectAction.setEnabled(this.session != null);
        this.flashAction.setEnabled(this.session != null && !ISessionManager.INSTANCE.isFlashing());
        this.dropDownAction.updateState();
    }
}

