/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.IAssemblyManager;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.emf.cdo.lm.util.LMOperations;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPage;

public class DeleteChangeAction
extends LMAction<Change> {
    private ISystemDescriptor systemDescriptor;

    public DeleteChangeAction(IWorkbenchPage page, Change change) {
        super(page, "Delete Change" + INTERACTIVE, "Delete the change '" + change.getLabel() + "'", OM.getImageDescriptor("icons/Delete.gif"), "Delete the change '" + change.getLabel() + "'.", "icons/wizban/Delete.png", change);
    }

    @Override
    public String getAuthorizableOperationID() {
        return LMOperations.DELETE_CHANGE;
    }

    @Override
    protected void preRun() throws Exception {
        Change change = (Change)this.getContext();
        this.systemDescriptor = ISystemManager.INSTANCE.getDescriptor((EObject)change.getSystem());
        super.preRun();
    }

    @Override
    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent) {
        Change change = (Change)this.getContext();
        Label oldLabel = new Label(parent, 0);
        oldLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        oldLabel.setText("Confirm the deletion of change '" + change.getLabel() + "'.\nNote that checkouts will be removed, too. ");
        this.validateDialog();
    }

    @Override
    protected void doRun(Change change, IProgressMonitor monitor) throws Exception {
        IAssemblyDescriptor[] descriptors;
        IAssemblyManager assemblyManager = IAssemblyManager.INSTANCE;
        IAssemblyDescriptor[] iAssemblyDescriptorArray = descriptors = assemblyManager.getDescriptors((Baseline)change);
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IAssemblyDescriptor assemblyDescriptor = iAssemblyDescriptorArray[n2];
            CDOCheckout checkout = assemblyDescriptor.getCheckout();
            checkout.delete(true);
            ++n2;
        }
        this.systemDescriptor.deleteChange(change, monitor);
    }
}

