/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.common;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.ICollaboration;
import org.eclipse.net4j.buddies.common.IFacility;
import org.eclipse.net4j.buddies.common.IFacilityInstalledEvent;
import org.eclipse.net4j.buddies.common.IMembership;
import org.eclipse.net4j.buddies.common.IMessage;
import org.eclipse.net4j.buddies.internal.common.MembershipContainer;
import org.eclipse.net4j.buddies.internal.common.bundle.OM;
import org.eclipse.net4j.buddies.internal.common.protocol.MessageNotification;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class Collaboration
extends MembershipContainer
implements ICollaboration {
    private long id;
    private String title;
    private String description;
    private ICollaboration.Visibility visibility = ICollaboration.Visibility.PRIVATE;
    private ConcurrentMap<String, IFacility> facilities = new ConcurrentHashMap<String, IFacility>();

    public Collaboration(long id) {
        this.id = id;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title == null ? String.valueOf(this.id) : this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ICollaboration.Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public boolean isPublic() {
        return this.visibility == ICollaboration.Visibility.PUBLIC;
    }

    @Override
    public void setPublic(String title, String description) {
        this.visibility = ICollaboration.Visibility.PUBLIC;
        this.title = title;
        this.description = description;
    }

    @Override
    public void setPrivate() {
        this.visibility = ICollaboration.Visibility.PRIVATE;
        this.title = null;
        this.description = null;
    }

    public IMembership getMembership(IBuddy buddy) {
        return this.getMembership(buddy, this);
    }

    public IMembership removeMembership(IBuddy buddy) {
        return this.removeMembership(buddy, this);
    }

    @Override
    public IBuddy getBuddy(String userID) {
        IMembership[] iMembershipArray = this.getMemberships();
        int n = iMembershipArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMembership membership = iMembershipArray[n2];
            IBuddy buddy = membership.getBuddy();
            if (ObjectUtil.equals((Object)buddy.getUserID(), (Object)userID)) {
                return buddy;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IBuddy[] getBuddies() {
        ArrayList<IBuddy> buddies = new ArrayList<IBuddy>();
        IMembership[] iMembershipArray = this.getMemberships();
        int n = iMembershipArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMembership membership = iMembershipArray[n2];
            IBuddy buddy = membership.getBuddy();
            buddies.add(buddy);
            ++n2;
        }
        return buddies.toArray(new IBuddy[buddies.size()]);
    }

    @Override
    public String[] getFacilityTypes() {
        return this.facilities.keySet().toArray(new String[this.facilities.size()]);
    }

    @Override
    public IFacility[] getFacilities() {
        return this.facilities.values().toArray(new IFacility[this.facilities.size()]);
    }

    @Override
    public IFacility getFacility(String type) {
        return (IFacility)this.facilities.get(type);
    }

    public boolean addFacility(IFacility facility, boolean remote) {
        String type = facility.getType();
        if (!this.facilities.containsKey(type)) {
            this.facilities.put(type, facility);
            IListener[] listeners = this.getListeners();
            if (listeners.length != 0) {
                this.fireEvent(new FacilityInstalledEvent(this, facility, remote), listeners);
            }
            facility.addListener(this);
            return true;
        }
        return false;
    }

    public void sendMessage(long collaborationID, String facilityType, IMessage message) {
        IMembership[] elements;
        IMembership[] iMembershipArray = elements = this.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IMembership membership = iMembershipArray[n2];
            IBuddy receiver = membership.getBuddy();
            if (!ObjectUtil.equals((Object)receiver.getUserID(), (Object)message.getSenderID())) {
                try {
                    SignalProtocol protocol = (SignalProtocol)receiver.getSession().getProtocol();
                    new MessageNotification(protocol, collaborationID, facilityType, message).sendAsync();
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            ++n2;
        }
    }

    public Object getAdapter(Class adapter) {
        return AdapterUtil.adapt((Object)this, (Class)adapter, (boolean)false);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ICollaboration) {
            ICollaboration collaboration = (ICollaboration)obj;
            return this.getID() == collaboration.getID();
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtil.hashCode((long)this.id);
    }

    public String toString() {
        return MessageFormat.format("{0}[{1}]", this.getClass().getSimpleName(), this.getTitle());
    }

    @Override
    public void notifyEvent(IEvent event) {
        super.notifyEvent(event);
        if (event.getSource() instanceof IFacility) {
            this.notifyFacilityEvent(event);
        }
    }

    protected void notifyFacilityEvent(IEvent event) {
    }

    @Override
    protected void doDeactivate() throws Exception {
        Object[] objectArray = this.getFacilities();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFacility facility = objectArray[n2];
            facility.removeListener(this);
            LifecycleUtil.deactivate((Object)facility);
            ++n2;
        }
        objectArray = this.getMemberships();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object membership = objectArray[n2];
            LifecycleUtil.deactivate((Object)membership);
            ++n2;
        }
        super.doDeactivate();
    }

    private static final class FacilityInstalledEvent
    extends Event
    implements IFacilityInstalledEvent {
        private static final long serialVersionUID = 1L;
        private IFacility facility;
        private boolean remote;

        public FacilityInstalledEvent(ICollaboration source, IFacility facility, boolean remote) {
            super((INotifier)source);
            this.facility = facility;
            this.remote = remote;
        }

        @Override
        public ICollaboration getSource() {
            return (ICollaboration)super.getSource();
        }

        @Override
        public IFacility getFacility() {
            return this.facility;
        }

        @Override
        public boolean fromRemote() {
            return this.remote;
        }

        public String toString() {
            return MessageFormat.format("FacilityInstalledEvent[source={0}, facility={1}, remote={2}]", this.getSource(), this.facility, this.remote);
        }
    }
}

