/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.internal.FqcnResolver;
import org.apache.commons.jexl3.internal.introspection.Uberspect;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FqcnTest
extends JexlTestCase {
    public static final int FORTYTWO = 42;

    public FqcnTest() {
        super("FqcnTest");
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        Logger.getLogger(JexlEngine.class.getName()).setLevel(Level.SEVERE);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }

    Object getConstant(List<String> imports, String name) throws Exception {
        Uberspect uber = new Uberspect(null, null, JexlPermissions.UNRESTRICTED);
        FqcnResolver resolver = new FqcnResolver((JexlUberspect)uber, imports);
        return resolver.resolveConstant(name);
    }

    @Test
    void testBadImport0() {
        List<String> imports = Collections.singletonList("org.apache.commons.jexl4242");
        Assertions.assertThrows(JexlException.class, () -> new JexlBuilder().imports((Collection)imports).create());
    }

    @Test
    void testBadImport1() {
        List<String> imports = Collections.singletonList("org.apache.commons.jexl.JexlEngine");
        Assertions.assertThrows(JexlException.class, () -> new JexlBuilder().imports((Collection)imports).create());
    }

    @Test
    public void testFqcn() throws Exception {
        List<String> imports = Arrays.asList("org.apache.commons.jexl3.internal.FqcnTest", "org.apache.commons.jexl3.internal", "java.lang");
        Object c = this.getConstant(imports, "FqcnScope.UNDEFINED");
        Assertions.assertNotNull((Object)c);
        Assertions.assertEquals((Object)((Object)FqcnScope.UNDEFINED), (Object)c);
        c = this.getConstant(imports, "FqcnScope.SUPER");
        Assertions.assertEquals((Object)((Object)FqcnScope.SUPER), (Object)c);
        c = this.getConstant(imports, "FqcnScope.SUPER");
        Assertions.assertEquals((Object)((Object)FqcnScope.SUPER), (Object)c);
        c = this.getConstant(imports, "FqcnTest.FORTYTWO");
        Assertions.assertEquals((Object)42, (Object)c);
    }

    public static enum FqcnScope {
        UNDEFINED,
        UNDECLARED,
        GLOBAL,
        LOCAL,
        THIS,
        SUPER;

    }
}

