/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.router.priority;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.GreedyPriorityBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.IPriorityBalancer;

public class LeaderPriorityBalancer
extends GreedyPriorityBalancer
implements IPriorityBalancer {
    @Override
    public Map<TConsensusGroupId, TRegionReplicaSet> generateOptimalRoutePriority(List<TRegionReplicaSet> replicaSets, Map<TConsensusGroupId, Integer> regionLeaderMap) {
        TreeMap<TConsensusGroupId, TRegionReplicaSet> regionPriorityMap = new TreeMap<TConsensusGroupId, TRegionReplicaSet>();
        replicaSets.forEach(replicaSet -> {
            int leaderId = regionLeaderMap.getOrDefault(replicaSet.getRegionId(), -1);
            if (leaderId != -1) {
                for (int i = 0; i < replicaSet.getDataNodeLocationsSize(); ++i) {
                    if (((TDataNodeLocation)replicaSet.getDataNodeLocations().get(i)).getDataNodeId() != leaderId) continue;
                    Collections.swap(replicaSet.getDataNodeLocations(), 0, i);
                    break;
                }
            }
            regionPriorityMap.put(replicaSet.getRegionId(), (TRegionReplicaSet)replicaSet);
        });
        return regionPriorityMap;
    }
}

