#include "test.h"

#include <eel/eel-font-picker.h>
//#include <eel/eel-global-preferences.h>

static void
update_font (GtkLabel *label,
	     const char *font_file_name)
{
#if GNOME2_CONVERSION_COMPLETE
	EelScalableFont *font;
	
	g_return_if_fail (EEL_IS_LABEL (label));
	g_return_if_fail (font_file_name != NULL);

	font = eel_scalable_font_new (font_file_name);
	gtk_label_set_smooth_font (GTK_LABEL (label), font);
	g_object_unref (font);
#endif

	//eel_preferences_set (EEL_PREFERENCES_DEFAULT_SMOOTH_FONT, font_file_name);
}

static void
font_changed_update_label_callback (EelFontPicker *font_picker,
				    gpointer callback_data)
{
	char *font_file_name;

	g_return_if_fail (EEL_IS_FONT_PICKER (font_picker));
	g_return_if_fail (GTK_IS_LABEL (callback_data));

	font_file_name = eel_font_picker_get_selected_font (font_picker);
	update_font (GTK_LABEL (callback_data), font_file_name);
	g_free (font_file_name);
}

static void
font_changed_update_file_name_callback (EelFontPicker *font_picker,
					gpointer callback_data)
{
	char *font_file_name;

	g_return_if_fail (EEL_IS_FONT_PICKER (font_picker));
	g_return_if_fail (EEL_IS_TEXT_CAPTION (callback_data));

	font_file_name = eel_font_picker_get_selected_font (font_picker);
	eel_text_caption_set_text (EEL_TEXT_CAPTION (callback_data), font_file_name);
	g_free (font_file_name);
}

static void
print_selected_font_callback (GtkWidget *button,
			      gpointer callback_data)
{
	char *selected_font;

	g_return_if_fail (GTK_IS_BUTTON (button));
	g_return_if_fail (EEL_IS_FONT_PICKER (callback_data));

	selected_font = eel_font_picker_get_selected_font (EEL_FONT_PICKER (callback_data));

	g_free (selected_font);
}

int
main (int argc, char * argv[])
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *font_picker;
	GtkWidget *label;
	GtkWidget *file_name_caption;
	GtkWidget *default_font_caption;
	GtkWidget *default_bold_font_caption;
	GtkWidget *use_default_button;
	GtkWidget *use_default_bold_button;
	GtkWidget *default_hbox;
	GtkWidget *default_bold_hbox;
	GtkWidget *print_selected_font_button;
	char *current_font;

	test_init (&argc, &argv);

	//eel_global_preferences_init ();

	window = test_window_new ("Font Picker Test", 10);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window), vbox);

	font_picker = eel_font_picker_new ();

	//current_font = eel_preferences_get (EEL_PREFERENCES_DEFAULT_SMOOTH_FONT);
// 	eel_font_picker_set_selected_font (EEL_FONT_PICKER (font_picker),
// 						current_font);

	current_font = eel_font_picker_get_selected_font (EEL_FONT_PICKER (font_picker));
	label = gtk_label_new ("Something");

#if GNOME2_CONVERSION_COMPLETE
	font = eel_scalable_font_new (current_font);
	gtk_label_set_smooth_font (GTK_LABEL (label), font);
	g_object_unref (font);
#endif
	
	g_signal_connect (font_picker,
			    "changed",
			    G_CALLBACK (font_changed_update_label_callback),
			    label);

	file_name_caption = eel_text_caption_new ();
	eel_caption_set_title_label (EEL_CAPTION (file_name_caption),
					  "Current Font");
	eel_text_caption_set_text (EEL_TEXT_CAPTION (file_name_caption), current_font);

	g_signal_connect (font_picker,
			    "changed",
			    G_CALLBACK (font_changed_update_file_name_callback),
			    file_name_caption);
	

	default_hbox = gtk_hbox_new (FALSE, 0);
	default_font_caption = eel_text_caption_new ();
	eel_caption_set_title_label (EEL_CAPTION (default_font_caption),
					  "Default Font");
#if GNOME2_CONVERSION_COMPLETE
	eel_text_caption_set_text (EEL_TEXT_CAPTION (default_font_caption), default_font);
#endif
	use_default_button = gtk_button_new_with_label ("Use");
#if GNOME2_CONVERSION_COMPLETE
	g_signal_connect (use_default_button,
			    "clicked",
			    G_CALLBACK (use_default_font_callback),
			    label);
	g_signal_connect (use_default_button,
			    "clicked",
			    G_CALLBACK (use_default_font_update_picker_callback),
			    font_picker);
#endif
	gtk_box_pack_start (GTK_BOX (default_hbox), default_font_caption, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (default_hbox), use_default_button, FALSE, FALSE, 0);


	default_bold_hbox = gtk_hbox_new (FALSE, 0);
	default_bold_font_caption = eel_text_caption_new ();
	eel_caption_set_title_label (EEL_CAPTION (default_bold_font_caption),
					  "Default Bold Font");
#if GNOME2_CONVERSION_COMPLETE
	eel_text_caption_set_text (EEL_TEXT_CAPTION (default_bold_font_caption), default_bold_font);
#endif
	use_default_bold_button = gtk_button_new_with_label ("Use");
#if GNOME2_CONVERSION_COMPLETE
	g_signal_connect (use_default_bold_button,
			    "clicked",
			    G_CALLBACK (use_default_bold_font_callback),
			    label);
	g_signal_connect (use_default_bold_button,
			    "clicked",
			    G_CALLBACK (use_default_bold_font_update_picker_callback),
			    font_picker);
#endif
	gtk_box_pack_start (GTK_BOX (default_bold_hbox), default_bold_font_caption, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (default_bold_hbox), use_default_bold_button, FALSE, FALSE, 0);

	gtk_box_pack_start (GTK_BOX (vbox), font_picker, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 10);
	gtk_box_pack_start (GTK_BOX (vbox), file_name_caption, TRUE, TRUE, 10);
	gtk_box_pack_start (GTK_BOX (vbox), default_hbox, TRUE, TRUE, 10);
	gtk_box_pack_start (GTK_BOX (vbox), default_bold_hbox, TRUE, TRUE, 10);

	print_selected_font_button = gtk_button_new_with_label ("Print selected font");
	g_signal_connect (print_selected_font_button,
			    "clicked",
			    G_CALLBACK (print_selected_font_callback),
			    font_picker);
	gtk_box_pack_start (GTK_BOX (vbox), print_selected_font_button, FALSE, FALSE, 10);

	g_free (current_font);

	gtk_widget_show (font_picker);
	gtk_widget_show (label);
	gtk_widget_show (file_name_caption);
	gtk_widget_show (print_selected_font_button);
	gtk_widget_show_all (default_hbox);
	gtk_widget_show_all (default_bold_hbox);
	gtk_widget_show (vbox);
	gtk_widget_show (window);

	gtk_main ();
	return test_quit (EXIT_SUCCESS);
}
