/*
 * This file is part of the coreboot project.
 *
 * Copyright (C) 2019 Maxim Polyakov <max.senia.poliak@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU General Public License for more details.
 */

#ifndef _PCH_GPIO_H
#define _PCH_GPIO_H

#include <soc/gpe.h>
#include <soc/gpio.h>

/* Pad configuration in ramstage */
static const struct pad_config gpio_table[] = {
	/* ------- GPIO Group GPP_A ------- */
	/* GPP_A0 - RCIN# */
	PAD_CFG_NF_BUF_TRIG(GPP_A0, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_A1 - LAD0 */
	PAD_CFG_NF_BUF_TRIG(GPP_A1, 20K_PU, PLTRST, NF1, NO_DISABLE, OFF),
	/* GPP_A2 - LAD1 */
	PAD_CFG_NF_BUF_TRIG(GPP_A2, 20K_PU, PLTRST, NF1, NO_DISABLE, OFF),
	/* GPP_A3 - LAD2 */
	PAD_CFG_NF_BUF_TRIG(GPP_A3, 20K_PU, PLTRST, NF1, NO_DISABLE, OFF),
	/* GPP_A4 - LAD3 */
	PAD_CFG_NF_BUF_TRIG(GPP_A4, 20K_PU, PLTRST, NF1, NO_DISABLE, OFF),
	/* GPP_A5 - LFRAME# */
	PAD_CFG_NF_BUF_TRIG(GPP_A5, NONE, PLTRST, NF1, RX_DISABLE, OFF),
	/* GPP_A6 - SERIRQ */
	PAD_CFG_NF_BUF_TRIG(GPP_A6, NONE, PLTRST, NF1, NO_DISABLE, OFF),
	/* GPP_A7 - GPIO */
	PAD_CFG_GPI_INT(GPP_A7, NONE, PLTRST, OFF),
	/* GPP_A8 - CLKRUN# */
	PAD_CFG_NF_BUF_TRIG(GPP_A8, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_A9 - CLKOUT_LPC0 */
	PAD_CFG_NF_BUF_TRIG(GPP_A9, 20K_PD, PLTRST, NF1, RX_DISABLE, OFF),
	/* GPP_A10 - CLKOUT_LPC1 */
	PAD_CFG_NF_BUF_TRIG(GPP_A10, 20K_PD, PLTRST, NF1, RX_DISABLE, OFF),
	/* GPP_A11 - GPIO */
	PAD_CFG_GPI_INT(GPP_A11, NONE, PLTRST, OFF),
	/* GPP_A12 - GPIO */
	PAD_CFG_GPI_INT(GPP_A12, NONE, PLTRST, OFF),
	/* GPP_A13 - SUSWARN#/SUSPWRDNACK */
	PAD_CFG_NF_BUF_TRIG(GPP_A13, NONE, DEEP, NF1, RX_DISABLE, OFF),
	/* GPP_A14 - SUS_STAT# */
	PAD_CFG_NF_BUF_TRIG(GPP_A14, NONE, DEEP, NF1, RX_DISABLE, OFF),
	/* GPP_A15 - SUS_ACK# */
	PAD_CFG_NF_BUF_TRIG(GPP_A15, 20K_PU, DEEP, NF1, TX_DISABLE, OFF),
	/* GPP_A16 - GPIO */
	PAD_CFG_GPI_INT(GPP_A16, NONE, PLTRST, OFF),
	/* GPP_A17 - GPIO */
	PAD_CFG_GPI_INT(GPP_A17, NONE, PLTRST, OFF),
	/* GPP_A18 - GPIO */
	PAD_CFG_GPI_INT(GPP_A18, NONE, PLTRST, OFF),
	/* GPP_A19 - GPIO */
	PAD_CFG_GPI_INT(GPP_A19, NONE, PLTRST, OFF),
	/* GPP_A20 - GPIO */
	PAD_CFG_GPI_INT(GPP_A20, NONE, PLTRST, OFF),
	/* GPP_A21 - GPIO */
	PAD_CFG_GPI_INT(GPP_A21, NONE, PLTRST, OFF),
	/* GPP_A22 - GPIO */
	PAD_CFG_GPI_INT(GPP_A22, NONE, PLTRST, OFF),
	/* GPP_A23 - GPIO */
	PAD_CFG_GPI_INT(GPP_A23, NONE, PLTRST, OFF),

	/* ------- GPIO Group GPP_B ------- */
	/* GPP_B0 - GPIO */
	PAD_CFG_GPI_INT(GPP_B0, NONE, PLTRST, OFF),
	/* GPP_B1 - GPIO */
	PAD_CFG_GPI_INT(GPP_B1, NONE, PLTRST, OFF),
	/* GPP_B2 - GPIO */
	PAD_CFG_GPI_INT(GPP_B2, NONE, PLTRST, OFF),
	/* GPP_B3 - GPIO */
	PAD_CFG_GPO(GPP_B3, 1, DEEP),
	/* GPP_B4 - CPU_GP3 */
	PAD_CFG_NF_BUF_TRIG(GPP_B4, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_B5 - GPIO */
	PAD_CFG_GPI_INT(GPP_B5, NONE, PLTRST, OFF),
	/* GPP_B6 - GPIO */
	PAD_CFG_GPI_INT(GPP_B6, NONE, PLTRST, OFF),
	/* GPP_B7 - NC */
	PAD_NC(GPP_B7, NONE),
	/* GPP_B8 - GPIO */
	PAD_CFG_GPI_INT(GPP_B8, 5K_PU, PLTRST, OFF),
	/* GPP_B9 - GPIO */
	PAD_CFG_GPI_INT(GPP_B9, NONE, PLTRST, OFF),
	/* GPP_B10 - GPIO */
	PAD_CFG_GPI_INT(GPP_B10, NONE, PLTRST, OFF),
	/* GPP_B11 - GPIO */
	_PAD_CFG_STRUCT(GPP_B11,
		PAD_FUNC(GPIO) | PAD_RESET(PWROK) |
		PAD_CFG0_TRIG_OFF | PAD_CFG0_RX_POL_NONE |
		PAD_BUF(NO_DISABLE),
		PAD_PULL(NONE)),
	/* GPP_B12 - SLP_S0# */
	PAD_CFG_NF_BUF_TRIG(GPP_B12, NONE, DEEP, NF1, RX_DISABLE, OFF),
	/* GPP_B13 - PLTRST# */
	PAD_CFG_NF_BUF_TRIG(GPP_B13, NONE, DEEP, NF1, RX_DISABLE, OFF),
	/* GPP_B14 - SPKR */
	PAD_CFG_NF_BUF_TRIG(GPP_B14, 20K_PD, PLTRST, NF1, RX_DISABLE, OFF),
	/* GPP_B15 - GPIO */
	PAD_CFG_GPI_INT(GPP_B15, NONE, PLTRST, OFF),
	/* GPP_B16 - GPIO */
	PAD_CFG_GPI_INT(GPP_B16, NONE, PLTRST, OFF),
	/* GPP_B17 - GPIO */
	PAD_CFG_GPO(GPP_B17, 1, DEEP),
	/* GPP_B18 - GPIO */
	PAD_CFG_GPI_INT(GPP_B18, NONE, PLTRST, OFF),
	/* GPP_B19 - GPIO */
	PAD_CFG_GPI_INT(GPP_B19, NONE, PLTRST, OFF),
	/* GPP_B20 - GPIO */
	PAD_CFG_GPI_INT(GPP_B20, NONE, PLTRST, OFF),
	/* GPP_B21 - GPIO */
	PAD_CFG_GPI_INT(GPP_B21, NONE, PLTRST, OFF),
	/* GPP_B22 - GPIO */
	PAD_CFG_GPI_INT(GPP_B22, NONE, PLTRST, OFF),
	/* GPP_B23 - PCHHOT# */
	_PAD_CFG_STRUCT(GPP_B23,
		PAD_FUNC(NF2) | PAD_RESET(PLTRST) |
		PAD_CFG0_TRIG_OFF | PAD_CFG0_RX_POL_NONE |
		PAD_BUF(RX_DISABLE) | 1,
		PAD_PULL(20K_PD)),

	/* ------- GPIO Group GPP_C ------- */
	/* GPP_C0 - SMBCLK */
	PAD_CFG_NF_BUF_TRIG(GPP_C0, NONE, DEEP, NF1, TX_DISABLE, OFF),
	/* GPP_C1 - SMBDATA */
	PAD_CFG_NF_BUF_TRIG(GPP_C1, NONE, DEEP, NF1, TX_DISABLE, OFF),
	/* GPP_C2 - GPIO */
	PAD_CFG_GPO(GPP_C2, 1, DEEP),
	/* GPP_C3 - SML0CLK */
	PAD_CFG_NF_BUF_TRIG(GPP_C3, NONE, DEEP, NF1, TX_DISABLE, OFF),
	/* GPP_C4 - SML0DATA */
	PAD_CFG_NF_BUF_TRIG(GPP_C4, NONE, DEEP, NF1, TX_DISABLE, OFF),
	/* GPP_C5 - GPIO */
	PAD_CFG_GPI_INT(GPP_C5, NONE, PLTRST, OFF),
	/* GPP_C6 - RESERVED */
	/* GPP_C7 - RESERVED */
	/* GPP_C8 - UART0_RXD */
	PAD_CFG_NF_BUF_TRIG(GPP_C8, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_C9 - UART0_TXD */
	PAD_CFG_NF_BUF_TRIG(GPP_C9, NONE, PLTRST, NF1, RX_DISABLE, OFF),
	/* GPP_C10 - UART0_RTS# */
	PAD_CFG_NF_BUF_TRIG(GPP_C10, NONE, PLTRST, NF1, RX_DISABLE, OFF),
	/* GPP_C11 - UART0_CTS# */
	PAD_CFG_NF_BUF_TRIG(GPP_C11, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_C12 - GPIO */
	PAD_CFG_GPI_INT(GPP_C12, NONE, PLTRST, OFF),
	/* GPP_C13 - GPIO */
	PAD_CFG_GPI_INT(GPP_C13, NONE, PLTRST, OFF),
	/* GPP_C14 - GPIO */
	PAD_CFG_GPI_INT(GPP_C14, NONE, PLTRST, OFF),
	/* GPP_C15 - GPIO */
	PAD_CFG_GPI_INT(GPP_C15, NONE, PLTRST, OFF),
	/* GPP_C16 - GPIO */
	PAD_CFG_GPI_INT(GPP_C16, NONE, PLTRST, OFF),
	/* GPP_C17 - GPIO */
	PAD_CFG_GPI_INT(GPP_C17, NONE, PLTRST, OFF),
	/* GPP_C18 - GPIO */
	PAD_CFG_GPI_INT(GPP_C18, NONE, PLTRST, OFF),
	/* GPP_C19 - GPIO */
	PAD_CFG_GPI_INT(GPP_C19, NONE, PLTRST, OFF),
	/* GPP_C20 - UART2_RXD */
	PAD_CFG_NF_BUF_TRIG(GPP_C20, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_C21 - UART2_TXD */
	PAD_CFG_NF_BUF_TRIG(GPP_C21, NONE, PLTRST, NF1, RX_DISABLE, OFF),
	/* GPP_C22 - UART2_RTS# */
	PAD_CFG_NF_BUF_TRIG(GPP_C22, NONE, PLTRST, NF1, RX_DISABLE, OFF),
	/* GPP_C23 - GPIO */
	PAD_CFG_GPI_SCI(GPP_C23, NONE, DEEP, LEVEL, YES),

	/* ------- GPIO Group GPP_D ------- */
	/* GPP_D0 - GPIO */
	PAD_CFG_GPI_INT(GPP_D0, NONE, PLTRST, OFF),
	/* GPP_D1 - GPIO */
	PAD_CFG_GPI_INT(GPP_D1, NONE, PLTRST, OFF),
	/* GPP_D2 - GPIO */
	PAD_CFG_GPI_INT(GPP_D2, NONE, PLTRST, OFF),
	/* GPP_D3 - GPIO */
	PAD_CFG_GPI_INT(GPP_D3, NONE, PLTRST, OFF),
	/* GPP_D4 - GPIO */
	PAD_CFG_GPI_INT(GPP_D4, NONE, PLTRST, OFF),
	/* GPP_D5 - I2S_SFRM */
	PAD_CFG_NF_BUF_TRIG(GPP_D5, NONE, PLTRST, NF1, NO_DISABLE, OFF),
	/* GPP_D6 - I2S_TXD */
	PAD_CFG_NF_BUF_TRIG(GPP_D6, NONE, PLTRST, NF1, RX_DISABLE, OFF),
	/* GPP_D7 - I2S_RXD */
	PAD_CFG_NF_BUF_TRIG(GPP_D7, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_D8 - I2S_SCLK */
	PAD_CFG_NF_BUF_TRIG(GPP_D8, NONE, PLTRST, NF1, NO_DISABLE, OFF),
	/* GPP_D9 - GPIO */
	PAD_CFG_GPI_INT(GPP_D9, NONE, PLTRST, OFF),
	/* GPP_D10 - GPIO */
	PAD_CFG_GPI_INT(GPP_D10, NONE, PLTRST, OFF),
	/* GPP_D11 - GPIO */
	PAD_CFG_GPI_INT(GPP_D11, NONE, PLTRST, OFF),
	/* GPP_D12 - GPIO */
	PAD_CFG_GPI_INT(GPP_D12, NONE, PLTRST, OFF),
	/* GPP_D13 - GPIO */
	PAD_CFG_GPI_INT(GPP_D13, NONE, PLTRST, OFF),
	/* GPP_D14 - GPIO */
	PAD_CFG_GPI_INT(GPP_D14, NONE, PLTRST, OFF),
	/* GPP_D15 - GPIO */
	PAD_CFG_GPI_INT(GPP_D15, NONE, PLTRST, OFF),
	/* GPP_D16 - GPIO */
	PAD_CFG_GPI_INT(GPP_D16, NONE, PLTRST, OFF),
	/* GPP_D17 - GPIO */
	PAD_CFG_GPI_INT(GPP_D17, NONE, PLTRST, OFF),
	/* GPP_D18 - GPIO */
	PAD_CFG_GPI_INT(GPP_D18, NONE, PLTRST, OFF),
	/* GPP_D19 - DMIC_CLK0 */
	PAD_CFG_NF_BUF_TRIG(GPP_D19, 20K_PU, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_D20 - DMIC_DATA0 */
	PAD_CFG_NF_BUF_TRIG(GPP_D20, 20K_PU, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_D21 - GPIO */
	PAD_CFG_GPI_INT(GPP_D21, NONE, PLTRST, OFF),
	/* GPP_D22 - GPIO */
	PAD_CFG_GPI_INT(GPP_D22, NONE, PLTRST, OFF),
	/* GPP_D23 - GPIO */
	PAD_CFG_GPI_INT(GPP_D23, NONE, PLTRST, OFF),

	/* ------- GPIO Group GPP_E ------- */
	/* GPP_E0 - SATAXPCIE0 */
	PAD_CFG_NF_BUF_TRIG(GPP_E0, 20K_PU, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_E1 - SATAXPCIE1 */
	PAD_CFG_NF_BUF_TRIG(GPP_E1, 20K_PU, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_E2 - SATAXPCIE2 */
	PAD_CFG_NF_BUF_TRIG(GPP_E2, 20K_PU, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_E3 - CPU_GP0 */
	PAD_CFG_NF_BUF_TRIG(GPP_E3, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_E4 - SATA_DEVSLP0 */
	PAD_CFG_NF_BUF_TRIG(GPP_E4, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_E5 - SATA_DEVSLP1 */
	PAD_CFG_NF_BUF_TRIG(GPP_E5, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_E6 - SATA_DEVSLP2 */
	PAD_CFG_NF_BUF_TRIG(GPP_E6, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_E7 - GPIO */
	PAD_CFG_GPI_INT(GPP_E7, NONE, PLTRST, OFF),
	/* GPP_E8 - SATA_LED# */
	PAD_CFG_NF_BUF_TRIG(GPP_E8, NONE, PLTRST, NF1, RX_DISABLE, OFF),
	/* GPP_E9 - USB_OC0# */
	PAD_CFG_NF_BUF_TRIG(GPP_E9, NONE, DEEP, NF1, TX_DISABLE, OFF),
	/* GPP_E10 - USB_OC1# */
	PAD_CFG_NF_BUF_TRIG(GPP_E10, NONE, DEEP, NF1, TX_DISABLE, OFF),
	/* GPP_E11 - USB_OC2# */
	PAD_CFG_NF_BUF_TRIG(GPP_E11, NONE, DEEP, NF1, TX_DISABLE, OFF),
	/* GPP_E12 - USB_OC3# */
	PAD_CFG_NF_BUF_TRIG(GPP_E12, NONE, DEEP, NF1, TX_DISABLE, OFF),

	/* ------- GPIO Group GPP_F ------- */
	/* GPP_F0 - GPIO */
	PAD_CFG_GPI_INT(GPP_F0, NONE, PLTRST, OFF),
	/* GPP_F1 - SATAXPCIE4 */
	PAD_CFG_NF_BUF_TRIG(GPP_F1, 20K_PU, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_F2 - GPIO */
	PAD_NC(GPP_F2, NONE),
	/* GPP_F3 - GPIO */
	PAD_CFG_GPI_INT(GPP_F3, NONE, PLTRST, OFF),
	/* GPP_F4 - GPIO */
	PAD_CFG_GPI_INT(GPP_F4, NONE, PLTRST, OFF),
	/* GPP_F5 - GPIO */
	PAD_CFG_GPI_INT(GPP_F5, NONE, PLTRST, OFF),
	/* GPP_F6 - GPIO */
	PAD_CFG_GPI_INT(GPP_F6, NONE, PLTRST, OFF),
	/* GPP_F7 - GPIO */
	PAD_CFG_GPI_INT(GPP_F7, NONE, PLTRST, OFF),
	/* GPP_F8 - GPIO */
	PAD_CFG_GPI_INT(GPP_F8, NONE, PLTRST, OFF),
	/* GPP_F9 - GPIO */
	PAD_CFG_GPI_INT(GPP_F9, NONE, PLTRST, OFF),
	/* GPP_F10 - GPIO */
	PAD_CFG_GPI_APIC(GPP_F10, NONE, PLTRST),
	/* GPP_F11 - GPIO */
	PAD_CFG_GPI_INT(GPP_F11, NONE, PLTRST, OFF),
	/* GPP_F12 - GPIO */
	PAD_CFG_GPI_APIC_INVERT(GPP_F12, NONE, PLTRST),
	/* GPP_F13 - GPIO */
	PAD_CFG_GPI_APIC(GPP_F13, NONE, PLTRST),
	/* GPP_F14 - GPIO */
	PAD_CFG_GPI_APIC_INVERT(GPP_F14, NONE, DEEP),
	/* GPP_F15 - USB_OC4# */
	PAD_CFG_NF_BUF_TRIG(GPP_F15, NONE, DEEP, NF1, TX_DISABLE, OFF),
	/* GPP_F16 - USB_OC5# */
	PAD_CFG_NF_BUF_TRIG(GPP_F16, NONE, DEEP, NF1, TX_DISABLE, OFF),
	/* GPP_F17 - USB_OC6# */
	PAD_CFG_NF_BUF_TRIG(GPP_F17, NONE, DEEP, NF1, TX_DISABLE, OFF),
	/* GPP_F18 - GPIO */
	PAD_CFG_GPO(GPP_F18, 1, PLTRST),
	/* GPP_F19 - GPIO */
	PAD_CFG_GPI_INT(GPP_F19, NONE, PLTRST, OFF),
	/* GPP_F20 - GPIO */
	PAD_CFG_GPI_INT(GPP_F20, NONE, PLTRST, OFF),
	/* GPP_F21 - GPIO */
	PAD_CFG_GPI_INT(GPP_F21, NONE, PLTRST, OFF),
	/* GPP_F22 - GPIO */
	PAD_CFG_GPI_INT(GPP_F22, NONE, PLTRST, OFF),
	/* GPP_F23 - GPIO */
	PAD_CFG_GPI_INT(GPP_F23, NONE, PLTRST, OFF),

	/* ------- GPIO Group GPP_G ------- */
	/* GPP_G0 - GPIO */
	PAD_CFG_GPI_INT(GPP_G0, NONE, PWROK, OFF),
	/* GPP_G1 - GPIO */
	PAD_CFG_GPI_INT(GPP_G1, NONE, PWROK, OFF),
	/* GPP_G2 - GPIO */
	PAD_CFG_GPI_INT(GPP_G2, NONE, PWROK, OFF),
	/* GPP_G3 - GPIO */
	PAD_CFG_GPI_INT(GPP_G3, NONE, PWROK, OFF),
	/* GPP_G4 - GPIO */
	PAD_CFG_GPO(GPP_G4, 0, DEEP),
	/* GPP_G5 - GPIO */
	PAD_CFG_GPI_INT(GPP_G5, NONE, PWROK, OFF),
	/* GPP_G6 - GPIO */
	_PAD_CFG_STRUCT(GPP_G6,
		PAD_FUNC(GPIO) | PAD_RESET(PWROK) |
		PAD_CFG0_TRIG_LEVEL | PAD_CFG0_RX_POL_YES |
		PAD_BUF(TX_DISABLE),
		PAD_PULL(NONE)),
	/* GPP_G7 - GPIO */
	PAD_CFG_GPI_INT(GPP_G7, NONE, PWROK, OFF),
	/* GPP_G8 - GPIO */
	PAD_CFG_GPI_INT(GPP_G8, NONE, PLTRST, OFF),
	/* GPP_G9 - GPIO */
	PAD_CFG_GPI_INT(GPP_G9, NONE, PLTRST, OFF),
	/* GPP_G10 - GPIO */
	PAD_CFG_GPI_INT(GPP_G10, NONE, PLTRST, OFF),
	/* GPP_G11 - GPIO */
	PAD_CFG_GPI_INT(GPP_G11, NONE, PLTRST, OFF),
	/* GPP_G12 - GPIO */
	_PAD_CFG_STRUCT(GPP_G12,
		PAD_FUNC(GPIO) | PAD_RESET(PLTRST) |
		PAD_CFG0_TRIG_LEVEL | PAD_CFG0_RX_POL_YES |
		PAD_BUF(TX_DISABLE),
		PAD_PULL(NONE)),
	/* GPP_G13 - GPIO */
	PAD_CFG_GPO(GPP_G13, 1, PLTRST),
	/* GPP_G14 - GPIO */
	_PAD_CFG_STRUCT(GPP_G14,
		PAD_FUNC(GPIO) | PAD_RESET(PLTRST) |
		PAD_CFG0_TRIG_LEVEL | PAD_CFG0_RX_POL_YES |
		PAD_BUF(TX_DISABLE),
		PAD_PULL(NONE)),
	/* GPP_G15 - GPIO */
	PAD_CFG_GPO(GPP_G15, 0, PLTRST),
	/* GPP_G16 - GPIO */
	PAD_CFG_TERM_GPO(GPP_G16, 1, 20K_PD, PLTRST),
	/* GPP_G17 - GPIO */
	PAD_CFG_GPI_INT(GPP_G17, NONE, PLTRST, OFF),
	/* GPP_G18 - GPIO */
	PAD_CFG_GPI_APIC(GPP_G18, NONE, PLTRST),
	/* GPP_G19 - SMI# */
	PAD_CFG_NF_BUF_TRIG(GPP_G19, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_G20 - GPIO */
	PAD_CFG_GPI_INT(GPP_G20, NONE, PLTRST, OFF),
	/* GPP_G21 - GPIO */
	PAD_CFG_GPI_INT(GPP_G21, NONE, PLTRST, OFF),
	/* GPP_G22 - GPIO */
	PAD_CFG_GPI_INT(GPP_G22, NONE, PLTRST, OFF),
	/* GPP_G23 - GPIO */
	PAD_CFG_GPI_INT(GPP_G23, NONE, PLTRST, OFF),

	/* ------- GPIO Group GPP_H ------- */
	/* GPP_H0 - GPIO */
	PAD_CFG_GPI_INT(GPP_H0, NONE, PLTRST, OFF),
	/* GPP_H1 - GPIO */
	PAD_NC(GPP_H1, NONE),
	/* GPP_H2 - GPIO */
	PAD_CFG_GPI_INT(GPP_H2, NONE, PLTRST, OFF),
	/* GPP_H3 - GPIO */
	PAD_CFG_GPI_INT(GPP_H3, NONE, PLTRST, OFF),
	/* GPP_H4 - GPIO */
	PAD_CFG_GPI_INT(GPP_H4, NONE, PLTRST, OFF),
	/* GPP_H5 - GPIO */
	PAD_CFG_GPI_INT(GPP_H5, NONE, PLTRST, OFF),
	/* GPP_H6 - GPIO */
	PAD_CFG_GPI_INT(GPP_H6, NONE, PLTRST, OFF),
	/* GPP_H7 - GPIO */
	PAD_CFG_GPI_INT(GPP_H7, NONE, PLTRST, OFF),
	/* GPP_H8 - GPIO */
	PAD_CFG_GPI_INT(GPP_H8, NONE, PLTRST, OFF),
	/* GPP_H9 - GPIO */
	PAD_CFG_GPI_INT(GPP_H9, NONE, PLTRST, OFF),
	/* GPP_H10 - GPIO */
	PAD_CFG_GPI_INT(GPP_H10, NONE, PLTRST, OFF),
	/* GPP_H11 - GPIO */
	PAD_CFG_GPI_INT(GPP_H11, NONE, PLTRST, OFF),
	/* GPP_H12 - GPIO */
	PAD_CFG_GPI_INT(GPP_H12, NONE, PLTRST, OFF),
	/* GPP_H13 - GPIO */
	PAD_CFG_GPI_APIC(GPP_H13, NONE, PLTRST),
	/* GPP_H14 - GPIO */
	PAD_CFG_GPI_APIC(GPP_H14, NONE, PLTRST),
	/* GPP_H15 - GPIO */
	PAD_CFG_GPI_APIC(GPP_H15, NONE, PLTRST),
	/* GPP_H16 - GPIO */
	PAD_CFG_GPI(GPP_H16, NONE, PLTRST),
	/* GPP_H17 - GPIO */
	PAD_CFG_GPO(GPP_H17, 1, PLTRST),
	/* GPP_H18 - GPIO */
	PAD_CFG_GPI_INT(GPP_H18, NONE, PLTRST, OFF),
	/* GPP_H19 - GPIO */
	PAD_CFG_GPI_INT(GPP_H19, NONE, PLTRST, OFF),
	/* GPP_H20 - GPIO */
	PAD_CFG_GPI_INT(GPP_H20, NONE, PLTRST, OFF),
	/* GPP_H21 - GPIO */
	PAD_CFG_GPI_INT(GPP_H21, NONE, PLTRST, OFF),
	/* GPP_H22 - GPIO */
	PAD_CFG_GPI_INT(GPP_H22, NONE, PLTRST, OFF),
	/* GPP_H23 - GPIO */
	PAD_CFG_GPI_INT(GPP_H23, NONE, PWROK, OFF),

	/* -------- GPIO Group GPD -------- */
	/* GPD0 - GPIO */
	PAD_CFG_GPI_INT(GPD0, NONE, PLTRST, OFF),
	/* GPD1 - GPIO */
	PAD_CFG_GPO(GPD1, 0, PWROK),
	/* GPD2 - LAN_WAKE# */
	PAD_CFG_NF_BUF_TRIG(GPD2, NATIVE, PWROK, NF1, RX_DISABLE, LEVEL),
	/* GPD3 - PWRBTN# */
	PAD_CFG_NF_BUF_TRIG(GPD3, 20K_PU, PWROK, NF1, TX_DISABLE, OFF),
	/* GPD4 - SLP_S3# */
	PAD_CFG_NF_BUF_TRIG(GPD4, NONE, PWROK, NF1, RX_DISABLE, OFF),
	/* GPD5 - SLP_S4# */
	PAD_CFG_NF_BUF_TRIG(GPD5, NONE, PWROK, NF1, RX_DISABLE, OFF),
	/* GPD6 - GPIO */
	PAD_CFG_GPI_INT(GPD6, NONE, PLTRST, OFF),
	/* GPD7 - GPIO */
	_PAD_CFG_STRUCT(GPD7,
		PAD_FUNC(GPIO) | PAD_RESET(PLTRST) |
		PAD_CFG0_TRIG_OFF | PAD_CFG0_RX_POL_NONE |
		PAD_BUF(TX_DISABLE) | 1,
		PAD_PULL(NONE)),
	/* GPD8 - SUSCLK */
	PAD_CFG_NF_BUF_TRIG(GPD8, NONE, PWROK, NF1, RX_DISABLE, OFF),
	/* GPD9 - SLP_WLAN# */
	PAD_CFG_NF_BUF_TRIG(GPD9, NONE, PWROK, NF1, RX_DISABLE, OFF),
	/* GPD10 - SLP_S5# */
	PAD_CFG_NF_BUF_TRIG(GPD10, NONE, PWROK, NF1, RX_DISABLE, OFF),
	/* GPD11 - GPIO */
	PAD_CFG_GPO(GPD11, 0, PWROK),

	/* ------- GPIO Group GPP_I ------- */
	/* GPP_I0 - DDPB_HPD0 */
	PAD_CFG_NF_BUF_TRIG(GPP_I0, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_I1 - DDPC_HPD1 */
	PAD_CFG_NF_BUF_TRIG(GPP_I1, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_I2 - DDPD_HPD2 */
	PAD_CFG_NF_BUF_TRIG(GPP_I2, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_I3 - DDPE_HPD3 */
	PAD_CFG_NF_BUF_TRIG(GPP_I3, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_I4 - GPIO */
	PAD_CFG_GPI_INT(GPP_I4, NONE, PLTRST, OFF),
	/* GPP_I5 - DDPB_CTRLCLK */
	PAD_CFG_NF_BUF_TRIG(GPP_I5, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_I6 - DDPB_CTRLDATA */
	PAD_CFG_NF_BUF_TRIG(GPP_I6, 20K_PD, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_I7 - DDPC_CTRLCLK */
	PAD_CFG_NF_BUF_TRIG(GPP_I7, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_I8 - DDPC_CTRLDATA */
	PAD_CFG_NF_BUF_TRIG(GPP_I8, 20K_PD, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_I9 - DDPD_CTRLCLK */
	PAD_CFG_NF_BUF_TRIG(GPP_I9, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_I10 - DDPD_CTRLDATA */
	PAD_CFG_NF_BUF_TRIG(GPP_I10, 20K_PD, PLTRST, NF1, TX_DISABLE, OFF),
};

/* Early pad configuration in romstage */
static const struct pad_config early_gpio_table[] = {
	/* ------- GPIO Group GPP_A ------- */
	/* GPP_A0 - RCIN# */
	PAD_CFG_NF_BUF_TRIG(GPP_A0, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_A1 - LAD0 */
	PAD_CFG_NF_BUF_TRIG(GPP_A1, 20K_PU, PLTRST, NF1, NO_DISABLE, OFF),
	/* GPP_A2 - LAD1 */
	PAD_CFG_NF_BUF_TRIG(GPP_A2, 20K_PU, PLTRST, NF1, NO_DISABLE, OFF),
	/* GPP_A3 - LAD2 */
	PAD_CFG_NF_BUF_TRIG(GPP_A3, 20K_PU, PLTRST, NF1, NO_DISABLE, OFF),
	/* GPP_A4 - LAD3 */
	PAD_CFG_NF_BUF_TRIG(GPP_A4, 20K_PU, PLTRST, NF1, NO_DISABLE, OFF),
	/* GPP_A5 - LFRAME# */
	PAD_CFG_NF_BUF_TRIG(GPP_A5, NONE, PLTRST, NF1, RX_DISABLE, OFF),
	/* GPP_A6 - SERIRQ */
	PAD_CFG_NF_BUF_TRIG(GPP_A6, NONE, PLTRST, NF1, NO_DISABLE, OFF),

	/* GPP_A8 - CLKRUN# */
	PAD_CFG_NF_BUF_TRIG(GPP_A8, NONE, PLTRST, NF1, TX_DISABLE, OFF),
	/* GPP_A9 - CLKOUT_LPC0 */
	PAD_CFG_NF_BUF_TRIG(GPP_A9, 20K_PD, PLTRST, NF1, RX_DISABLE, OFF),
	/* GPP_A10 - CLKOUT_LPC1 */
	PAD_CFG_NF_BUF_TRIG(GPP_A10, 20K_PD, PLTRST, NF1, RX_DISABLE, OFF),

	/* GPP_A13 - SUSWARN#/SUSPWRDNACK */
	PAD_CFG_NF_BUF_TRIG(GPP_A13, NONE, DEEP, NF1, RX_DISABLE, OFF),
	/* GPP_A14 - SUS_STAT# */
	PAD_CFG_NF_BUF_TRIG(GPP_A14, NONE, DEEP, NF1, RX_DISABLE, OFF),
	/* GPP_A15 - SUS_ACK# */
	PAD_CFG_NF_BUF_TRIG(GPP_A15, 20K_PU, DEEP, NF1, TX_DISABLE, OFF),
};

#endif
