#ifndef __ERROR__
#define __ERROR__

#include "odbc.h"

typedef enum
{
	ERR_PREPARED_MESSAGE = -1,

	ERR_SUCCESS = 0,
	ERR_CLEAR = 0,

	ERR_UNKNOWN_HOST                 =  1,
	ERR_CANT_CONNECT_TO_HOST         =  2,
	ERR_TOO_SMALL_BUFFER             =  3,
	ERR_STMT_INVALID_CURSOR_STATE    =  4,
	ERR_DBC_UNKNOWN_KEY              =  5,
	ERR_INVALID_TRANS_OP_CODE        =  6,
	ERR_INVALID_HANDLE_TYPE          =  7,
	ERR_STMT_CURSOR_DECLARED         =  8,
	ERR_STMT_NO_CURSOR_AVAIBLE       =  9,
	ERR_STMT_CURSOR_ALREADY_DECLARED = 10,
	ERR_STMT_INVALID_CURSOR_NAME     = 11,
	ERR_STMT_CURSOR_NAME_IN_USE      = 12,
	ERR_STMT_COLUMN_NUMBER_TOO_BIG   = 13,
	ERR_DBC_INVALID_LOGIN_DATA       = 14,
	ERR_STMT_NOT_PREPARED            = 15,
	ERR_NULL_POINTER_BUFFER          = 16,
	ERR_UNKNOWN_ATTRIBUTE            = 17,
	ERR_SERVER_ERROR                 = 18,
	ERR_STMT_STATEMENT_DECLARED      = 19,
	ERR_STMT_INVALID_STATE           = 20,
	ERR_STMT_ROW_COUNT_UNAVAIBLE     = 21,
	ERR_STMT_BOOKMARKS_UNUSED        = 22,
	ERR_NOT_ENOUGH_MEMORY            = 23,
	ERR_DESC_CANT_MODIFY_IRD         = 24,
	ERR_DESC_INCONSISTENT_INFO       = 25,
	ERR_STMT_DESC_WRONG_CONNECTION   = 26,
	ERR_STMT_DESC_WRONG_ALLOC_TYPE   = 27,
	ERR_STMT_NOT_ENOUGH_PARAMETERS   = 28,
	ERR_STMT_PARAM_NUMBER_NOT_BINDED = 29,
	ERR_STMT_NO_VALID_TABLE_TYPES    = 30,
	ERR_READONLY_ATTRIBUTE           = 31,
	ERR_DESC_INVALID_FIELD           = 32,
	ERR_DESC_MODIFY_ZERO_REC_IN_PD   = 33,
	ERR_DESC_READ_ZERO_REC_IN_PD     = 34,
	ERR_DESC_READ_ONLY_FIELD         = 35,
	ERR_DESC_UNKNOWN_FIELD           = 36,
	ERR_DESC_CANT_SET_NAMED          = 37,
	ERR_STMT_EMPTY_QUERY             = 38,
	ERR_STMT_CANT_BIND_PARAMETERS    = 39,
	ERR_EMPTY_STRING                 = 40,
	ERR_CONN_USE_UNSUPPORTED         = 41,
	ERR_BAD_QUERY_SYNTAX             = 42,
	ERR_CANT_BEGIN_TRANSACTION       = 43,
	ERR_CANT_CLOSE_TRANSACTION       = 44,
	ERR_STMT_CANT_EXECUTE            = 45,
	ERR_DBC_KEY_ALREADY_SET          = 46,
	ERR_INVALID_BULK_OPERATION       = 47,
	ERR_BULK_DIFFERENT_TABLES        = 48,
	ERR_BULK_NO_COLUMNS_TO           = 49,
	ERR_PUTPARAM_TRUNCATED_DATA      = 50,
	ERR_SERVER_REFUSED_SSL_CONNECTION= 51,
	ERR_SSL_ERROR                    = 52,
	ERR_BOOKMARK_IN_PARSE            = 53,
	ERR_BOOKMARK_ONE_QUERY           = 54,
	ERR_BOOKMARK_IN_BUFFERING_MODE   = 55,
	ERR_INVALID_ROWNUMBER            = 56,
	ERR_UNSUPPORTED_LOCKTYPE         = 57,
	ERR_UNSUPPORTED_OPERATION        = 58,
	ERR_FETCH_IMPOSSIBLE_ORIENTATION = 59,
	ERR_FETCH_NO_ROW_IN_RESULTSET    = 60,
	ERR_FETCH_INVALID_BOOKMARK_VALUE = 61,
	ERR_ERROR_DURING_CONNECT         = 62,
	ERR_CANT_INIT_OPEN_SSL           = 63,
	ERR_INVALID_DESC_IDENTIFIER      = 64,
	ERR_SSL_CERT_NOT_LOADED          = 65,
	ERR_TOO_LONG_DATA                = 66,
	ERR_OPTION_OUT_OF_RANGE          = 67,
	ERR_ROW_OUT_OF_RANGE             = 68,
	ERR_BAD_ALLOWED_OBJECTS_STRING   = 69,
	ERR_NOT_ALLOWED_OBJECT           = 70,
	ERR_EXTENDED_FETCH_BAD_FETCHTYPE = 71,
	ERR_FAILED_LOGIN_DLG             = 72,
	ERR_NEED_LOGIN_INFO              = 73,
	ERR_WRONG_PARAMETER              = 74
} ERR;

/*---------------------------------------------------------
	struct _diag_header
---------------------------------------------------------*/
struct _diag_header
{
	SQLINTEGER cursor_row_count;
	TCHAR*     dynamic_function;
	SQLINTEGER dynamic_function_code;
	SQLINTEGER number;
	SQLINTEGER allocated;
	SQLINTEGER row_count;
};

/*---------------------------------------------------------
	struct _diag_record
---------------------------------------------------------*/
struct _diag_record
{
	SQLTCHAR*  connection_name;
	SQLTCHAR*  server_name;
	SQLTCHAR*  suclass_origin;
	SQLINTEGER row_number;
	SQLINTEGER column_number;

	SQLTCHAR*  message_text;
	SQLINTEGER native;
};

typedef struct _diag_record DIAG_REC;
/*---------------------------------------------------------
	struct _error
---------------------------------------------------------*/
typedef struct 
{
	/* const */ TCHAR* sql_state;     /* corresponding SQLSTATE */
	/* const */ TCHAR* text;          /* ODBC driver error text, can contain parameters */ 
	unsigned int code;                /* ODBC driver native error code */
} Error;

/*---------------------------------------------------------
	struct _diag
---------------------------------------------------------*/
typedef struct _diag
{
	struct _diag_header   header;
	struct _diag_record*  records;

	/* andyk */
	SQLSMALLINT i;
} Diag;

extern const Error c_Errors[];

void InitDiag(Diag* pDiag);
void FreeDiag(Diag* pDiag);
SQLRETURN GetDiagData(SQLSMALLINT HandleType, SQLHANDLE Handle, SQLSMALLINT RecNumber, SQLSMALLINT DiagIdentifier, SQLTCHAR* Sqlstate, SQLINTEGER* NativeError, SQLTCHAR* MessageText, SQLSMALLINT BufferLength, SQLSMALLINT* TextLength);
SQLRETURN SetError(SQLSMALLINT HandleType, SQLHANDLE Handle, ERR nError, const TCHAR* szErrParams, ...);

#endif /* __ERROR__ */
