#include "descriptor.h"
#include "statement.h"
#include "error.h"

/*-----------------------------------------------------------------------------
 * SQLCloseCursor (READY)
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLCloseCursor(SQLHSTMT StatementHandle)
{
	SQLRETURN nRet;

	ENTER_STMT(StatementHandle, _T("SQLCloseCursor"));
	nRet = FreeStatement((Statement*) StatementHandle, SQL_CLOSE);
	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * SQLEndTran (READY)
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLEndTran(SQLSMALLINT HandleType, SQLHANDLE Handle, SQLSMALLINT CompletionType)
{
	BEGIN(_T("SQLEndTran"));
	END(EndTransaction(HandleType, Handle, CompletionType, TO_APPLICATION));
}

/*-----------------------------------------------------------------------------
 * SQLGetDiagField
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLGetDiagField_(SQLSMALLINT HandleType, SQLHANDLE Handle, SQLSMALLINT RecNumber, SQLSMALLINT DiagIdentifier,
                 SQLPOINTER DiagInfo, SQLSMALLINT BufferLength, SQLSMALLINT* StringLength)
{
	SQLRETURN nRet;

	BEGIN(_T("SQLGetDiagField"));
	nRet = GetDiagData(HandleType, Handle, RecNumber, DiagIdentifier, NULL, NULL, (SQLTCHAR*)DiagInfo, (SQLSMALLINT)BYTES_TO_CHARACTERS(BufferLength), StringLength);
	END(nRet);
}

/*-----------------------------------------------------------------------------
 * SQLGetDiagRec (READY)
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLGetDiagRec_(SQLSMALLINT HandleType, SQLHANDLE Handle, SQLSMALLINT RecNumber, SQLTCHAR* Sqlstate,
               SQLINTEGER* NativeError, SQLTCHAR* MessageText, SQLSMALLINT BufferLength, SQLSMALLINT *TextLength)
{
	SQLRETURN nRet;

	BEGIN(_T("SQLGetDiagRec"));
	nRet = GetDiagData(HandleType, Handle, RecNumber, 0, Sqlstate, NativeError, MessageText, BufferLength, TextLength);
	END(nRet);
}

