#include "connection.h"

/*-----------------------------------------------------------------------------
 * FUNCTION: sock_send
 *-----------------------------------------------------------------------------
 */
int sock_send(Connection* pConnection)
{
	int nSent;
	int nToSend = pConnection->pOutLast - pConnection->pOutFirst;
	while (nToSend > 0)
	{
		nSent = 
#ifdef USE_SSL
		(pConnection->ssl) ? SSL_WRITE(pConnection->ssl, pConnection->pOutFirst, nToSend) : 
#endif /* USE_SSL */
		send(pConnection->socket, (CHAR*)pConnection->pOutFirst, nToSend, 0);

		if (nSent < 0)
			return 1;

#ifdef NEED_LOG /* andyk */
	{
		FILE* file = fopen("modbc_send.log", "ab");
		fwrite(pConnection->pOutFirst, 1, nSent, file);
		fclose(file);
	}
#endif

		nToSend -= nSent;
		pConnection->pOutFirst += nSent;
	}
	pConnection->pOutLast  = pConnection->pOutBegin;
	pConnection->pOutFirst = pConnection->pOutBegin;
	return 0;
}

/*-----------------------------------------------------------------------------
 * FUNCTION: sock_recv
 *-----------------------------------------------------------------------------
 */
int sock_recv(Connection* pConnection)
{
	int nReceived;
	memcpy(pConnection->pInBegin, pConnection->pInFirst, pConnection->pInLast - pConnection->pInFirst);
	pConnection->pInLast += pConnection->pInBegin - pConnection->pInFirst;
	pConnection->pInFirst = pConnection->pInBegin;

	nReceived = 
#ifdef USE_SSL
		(pConnection->ssl) ? SSL_READ(pConnection->ssl, pConnection->pInLast, pConnection->pInEnd - pConnection->pInLast) :
#endif /* USE_SSL */
		recv(pConnection->socket, (CHAR*)pConnection->pInLast, (pConnection->pInEnd - pConnection->pInLast), 0);

	if (nReceived > 0)
	{
#ifdef NEED_LOG /* andyk */
	{
		FILE* file = fopen("modbc_recv.log", "ab");
		fwrite(pConnection->pInLast, 1, nReceived, file);
		fclose(file);
	}
#endif
		pConnection->pInLast += nReceived;
	}
	return nReceived;
}

/*-----------------------------------------------------------------------------
 * FUNCTION: sock_connect
 *-----------------------------------------------------------------------------
 */
SQLRETURN
sock_connect(Connection* pConnection)
{
	struct hostent* hp;
	int             a_type;

#ifdef UNICODE
	char server_name[SERVER_MAX_LENGTH+1];
	WideCharToMultiByte(0, 0, pConnection->parameters[SERVER_PARAM], wcslen(pConnection->parameters[SERVER_PARAM])+1, server_name, sizeof(server_name), NULL, NULL);
#else
	char* server_name = pConnection->parameters[SERVER_PARAM];
#endif /* UNICODE */

	if (_T('\0') == pConnection->parameters[SERVER_PARAM][0] ||
	    _T('\0') == pConnection->parameters[PORT_PARAM][0]
	   )
	{/* Theoreticaly we shoudn't get in here */
		SetError(SQL_HANDLE_DBC, pConnection, ERR_UNKNOWN_HOST, pConnection->parameters[SERVER_PARAM], pConnection->parameters[PORT_PARAM]);
		return SQL_ERROR;
	}

	if (NULL == (hp = gethostbyname(server_name)))
	{
		unsigned long addr = inet_addr(server_name);
		hp = gethostbyaddr((const char *)&addr, sizeof(addr), AF_INET);
	}
	
	if (hp == NULL || AF_INET != (a_type = hp->h_addrtype))
	{
		SetError(SQL_HANDLE_DBC, pConnection, ERR_UNKNOWN_HOST, pConnection->parameters[SERVER_PARAM], pConnection->parameters[PORT_PARAM], NULL);
		return SQL_ERROR;
	}

	pConnection->addr.sin_addr = *(struct in_addr*) hp->h_addr;
	pConnection->addr.sin_family = AF_INET;
	pConnection->addr.sin_port = htons((unsigned short)_ttoi(pConnection->parameters[PORT_PARAM]));

	if (0  > (pConnection->socket = socket(AF_INET, SOCK_STREAM, 0)) ||
	    0 != connect(pConnection->socket, (struct sockaddr*) &pConnection->addr, sizeof(pConnection->addr))
	   )
	{
		SetError(SQL_HANDLE_DBC, pConnection, ERR_CANT_CONNECT_TO_HOST, pConnection->parameters[SERVER_PARAM], pConnection->parameters[PORT_PARAM], NULL);
		return SQL_ERROR;
	}

	return SQL_SUCCESS;
}

/*-----------------------------------------------------------------------------
 * FUNCTION: sock_close
 *-----------------------------------------------------------------------------
 */
SQLRETURN
sock_close(Connection* pConnection)
{
	closesocket(pConnection->socket);
	pConnection->socket = INVALID_SOCKET;
	return SQL_SUCCESS;
}

