/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.definition.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.ext.definition.DefinitionItem;
import com.vladsch.flexmark.ext.definition.internal.DefinitionOptions;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.DocumentBlockParser;
import com.vladsch.flexmark.parser.core.ParagraphParser;
import com.vladsch.flexmark.util.ast.BlankLine;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import java.util.Set;

public class DefinitionItemBlockParser
extends AbstractBlockParser {
    private final DefinitionItem block;
    private final DefinitionOptions options;
    private final ItemData itemData;
    private boolean hadBlankLine;

    DefinitionItemBlockParser(DataHolder options, ItemData itemData) {
        this.options = new DefinitionOptions(options);
        this.itemData = itemData;
        this.block = new DefinitionItem();
        this.block.setOpeningMarker(itemData.itemMarker);
        this.block.setTight(itemData.isTight);
    }

    private int getContentIndent() {
        return this.itemData.markerIndent + this.itemData.itemMarker.length() + this.itemData.contentOffset;
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean isContainer() {
        return true;
    }

    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return true;
    }

    static ItemData parseItemMarker(DefinitionOptions options, ParserState state, boolean isTight) {
        BasedSequence line = state.getLine();
        int markerIndex = state.getNextNonSpaceIndex();
        int markerColumn = state.getColumn() + state.getIndent();
        int markerIndent = state.getIndent();
        BasedSequence rest = line.subSequence(markerIndex, line.length());
        char c1 = rest.firstChar();
        if (!(c1 == ':' && options.colonMarker || c1 == '~' && options.tildeMarker)) {
            return null;
        }
        int contentOffset = 0;
        boolean hasContent = false;
        for (int i = markerIndex + 1; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\t') {
                contentOffset += Parsing.columnsToNextTabStop((int)(markerColumn + 1 + contentOffset));
                continue;
            }
            if (c == ' ') {
                ++contentOffset;
                continue;
            }
            hasContent = true;
            break;
        }
        if (hasContent && contentOffset < options.markerSpaces) {
            return null;
        }
        if (!hasContent || options.myParserEmulationProfile == ParserEmulationProfile.COMMONMARK && contentOffset > options.newItemCodeIndent) {
            contentOffset = 1;
        }
        return new ItemData(!hasContent, isTight, markerIndex, markerColumn, markerIndent, contentOffset, rest.subSequence(0, 1));
    }

    public BlockContinue tryContinue(ParserState state) {
        boolean isEmpty;
        Node firstChild = this.block.getFirstChild();
        boolean bl = isEmpty = firstChild == null;
        if (state.isBlank()) {
            if (isEmpty || firstChild.getNext() == null) {
                this.block.setHadBlankAfterItemParagraph(true);
            }
            this.hadBlankLine = true;
            return BlockContinue.atIndex((int)state.getNextNonSpaceIndex());
        }
        ParserEmulationProfile emulationFamily = this.options.myParserEmulationProfile.family;
        if (emulationFamily == ParserEmulationProfile.COMMONMARK || emulationFamily == ParserEmulationProfile.KRAMDOWN || emulationFamily == ParserEmulationProfile.MARKDOWN) {
            int currentIndent = state.getIndent();
            int newColumn = state.getColumn() + this.getContentIndent();
            if (currentIndent >= this.getContentIndent()) {
                return BlockContinue.atColumn((int)newColumn);
            }
            if (isEmpty) {
                return BlockContinue.atIndex((int)(state.getIndex() + currentIndent));
            }
            ItemData itemData = DefinitionItemBlockParser.parseItemMarker(this.options, state, false);
            if (itemData != null) {
                return BlockContinue.none();
            }
            if (!this.hadBlankLine) {
                return BlockContinue.atIndex((int)(state.getIndex() + currentIndent));
            }
        } else if (emulationFamily == ParserEmulationProfile.FIXED_INDENT) {
            int currentIndent = state.getIndent();
            int newColumn = state.getColumn() + this.options.itemIndent;
            if (currentIndent >= this.options.itemIndent) {
                return BlockContinue.atColumn((int)newColumn);
            }
            if (isEmpty) {
                return BlockContinue.atIndex((int)(state.getIndex() + currentIndent));
            }
            ItemData itemData = DefinitionItemBlockParser.parseItemMarker(this.options, state, false);
            if (itemData != null) {
                return BlockContinue.none();
            }
            if (!this.hadBlankLine) {
                return BlockContinue.atIndex((int)(state.getIndex() + currentIndent));
            }
        }
        return BlockContinue.none();
    }

    public void addLine(ParserState state, BasedSequence line) {
    }

    public void closeBlock(ParserState state) {
        this.block.setCharsFromContent();
    }

    public void parseInlines(InlineParser inlineParser) {
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final DefinitionOptions options;

        BlockFactory(DataHolder options) {
            super(options);
            this.options = new DefinitionOptions(options);
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            ItemData itemData;
            int codeIndent;
            BlockParser blockParser = matchedBlockParser.getBlockParser();
            if (blockParser instanceof DocumentBlockParser) {
                Document node = ((DocumentBlockParser)blockParser).getBlock();
                Block lastChildAnyNot = (Block)node.getLastChildAnyNot(new Class[]{BlankLine.class});
                if (!(lastChildAnyNot instanceof Paragraph) && !(lastChildAnyNot instanceof DefinitionItem)) {
                    return BlockStart.none();
                }
                if (this.options.doubleBlankLineBreaksList) {
                    lastChildAnyNot.setCharsFromContent();
                    BasedSequence interSpace = BasedSequenceImpl.of((CharSequence)state.getLine().baseSubSequence(lastChildAnyNot.getEndOffset(), state.getLine().getStartOffset()).normalizeEOL());
                    if (interSpace.countLeading('\n') >= 2) {
                        return BlockStart.none();
                    }
                }
            } else if (!(blockParser instanceof DefinitionItemBlockParser) && !(blockParser instanceof ParagraphParser)) {
                return BlockStart.none();
            }
            ParserEmulationProfile emulationFamily = this.options.myParserEmulationProfile;
            int currentIndent = state.getIndent();
            int n = codeIndent = emulationFamily == ParserEmulationProfile.COMMONMARK || emulationFamily == ParserEmulationProfile.FIXED_INDENT ? this.options.codeIndent : this.options.itemIndent;
            if (currentIndent < codeIndent && (itemData = DefinitionItemBlockParser.parseItemMarker(this.options, state, state.getActiveBlockParser() instanceof ParagraphParser)) != null) {
                BlockStart blockStart = BlockStart.of((BlockParser[])new BlockParser[]{new DefinitionItemBlockParser((DataHolder)state.getProperties(), itemData)}).atColumn(itemData.markerColumn + itemData.itemMarker.length() + itemData.contentOffset);
                return blockStart;
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public BlockParserFactory create(DataHolder options) {
            return new BlockFactory(options);
        }
    }

    static class ItemData {
        final boolean isEmpty;
        final boolean isTight;
        final int markerIndex;
        final int markerColumn;
        final int markerIndent;
        final int contentOffset;
        final BasedSequence itemMarker;

        ItemData(boolean isEmpty, boolean isTight, int markerIndex, int markerColumn, int markerIndent, int contentOffset, BasedSequence itemMarker) {
            this.isEmpty = isEmpty;
            this.isTight = isTight;
            this.markerIndex = markerIndex;
            this.markerColumn = markerColumn;
            this.markerIndent = markerIndent;
            this.contentOffset = contentOffset;
            this.itemMarker = itemMarker;
        }
    }
}

