/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSBitwiseOrConstantNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSBitwiseOrConstantNode.class)
public final class JSBitwiseOrConstantNodeGen
extends JSBitwiseOrConstantNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private JSToInt32Node double_leftInt32_;
    @Node.Child
    private GenericIntCaseData genericIntCase_cache;
    @Node.Child
    private JSToNumericNode genericBigIntCase_toNumeric_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile genericBigIntCase_profileIsBigInt_;

    private JSBitwiseOrConstantNodeGen(JavaScriptNode left, Object rightValue) {
        super(left, rightValue);
    }

    @Override
    public Object executeObject(Object operandNodeValue) {
        int state = this.state_;
        if ((state & 1) != 0 && operandNodeValue instanceof Integer) {
            int operandNodeValue_ = (Integer)operandNodeValue;
            assert (this.isInt);
            return this.doInteger(operandNodeValue_);
        }
        if ((state & 2) != 0 && operandNodeValue instanceof SafeInteger) {
            SafeInteger operandNodeValue_ = (SafeInteger)operandNodeValue;
            assert (this.isInt);
            return this.doSafeInteger(operandNodeValue_);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E00) >>> 9, operandNodeValue)) {
            double operandNodeValue_ = JSTypesGen.asImplicitDouble((state & 0x1E00) >>> 9, operandNodeValue);
            assert (this.isInt);
            return this.doDouble(operandNodeValue_, this.double_leftInt32_);
        }
        if ((state & 0x40) != 0 && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_ = (BigInt)operandNodeValue;
            assert (!this.isInt);
            return this.doBigInt(operandNodeValue_);
        }
        if ((state & 0x180) != 0) {
            GenericIntCaseData s8_;
            if ((state & 0x80) != 0 && (s8_ = this.genericIntCase_cache) != null) {
                assert (this.isInt);
                return this.doGenericIntCase(operandNodeValue, s8_.toNumeric_, s8_.profileIsBigInt_, s8_.innerOrNode_);
            }
            if ((state & 0x100) != 0) {
                assert (!this.isInt());
                return this.doGenericBigIntCase(operandNodeValue, this.genericBigIntCase_toNumeric_, this.genericBigIntCase_profileIsBigInt_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        int state = this.state_;
        if ((state & 1) != 0 && operandNodeValue instanceof Integer) {
            int operandNodeValue_ = (Integer)operandNodeValue;
            assert (this.isInt);
            return this.doInteger(operandNodeValue_);
        }
        if ((state & 2) != 0 && operandNodeValue instanceof SafeInteger) {
            SafeInteger operandNodeValue_ = (SafeInteger)operandNodeValue;
            assert (this.isInt);
            return this.doSafeInteger(operandNodeValue_);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E00) >>> 9, operandNodeValue)) {
            double operandNodeValue_ = JSTypesGen.asImplicitDouble((state & 0x1E00) >>> 9, operandNodeValue);
            assert (this.isInt);
            return this.doDouble(operandNodeValue_, this.double_leftInt32_);
        }
        if ((state & 0x40) != 0 && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_ = (BigInt)operandNodeValue;
            assert (!this.isInt);
            return this.doBigInt(operandNodeValue_);
        }
        if ((state & 0x180) != 0) {
            GenericIntCaseData s8_;
            if ((state & 0x80) != 0 && (s8_ = this.genericIntCase_cache) != null) {
                assert (this.isInt);
                return this.doGenericIntCase(operandNodeValue, s8_.toNumeric_, s8_.profileIsBigInt_, s8_.innerOrNode_);
            }
            if ((state & 0x100) != 0) {
                assert (!this.isInt());
                return this.doGenericBigIntCase(operandNodeValue, this.genericBigIntCase_toNumeric_, this.genericBigIntCase_profileIsBigInt_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x1C6) == 0 && (state & 0x1C7) != 0) {
            return this.execute_int0(frameValue, state);
        }
        if ((state & 0x1C3) == 0 && (state & 0x1C7) != 0) {
            return this.execute_double1(frameValue, state);
        }
        return this.execute_generic2(frameValue, state);
    }

    private Object execute_int0(VirtualFrame frameValue, int state) {
        int operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        assert (this.isInt);
        return this.doInteger(operandNodeValue_);
    }

    private Object execute_double1(VirtualFrame frameValue, int state) {
        double operandNodeValue_;
        int operandNodeValue_int = 0;
        long operandNodeValue_long = 0L;
        try {
            if ((state & 0x1C00) == 0 && (state & 0x1FF) != 0) {
                operandNodeValue_long = this.operandNode.executeLong(frameValue);
                operandNodeValue_ = JSTypes.longToDouble(operandNodeValue_long);
            } else if ((state & 0x1A00) == 0 && (state & 0x1FF) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else if ((state & 0x1600) == 0 && (state & 0x1FF) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x1E00) >>> 9, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 4) != 0);
        assert (this.isInt);
        return this.doDouble(operandNodeValue_, this.double_leftInt32_);
    }

    private Object execute_generic2(VirtualFrame frameValue, int state) {
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state & 1) != 0 && operandNodeValue_ instanceof Integer) {
            int operandNodeValue__ = (Integer)operandNodeValue_;
            assert (this.isInt);
            return this.doInteger(operandNodeValue__);
        }
        if ((state & 2) != 0 && operandNodeValue_ instanceof SafeInteger) {
            SafeInteger operandNodeValue__ = (SafeInteger)operandNodeValue_;
            assert (this.isInt);
            return this.doSafeInteger(operandNodeValue__);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E00) >>> 9, operandNodeValue_)) {
            double operandNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x1E00) >>> 9, operandNodeValue_);
            assert (this.isInt);
            return this.doDouble(operandNodeValue__, this.double_leftInt32_);
        }
        if ((state & 0x40) != 0 && operandNodeValue_ instanceof BigInt) {
            BigInt operandNodeValue__ = (BigInt)operandNodeValue_;
            assert (!this.isInt);
            return this.doBigInt(operandNodeValue__);
        }
        if ((state & 0x180) != 0) {
            GenericIntCaseData s8_;
            if ((state & 0x80) != 0 && (s8_ = this.genericIntCase_cache) != null) {
                assert (this.isInt);
                return this.doGenericIntCase(operandNodeValue_, s8_.toNumeric_, s8_.profileIsBigInt_, s8_.innerOrNode_);
            }
            if ((state & 0x100) != 0) {
                assert (!this.isInt());
                return this.doGenericBigIntCase(operandNodeValue_, this.genericBigIntCase_toNumeric_, this.genericBigIntCase_profileIsBigInt_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = this.state_;
        if ((state & 0x80) != 0) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        if ((state & 6) == 0 && (state & 7) != 0) {
            return this.executeInt_int3(frameValue, state);
        }
        if ((state & 3) == 0 && (state & 7) != 0) {
            return this.executeInt_double4(frameValue, state);
        }
        return this.executeInt_generic5(frameValue, state);
    }

    private int executeInt_int3(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        int operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult()));
        }
        assert ((state & 1) != 0);
        assert (this.isInt);
        return this.doInteger(operandNodeValue_);
    }

    private int executeInt_double4(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        double operandNodeValue_;
        int operandNodeValue_int = 0;
        long operandNodeValue_long = 0L;
        try {
            if ((state & 0x1C00) == 0 && (state & 0x1FF) != 0) {
                operandNodeValue_long = this.operandNode.executeLong(frameValue);
                operandNodeValue_ = JSTypes.longToDouble(operandNodeValue_long);
            } else if ((state & 0x1A00) == 0 && (state & 0x1FF) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else if ((state & 0x1600) == 0 && (state & 0x1FF) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x1E00) >>> 9, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult()));
        }
        assert ((state & 4) != 0);
        assert (this.isInt);
        return this.doDouble(operandNodeValue_, this.double_leftInt32_);
    }

    private int executeInt_generic5(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state & 1) != 0 && operandNodeValue_ instanceof Integer) {
            int operandNodeValue__ = (Integer)operandNodeValue_;
            assert (this.isInt);
            return this.doInteger(operandNodeValue__);
        }
        if ((state & 2) != 0 && operandNodeValue_ instanceof SafeInteger) {
            SafeInteger operandNodeValue__ = (SafeInteger)operandNodeValue_;
            assert (this.isInt);
            return this.doSafeInteger(operandNodeValue__);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E00) >>> 9, operandNodeValue_)) {
            double operandNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x1E00) >>> 9, operandNodeValue_);
            assert (this.isInt);
            return this.doDouble(operandNodeValue__, this.double_leftInt32_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(operandNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 0x1F8) == 0 && (state & 0x1FF) != 0) {
                this.executeInt(frameValue);
                return;
            }
            if ((state & 0x1C7) != 0) {
                this.execute(frameValue);
                return;
            }
        }
        catch (UnexpectedResultException ex) {
            return;
        }
        if ((state & 0x30) == 0 && (state & 0x38) != 0) {
            this.executeVoid_int6(frameValue, state);
            return;
        }
        if ((state & 0x28) == 0 && (state & 0x38) != 0) {
            this.executeVoid_double7(frameValue, state);
            return;
        }
        this.executeVoid_generic8(frameValue, state);
    }

    private void executeVoid_int6(VirtualFrame frameValue, int state) {
        int operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            this.executeAndSpecialize(ex.getResult());
            return;
        }
        assert ((state & 8) != 0);
        assert (!this.isInt);
        this.doIntegerThrows(operandNodeValue_);
    }

    private void executeVoid_double7(VirtualFrame frameValue, int state) {
        double operandNodeValue_;
        int operandNodeValue_int = 0;
        long operandNodeValue_long = 0L;
        try {
            if ((state & 0x1C00) == 0 && (state & 0x1FF) != 0) {
                operandNodeValue_long = this.operandNode.executeLong(frameValue);
                operandNodeValue_ = JSTypes.longToDouble(operandNodeValue_long);
            } else if ((state & 0x1A00) == 0 && (state & 0x1FF) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else if ((state & 0x1600) == 0 && (state & 0x1FF) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x1E00) >>> 9, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            this.executeAndSpecialize(ex.getResult());
            return;
        }
        assert ((state & 0x10) != 0);
        assert (!this.isInt);
        this.doDoubleThrows(operandNodeValue_);
    }

    private void executeVoid_generic8(VirtualFrame frameValue, int state) {
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state & 8) != 0 && operandNodeValue_ instanceof Integer) {
            int operandNodeValue__ = (Integer)operandNodeValue_;
            assert (!this.isInt);
            this.doIntegerThrows(operandNodeValue__);
            return;
        }
        if ((state & 0x10) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E00) >>> 9, operandNodeValue_)) {
            double operandNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x1E00) >>> 9, operandNodeValue_);
            assert (!this.isInt);
            this.doDoubleThrows(operandNodeValue__);
            return;
        }
        if ((state & 0x20) != 0 && operandNodeValue_ instanceof BigInt) {
            BigInt operandNodeValue__ = (BigInt)operandNodeValue_;
            assert (this.isInt);
            this.doBigIntThrows(operandNodeValue__);
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(operandNodeValue_);
    }

    private Object executeAndSpecialize(Object operandNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            double operandNodeValue_5;
            int doubleCast0;
            if ((exclude & 1) == 0 && operandNodeValue instanceof Integer) {
                int operandNodeValue_2 = (Integer)operandNodeValue;
                if (this.isInt) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doInteger(operandNodeValue_2);
                    return n;
                }
            }
            if ((exclude & 2) == 0 && operandNodeValue instanceof SafeInteger) {
                SafeInteger operandNodeValue_3 = (SafeInteger)operandNodeValue;
                if (this.isInt) {
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doSafeInteger(operandNodeValue_3);
                    return n;
                }
            }
            if ((exclude & 4) == 0 && (doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue)) != 0) {
                operandNodeValue_5 = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                if (this.isInt) {
                    this.double_leftInt32_ = (JSToInt32Node)super.insert((Node)JSToInt32Node.create());
                    state |= doubleCast0 << 9;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doDouble(operandNodeValue_5, this.double_leftInt32_);
                    return n;
                }
            }
            if ((exclude & 8) == 0 && operandNodeValue instanceof Integer) {
                int operandNodeValue_4 = (Integer)operandNodeValue;
                if (!this.isInt) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    this.doIntegerThrows(operandNodeValue_4);
                    Object operandNodeValue_5 = null;
                    return operandNodeValue_5;
                }
            }
            if ((exclude & 0x10) == 0 && (doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue)) != 0) {
                operandNodeValue_5 = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                if (!this.isInt) {
                    state |= doubleCast0 << 9;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    this.doDoubleThrows(operandNodeValue_5);
                    Object var9_22 = null;
                    return var9_22;
                }
            }
            if (operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_6 = (BigInt)operandNodeValue;
                if ((exclude & 0x20) == 0 && this.isInt) {
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    this.doBigIntThrows(operandNodeValue_6);
                    Object var7_18 = null;
                    return var7_18;
                }
                if ((exclude & 0x40) == 0 && !this.isInt) {
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    BigInt bigInt = this.doBigInt(operandNodeValue_6);
                    return bigInt;
                }
            }
            if (this.isInt) {
                GenericIntCaseData s8_ = (GenericIntCaseData)super.insert((Node)new GenericIntCaseData());
                s8_.toNumeric_ = s8_.insertAccessor(JSToNumericNode.create());
                s8_.profileIsBigInt_ = ConditionProfile.createBinaryProfile();
                s8_.innerOrNode_ = s8_.insertAccessor(this.makeCopy());
                this.genericIntCase_cache = s8_;
                this.exclude_ = exclude |= 0x27;
                state &= 0xFFFFFFD8;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                Object object = this.doGenericIntCase(operandNodeValue, s8_.toNumeric_, s8_.profileIsBigInt_, s8_.innerOrNode_);
                return object;
            }
            if (!this.isInt()) {
                this.genericBigIntCase_toNumeric_ = (JSToNumericNode)super.insert((Node)JSToNumericNode.create());
                this.genericBigIntCase_profileIsBigInt_ = ConditionProfile.createBinaryProfile();
                this.exclude_ = exclude |= 0x58;
                state &= 0xFFFFFFA7;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                BigInt bigInt = this.doGenericBigIntCase(operandNodeValue, this.genericBigIntCase_toNumeric_, this.genericBigIntCase_profileIsBigInt_);
                return bigInt;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode}, new Object[]{operandNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x1FF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x1FF & (state & 0x1FF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[10];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[1] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[2] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.double_leftInt32_));
            s[2] = cached;
        } else {
            s[1] = (exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doIntegerThrows";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : ((exclude & 8) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[4] = s;
        s = new Object[3];
        s[0] = "doDoubleThrows";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : ((exclude & 0x10) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[5] = s;
        s = new Object[3];
        s[0] = "doBigIntThrows";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : ((exclude & 0x20) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[6] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : ((exclude & 0x40) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[7] = s;
        s = new Object[3];
        s[0] = "doGenericIntCase";
        if ((state & 0x80) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            GenericIntCaseData s8_ = this.genericIntCase_cache;
            if (s8_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s8_.toNumeric_, s8_.profileIsBigInt_, s8_.innerOrNode_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "doGenericBigIntCase";
        if ((state & 0x100) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Cloneable[]{this.genericBigIntCase_toNumeric_, this.genericBigIntCase_profileIsBigInt_}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[9] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSBitwiseOrConstantNode create(JavaScriptNode left, Object rightValue) {
        return new JSBitwiseOrConstantNodeGen(left, rightValue);
    }

    @GeneratedBy(value=JSBitwiseOrConstantNode.class)
    private static final class GenericIntCaseData
    extends Node {
        @Node.Child
        JSToNumericNode toNumeric_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile profileIsBigInt_;
        @Node.Child
        JavaScriptNode innerOrNode_;

        GenericIntCaseData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

