/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativeimage;

import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class UnmanagedMemory {
    private UnmanagedMemory() {
    }

    public static <T extends PointerBase> T malloc(UnsignedWord size) {
        return ImageSingletons.lookup(UnmanagedMemorySupport.class).malloc(size);
    }

    public static <T extends PointerBase> T malloc(int size) {
        return ImageSingletons.lookup(UnmanagedMemorySupport.class).malloc((UnsignedWord)WordFactory.unsigned(size));
    }

    public static <T extends PointerBase> T calloc(UnsignedWord size) {
        return ImageSingletons.lookup(UnmanagedMemorySupport.class).calloc(size);
    }

    public static <T extends PointerBase> T calloc(int size) {
        return ImageSingletons.lookup(UnmanagedMemorySupport.class).calloc((UnsignedWord)WordFactory.unsigned(size));
    }

    public static <T extends PointerBase> T realloc(T ptr, UnsignedWord size) {
        return ImageSingletons.lookup(UnmanagedMemorySupport.class).realloc(ptr, size);
    }

    public static void free(PointerBase ptr) {
        ImageSingletons.lookup(UnmanagedMemorySupport.class).free(ptr);
    }
}

