/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.bzip2;

import java.io.IOException;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.bzip2.BZip2Compressor;
import org.codehaus.plexus.archiver.exceptions.EmptyArchiveException;

public class BZip2Archiver
extends AbstractArchiver {
    private BZip2Compressor compressor = new BZip2Compressor();

    @Override
    public void execute() throws ArchiverException, IOException {
        if (!this.checkForced()) {
            return;
        }
        ResourceIterator iter = this.getResources();
        if (!iter.hasNext()) {
            throw new EmptyArchiveException("archive cannot be empty");
        }
        ArchiveEntry entry = iter.next();
        if (iter.hasNext()) {
            throw new ArchiverException("There is more than one file in input.");
        }
        this.compressor.setSource(entry.getResource());
        this.compressor.setDestFile(this.getDestFile());
        this.compressor.compress();
    }

    @Override
    public boolean isSupportingForced() {
        return true;
    }

    @Override
    protected void close() {
        this.compressor.close();
    }

    @Override
    protected String getArchiveType() {
        return "bzip2";
    }
}

