/***********************************************************************
 *
 * Copyright (C) 2012, 2013, 2015 Graeme Gott <graeme@gottcode.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

#ifndef SESSION_DELEGATE_H
#define SESSION_DELEGATE_H

#include <QStyledItemDelegate>

class SessionDelegate : public QStyledItemDelegate
{
public:
	SessionDelegate(QObject* parent = 0);

	void paint(QPainter* painter, const QStyleOptionViewItem& option, const QModelIndex& index) const;
	void setDevicePixelRatio(int ratio);
	void setModelData(QWidget* editor, QAbstractItemModel* model, const QModelIndex& index) const;
	QSize sizeHint(const QStyleOptionViewItem& option, const QModelIndex& index) const;

private:
	int m_height;
	int m_ratio;
	QVector<int> m_alphas;
};

#endif
