#include <cgreen/cgreen.h>
#include "../assert_octave.h"

#include <octave/oct.h>

#include "../../normal.h"

// holds utility functions: scramble_matrix() and get_2random_idx()
// and holds the data produced or fed to/form 
// TISEAN's randomize_auto_exp_random: ts_data[] and normalized_data[]
#include "util.h"

using namespace cgreen;

Ensure (normal1_gives_same_result_as_in_tisean)
{
  // Construct and load data to matrix
  Matrix ts_series(50,1);
  memcpy (ts_series.fortran_vec (), ts_data, sizeof (ts_data));

  // Perform test
  double mean, rms_ampl;
  normal1 (ts_series, mean, rms_ampl);

  Matrix normalized_series (ts_series.dims ());
  // load normalized data generated by TISEAN
  memcpy (normalized_series.fortran_vec (), normalized_data,
          sizeof (normalized_data));

  assert_matrix_equal_with_tol (ts_series, normalized_series, 1e-6);
}

Ensure (normal1_result_is_not_influenced_by_element_order)
{
  // Construct and load data to matrix
  Matrix ts_series(50,1);
  memcpy (ts_series.fortran_vec (), ts_data, sizeof (ts_data));

  // Scramble copy of ts_series
  Matrix series_scrambled (ts_series);
  scramble_matrix (series_scrambled);

  // Perform test
  double mean, rms_ampl;
  normal1 (ts_series, mean, rms_ampl);
  double mean_scr, rms_ampl_scr;
  normal1 (series_scrambled, mean_scr, rms_ampl_scr);

  assert_that_double (mean_scr, is_equal_to_double (mean));
  assert_that_double (rms_ampl_scr, is_equal_to_double (rms_ampl));
}

Ensure (normal1_returns_same_output_after_multiple_calls)
{
  // Construct and load data to matrix
  Matrix ts_series(50,1);
  memcpy (ts_series.fortran_vec (), ts_data, sizeof (ts_data));

  // Perform test
  double mean, rms_ampl;

  normal1 (ts_series, mean, rms_ampl);
  Matrix normalized (ts_series);

  normal1 (normalized, mean, rms_ampl);

  assert_matrix_equal_with_tol (normalized, ts_series, 1e-6);
}

Ensure (normal1_gives_mean_0_and_rms_ampl_1_when_input_is_normalized)
{
  // Construct and load data to matrix
  Matrix ts_series(50,1);
  memcpy (ts_series.fortran_vec (), ts_data, sizeof (ts_data));

  // Prepare normalized input
  double mean;
  double rms_ampl;
  normal1 (ts_series, mean, rms_ampl);

  // Perform test
  normal1 (ts_series, mean, rms_ampl);

  // bug in cgreen (have to add +1-1 to get it to work)

  assert_that_double (rms_ampl, is_equal_to_double (1));
  assert_that_double (mean +1 -1, is_equal_to_double (0));
}

//! setup function
void prepare_normal ()
{
  init_util ();
  significant_figures_for_assert_double_are (8);
}

TestSuite *normal_tests ()
{
  TestSuite *suite = create_test_suite ();
  set_setup (suite, prepare_normal );
  add_test (suite, normal1_gives_same_result_as_in_tisean);
  add_test (suite, normal1_result_is_not_influenced_by_element_order);
  add_test (suite, normal1_returns_same_output_after_multiple_calls);
  add_test (suite, normal1_gives_mean_0_and_rms_ampl_1_when_input_is_normalized);
  return suite;
}
