; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=aarch64-linux-gnu -O3 -verify-machineinstrs | FileCheck %s

define void @fnmaddd(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: fnmaddd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ldr d1, [x1]
; CHECK-NEXT:    ldr d2, [x2]
; CHECK-NEXT:    fnmadd d0, d1, d0, d2
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load double, ptr %a, align 8
  %1 = load double, ptr %b, align 8
  %mul = fmul fast double %1, %0
  %2 = load double, ptr %c, align 8
  %add = fadd fast double %mul, %2
  %fneg = fneg fast double %add
  store double %fneg, ptr %a, align 8
  ret void
}

; Don't combine: No flags
define void @fnmaddd_no_fast(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: fnmaddd_no_fast:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ldr d1, [x1]
; CHECK-NEXT:    fmul d0, d1, d0
; CHECK-NEXT:    ldr d1, [x2]
; CHECK-NEXT:    fadd d0, d0, d1
; CHECK-NEXT:    fneg d0, d0
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load double, ptr %a, align 8
  %1 = load double, ptr %b, align 8
  %mul = fmul double %1, %0
  %2 = load double, ptr %c, align 8
  %add = fadd double %mul, %2
  %fneg = fneg double %add
  store double %fneg, ptr %a, align 8
  ret void
}

define void @fnmadds(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: fnmadds:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr s0, [x0]
; CHECK-NEXT:    ldr s1, [x1]
; CHECK-NEXT:    ldr s2, [x2]
; CHECK-NEXT:    fnmadd s0, s1, s0, s2
; CHECK-NEXT:    str s0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load float, ptr %a, align 4
  %1 = load float, ptr %b, align 4
  %mul = fmul fast float %1, %0
  %2 = load float, ptr %c, align 4
  %add = fadd fast float %mul, %2
  %fneg = fneg fast float %add
  store float %fneg, ptr %a, align 4
  ret void
}

define void @fnmadds_nsz_contract(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: fnmadds_nsz_contract:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr s0, [x0]
; CHECK-NEXT:    ldr s1, [x1]
; CHECK-NEXT:    ldr s2, [x2]
; CHECK-NEXT:    fnmadd s0, s1, s0, s2
; CHECK-NEXT:    str s0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load float, ptr %a, align 4
  %1 = load float, ptr %b, align 4
  %mul = fmul contract nsz float %1, %0
  %2 = load float, ptr %c, align 4
  %add = fadd contract nsz float %mul, %2
  %fneg = fneg contract nsz float %add
  store float %fneg, ptr %a, align 4
  ret void
}

; Don't combine: Missing nsz
define void @fnmadds_contract(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: fnmadds_contract:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr s0, [x0]
; CHECK-NEXT:    ldr s1, [x1]
; CHECK-NEXT:    ldr s2, [x2]
; CHECK-NEXT:    fmadd s0, s1, s0, s2
; CHECK-NEXT:    fneg s0, s0
; CHECK-NEXT:    str s0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load float, ptr %a, align 4
  %1 = load float, ptr %b, align 4
  %mul = fmul contract float %1, %0
  %2 = load float, ptr %c, align 4
  %add = fadd contract float %mul, %2
  %fneg = fneg contract float %add
  store float %fneg, ptr %a, align 4
  ret void
}

; Don't combine: Missing contract
define void @fnmadds_nsz(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: fnmadds_nsz:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr s0, [x0]
; CHECK-NEXT:    ldr s1, [x1]
; CHECK-NEXT:    fmul s0, s1, s0
; CHECK-NEXT:    ldr s1, [x2]
; CHECK-NEXT:    fadd s0, s0, s1
; CHECK-NEXT:    fneg s0, s0
; CHECK-NEXT:    str s0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load float, ptr %a, align 4
  %1 = load float, ptr %b, align 4
  %mul = fmul nsz float %1, %0
  %2 = load float, ptr %c, align 4
  %add = fadd nsz float %mul, %2
  %fneg = fneg nsz float %add
  store float %fneg, ptr %a, align 4
  ret void
}

define void @fnmaddd_two_uses(ptr %a, ptr %b, ptr %c, ptr %d) {
; CHECK-LABEL: fnmaddd_two_uses:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr d0, [x1]
; CHECK-NEXT:    ldr d1, [x0]
; CHECK-NEXT:    ldr d2, [x2]
; CHECK-NEXT:    fmadd d0, d0, d1, d2
; CHECK-NEXT:    fneg d1, d0
; CHECK-NEXT:    str d1, [x0]
; CHECK-NEXT:    str d0, [x3]
; CHECK-NEXT:    ret
entry:
  %0 = load double, ptr %a, align 8
  %1 = load double, ptr %b, align 8
  %mul = fmul fast double %1, %0
  %2 = load double, ptr %c, align 8
  %add = fadd fast double %mul, %2
  %fneg1 = fneg fast double %add
  store double %fneg1, ptr %a, align 8
  store double %add, ptr %d, align 8
  ret void
}
