# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.synapse import SynapseManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-synapse
# USAGE
    python create_or_update_workspace.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SynapseManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-1111-2222-3333-444444444444",
    )

    response = client.workspaces.begin_create_or_update(
        resource_group_name="resourceGroup1",
        workspace_name="workspace1",
        workspace_info={
            "identity": {
                "type": "SystemAssigned,UserAssigned",
                "userAssignedIdentities": {
                    "/subscriptions/00000000-1111-2222-3333-444444444444/resourcegroups/resourceGroup1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uami1": {}
                },
            },
            "location": "East US",
            "properties": {
                "cspWorkspaceAdminProperties": {
                    "initialWorkspaceAdminObjectId": "6c20646f-8050-49ec-b3b1-80a0e58e454d"
                },
                "defaultDataLakeStorage": {
                    "accountUrl": "https://accountname.dfs.core.windows.net",
                    "filesystem": "default",
                },
                "encryption": {
                    "cmk": {
                        "kekIdentity": {
                            "useSystemAssignedIdentity": False,
                            "userAssignedIdentity": "/subscriptions/b64d7b94-73e7-4d36-94b2-7764ea3fd74a/resourcegroups/SynapseCI/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uami1",
                        },
                        "key": {"keyVaultUrl": "https://vault.azure.net/keys/key1", "name": "default"},
                    }
                },
                "managedResourceGroupName": "workspaceManagedResourceGroupUnique",
                "managedVirtualNetwork": "default",
                "managedVirtualNetworkSettings": {
                    "allowedAadTenantIdsForLinking": ["740239CE-A25B-485B-86A0-262F29F6EBDB"],
                    "linkedAccessCheckOnTargetResource": False,
                    "preventDataExfiltration": False,
                },
                "publicNetworkAccess": "Enabled",
                "purviewConfiguration": {
                    "purviewResourceId": "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup1/providers/Microsoft.ProjectPurview/accounts/accountname1"
                },
                "sqlAdministratorLogin": "login",
                "sqlAdministratorLoginPassword": "password",
                "workspaceRepositoryConfiguration": {
                    "accountName": "mygithubaccount",
                    "collaborationBranch": "master",
                    "hostName": "",
                    "projectName": "myproject",
                    "repositoryName": "myrepository",
                    "rootFolder": "/",
                    "type": "FactoryGitHubConfiguration",
                },
            },
            "tags": {"key": "value"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateOrUpdateWorkspace.json
if __name__ == "__main__":
    main()
