#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util::GMP qw/Euler/;
my $Euler = '0.577215664901532860606512090082402431042159335939923598805767234884867726777664670936947063291746749514631447249807082480960504014486542836224173997644923536253500333742937337737673942792595258247094916008735203948165670853233151776611528621199501507984793745085705740029921354786146694029604325421519058775535267331399254012967420513754139549111685102807984234877587205038431093997361372553060889331267600172479537836759271351577226102734929139407984301034177717780881549570661075010161916633401522789358679654972520362128792265559536696281763887927268013243101047650596370394739495763890657296792960100901512519595092224350140934987122824794974719564697631850667612906381105182419744486783638086174945516989279230187739107294578155431600500218284409605377243420328547836701517739439870030237033951832869000155819398804270741154222781971652301107356583396734871765049194181230004065469314299929777956930310050308630341856980323108369164002589297089098548682577736428825395492587362959613329857473930237343884707037028441292016641785';


plan tests => 2;

is_deeply( [map { Euler($_) } 0 .. 99],
           [map { constround($Euler,$_) } 0 .. 99],
           "Euler(0 .. 99)" );
is_deeply( [map { Euler(100*$_) } 1..10],
           [map { constround($Euler,100*$_) } 1..10],
           "Euler(100,200,300,...,1000)" );

# Call in void context
Euler(24);
Euler(1100);

sub constround {
  my($fullc,$dig) = @_;
  $fullc =~ /^(\d+)\.(\d+)$/ or die "const fail";
  my($int,$float) = ($1,$2);
  if ($dig == 0) {
    $int++ if substr($float,0,3) >= 500;
    return $int;
  }
  my $roundlen = ($dig > 10) ? 8 : 3;
  my $fc = substr($float,0,$dig);
  substr($fc,-$roundlen,$roundlen)++ if substr($float,$dig,1) >= 5;
  "$int.$fc";
}
