package Daje::Document::Templates::Tools::Generate::SQL;
use Mojo::Base 'Daje::Document::Templates::Base', -base;
use v5.42;

# NAME
# ====
#
# Daje::Templates::Tools::Generate::SQL; - It creates perl code
#
# SYNOPSIS
# ========
#
#     use Daje::Templates::Tools::Generate::SQL;
#
#     Provides a method for the template to be loaded into the data structure
#
#     sub length_default_calc($self) returns a sub for setting details in template.
#
#
# DESCRIPTION
# ===========
#
# Daje::Templates::Tools::Generate::SQL; is a module that retrieves data from a View
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

sub set_subs($self) {
    $self->subs(('length_default_calc'));
}


sub length_default_calc($self) {
    return sub {
        my $length = $_[0];
        my $scale = $_[1];
        my $notnull = $_[2];
        my $default = $_[3];
        my $unique = $_[4];
        my $result = "";
        if ($length > 0 and $scale > 0) {
            $result = "($length, $scale)";
        }
        elsif ($length > 0 and $scale == 0) {
            $result = "($length)";
        }
        if($unique == 1) {
            $result .= " UNIQUE ";
        }
        if ($notnull == 1) {
            $result .= " NOT NULL ";
            $result .= "DEFAULT $default " if (defined $default and length($default) > 0);
        }

        return $result;
    };
}
1;

__DATA__

@@ sql

use [% name_space %]
use Mojo::Base -base
use v5.42;

[% data_sectioner %]

-- Autogenerated file, any changes to this file will be over written.
-- Last generated [% date_time %]

[% FOREACH version IN versions %]
-- up [% version.version %]
    [% FOREACH table IN version.tables %]
CREATE TABLE IF NOT EXISTS [% project_name %]_[% table.table_name %]
(
    [% project_name %]_[% table.table_name %]_pkey  SERIAL NOT NULL,
    editnum bigint NOT NULL DEFAULT 1,
    insby character varying COLLATE pg_catalog."default" NOT NULL DEFAULT 'System'::character varying,
    insdatetime timestamp without time zone NOT NULL DEFAULT now(),
    modby character varying COLLATE pg_catalog."default" NOT NULL DEFAULT 'System'::character varying,
    moddatetime timestamp without time zone NOT NULL DEFAULT now(),
    [% FOREACH field IN table.fields -%]
        [% IF field.foreign_key -%]
        [%- project_name %]_[% field.fieldname %]_fkey BIGINT NOT NULL,
        [% ELSE -%]
    [% field.fieldname %]  [% field.datatype %] [% length_default_calc(field.length, field.scale, field.notnull, field.default, field.unique) %],
        [% END -%]
    [% END -%]
    CONSTRAINT [% project_name %]_[% table.table_name %]_pkey PRIMARY KEY ([% project_name %]_[% table.table_name %]_pkey)
);
    [% END -%]
  [% FOREACH table IN version.tables -%]
  [% FOREACH field IN table.fields -%]
  [% IF field.foreign_key -%]
    ALTER TABLE [% project_name %]_[% table.table_name %]
        ADD CONSTRAINT [% project_name %]_[% table.table_name %]_[% project_name %]_[% field.fieldname %]_fkey
    FOREIGN KEY ([% project_name %]_[% field.fieldname -%]_fkey)
        REFERENCES [% project_name %]_[% field.fieldname -%] ([% project_name %]_[% field.fieldname -%]_pkey);

    CREATE INDEX ind_[% project_name %]_[% table.table_name %]_[% field.fieldname %]_fkey
        ON [% project_name %]_[% table.table_name %]([%- project_name %]_[% field.fieldname %]_fkey);
  [% END -%]
  [% END -%]
  [% END -%]

-- down [% version.version %]

[% END %]

@@ end_datasections

#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Templates::Tools::Generate::SQL; - It creates perl code



=head1 SYNOPSIS


    use Daje::Templates::Tools::Generate::SQL;

    Provides a method for the template to be loaded into the data structure

    sub length_default_calc($self) returns a sub for setting details in template.




=head1 DESCRIPTION


Daje::Templates::Tools::Generate::SQL; is a module that retrieves data from a View



=head1 REQUIRES

L<v5.42> 

L<Mojo::Base> 


=head1 METHODS

=head2 length_default_calc($self)

 length_default_calc($self)();

=head2 set_subs($self)

 set_subs($self)();

NAME
====

Daje::Templates::Tools::Generate::SQL; - It creates perl code

SYNOPSIS
========

    use Daje::Templates::Tools::Generate::SQL;

    Provides a method for the template to be loaded into the data structure

    sub length_default_calc($self) returns a sub for setting details in template.


DESCRIPTION
===========

Daje::Templates::Tools::Generate::SQL; is a module that retrieves data from a View

LICENSE
=======

Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

AUTHOR
======

janeskil1525 E<lt>janeskil1525@gmail.comE<gt>




=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

