#!/usr/bin/perl

use strict;
use warnings;

use Test::Deep;
use Test::More;
use Test::NoWarnings;

use FusionInventory::Agent::Tools::License;

my %adobe_tests = (
    'sample1' => [
        {
            KEY        => '0054-9254-6385-5325-8335',
            NAME       => 'InCopy-CS5.5-Mac-GM',
            COMPONENTS => 'InCopy-CS5.5-Mac-GM',
            FULLNAME   => 'Adobe InCopy CS5.5'
        },
        {
            KEY        => '0054-9254-6813-4374-8223',
            NAME       => 'DesignSuitePremium-CS5.5-Mac-GM',
            COMPONENTS => 'Photoshop-CS5.5-Mac-GM/AcrobatPro-AS1-Mac-GM/Dreamweaver-CS5.5-Mac-GM/Fireworks-CS5.5-Mac-GM/FlashCatalyst-CS5.5-Mac-GM/FlashPro-CS5.5-Mac-GM/Illustrator-CS5.5-Mac-GM/InDesign-CS5.5-Mac-GM',
            FULLNAME   => 'Creative Suite 5.5 Design Premium'
        }
    ]
);

my @microsoft_tests = (
    [
        'a4,00,00,00,03,00,00,00,35,35,30,34,31,2d,30,32,39,2d,30,30,34,37,38,39,37,2d,38,36,36,32,34,00,ac,00,00,00,58,31,35,2d,33,39,30,38,31,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,39,69,0a,52,80,bd,80,2c,03,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,5d,8a,cd,c9',
        undef,
        'win7 serial key decoding'
    ],
    [
        'a4,00,00,00,03,00,00,00,30,30,31,38,30,2d,31,30,35,33,39,2d,35,32,38,34,30,2d,41,41,4f,45,4d,00,09,07,00,00,58,31,38,2d,31,35,35,38,30,00,00,00,00,00,00,00,09,07,80,14,74,33,14,aa,32,e4,d5,11,25,15,08,00,00,00,00,00,3a,05,bb,51,2f,01,29,97,02,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,b6,7d,17,ed',
        'NK2HF-3VG6G-X3YMF-JFT99-HCBRC',
        'win8 serial key decoding'
    ],
    [
        'a4,00,00,00,03,00,00,00,30,30,32,36,31,2d,38,30,34,36,33,2d,32,30,38,38,34,2d,41,41,33,35,38,00,3a,0a,00,00,5b,42,6c,75,65,5d,58,31,38,2d,39,35,35,31,36,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,f8,e6,ca,52,a6,a5,4c,b9,03,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,cb,b3,69,a1',
        undef,
        'win8 serial key decoding'
    ],
    [
        'f8,04,00,00,04,00,00,00,30,00,36,00,34,00,30,00,31,00,2d,00,30,00,32,00,36,00,31,00,38,00,2d,00,30,00,34,00,36,00,2d,00,33,00,32,00,30,00,38,00,38,00,34,00,2e,00,30,00,33,00,2d,00,31,00,30,00,33,00,36,00,2d,00,39,00,36,00,30,00,30,00,2e,00,30,00,30,00,30,00,30,00,2d,00,30,00,30,00,36,00,32,00,30,00,31,00,34,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,33,00,35,00,34,00,64,00,39,00,36,00,34,00,61,00,2d,00,35,00,36,00,65,00,37,00,2d,00,34,00,33,00,63,00,35,00,2d,00,61,00,39,00,33,00,66,00,2d,00,32,00,38,00,37,00,61,00,37,00,61,00,37,00,35,00,30,00,62,00,64,00,34,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,df,e3,2b,a1,21,d5,2a,38,b0,1b,c2,01,5e,00,99,b3,3a,8d,89,20,b7,d6,a4,90,f4,1b,1a,21,ab,63,e7,cd,c6,c3,58,15,ae,4d,33,89,2e,36,12,84,30,1c,a3,7a,98,36,bd,f5,0c,62,b0,a0,fe,d4,c3,47,ef,00,40,ee,5b,00,42,00,6c,00,75,00,65,00,5d,00,58,00,31,00,38,00,2d,00,39,00,35,00,35,00,31,00,36,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,56,00,6f,00,6c,00,75,00,6d,00,65,00,3a,00,4d,00,41,00,4b,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,56,00,6f,00,6c,00,75,00,6d,00,65,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00',
        '3HRDM-FF2YK-CFWJT-2DKXF-WD9GW',
        'win8 serial key decoding'
    ]
);

plan tests =>
    (scalar keys %adobe_tests) +
    (scalar @microsoft_tests) +
    1;

foreach my $test (keys %adobe_tests) {
    my $file = "resources/generic/license/adobe/cache.db-$test";
    my @licenses = getAdobeLicenses(file => $file);
    cmp_deeply(
        [ sort { compare() } @licenses ],
        [ sort { compare() } @{$adobe_tests{$test}} ],
        $test
    );
}

foreach my $test (@microsoft_tests) {
    is(decodeMicrosoftKey(binary($test->[0])), $test->[1], $test->[2]);
}

sub compare {
    return
        $a->{KEY} cmp $b->{KEY};
}

sub binary {
    my ($string) = @_;
    return pack("C*", map { hex($_) } split (/,/, $string));
}

1;
