/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.protocol.data;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;

public class DataUrlDecoder {
    private static final String DEFAULT_CHARSET = "US-ASCII";
    private static final String DEFAULT_MEDIA_TYPE = "text/plain";
    private final String mediaType_;
    private final String charset_;
    private byte[] content_;

    protected DataUrlDecoder(byte[] data, String mediaType, String charset) {
        this.content_ = data;
        this.mediaType_ = mediaType;
        this.charset_ = charset;
    }

    public static DataUrlDecoder decode(URL url) throws UnsupportedEncodingException, DecoderException {
        return DataUrlDecoder.decodeDataURL(url.toExternalForm());
    }

    public static DataUrlDecoder decodeDataURL(String url) throws UnsupportedEncodingException, DecoderException {
        if (!url.startsWith("data")) {
            throw new IllegalArgumentException("Not a data url: " + url);
        }
        int comma = url.indexOf(44);
        String beforeData = url.substring("data:".length(), comma);
        String mediaType = DataUrlDecoder.extractMediaType(beforeData);
        String charset = DataUrlDecoder.extractCharset(beforeData);
        boolean base64 = beforeData.endsWith(";base64");
        byte[] data = url.substring(comma + 1).getBytes(charset);
        data = base64 ? Base64.decodeBase64((byte[])URLCodec.decodeUrl((byte[])data)) : URLCodec.decodeUrl((byte[])data);
        return new DataUrlDecoder(data, mediaType, charset);
    }

    private static String extractCharset(String beforeData) {
        return DEFAULT_CHARSET;
    }

    private static String extractMediaType(String beforeData) {
        if (beforeData.contains("/")) {
            if (beforeData.contains(";")) {
                return StringUtils.substringBefore((String)beforeData, (String)";");
            }
            return beforeData;
        }
        return DEFAULT_MEDIA_TYPE;
    }

    public String getMediaType() {
        return this.mediaType_;
    }

    public String getCharset() {
        return this.charset_;
    }

    public byte[] getBytes() {
        return this.content_;
    }

    public String getDataAsString() throws UnsupportedEncodingException {
        return new String(this.content_, this.charset_);
    }
}

