/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":[],"extends":null,"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/Ext-more.html#Ext' target='_blank'>Ext-more.js</a></div><div class='dependency'><a href='source/Ext.html#Ext' target='_blank'>Ext.js</a></div></pre><div class='doc-contents'><p>Ext core utilities and functions.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-BLANK_IMAGE_URL' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-property-BLANK_IMAGE_URL' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-BLANK_IMAGE_URL' class='name expandable'>BLANK_IMAGE_URL</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>URL to a 1x1 transparent gif image used by Ext to create inline icons with CSS background images. ...</div><div class='long'><p>URL to a 1x1 transparent gif image used by Ext to create inline icons with CSS background images.\nIn older versions of IE, this defaults to \"http://extjs.com/s.gif\" and you should change this to a URL on your server.\nFor other browsers it uses an inline data URL.</p>\n</div></div></div><div id='property-SSL_SECURE_URL' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-SSL_SECURE_URL' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-SSL_SECURE_URL' class='name expandable'>SSL_SECURE_URL</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>URL to a blank file used by Ext when in secure mode for iframe src and onReady src to prevent\nthe IE insecure content...</div><div class='long'><p>URL to a blank file used by Ext when in secure mode for iframe src and onReady src to prevent\nthe IE insecure content warning (<tt>'about:blank'</tt>, except for IE in secure mode, which is <tt>'javascript:\"\"'</tt>).</p>\n</div></div></div><div id='property-USE_NATIVE_JSON' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-USE_NATIVE_JSON' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-USE_NATIVE_JSON' class='name expandable'>USE_NATIVE_JSON</a><span> : Boolean</span></div><div class='description'><div class='short'>Indicates whether to use native browser parsing for JSON methods. ...</div><div class='long'><p>Indicates whether to use native browser parsing for JSON methods.\nThis option is ignored if the browser does not support native JSON methods.\n<b>Note: Native JSON methods will not work with objects that have functions.\nAlso, property names must be quoted, otherwise the data will not parse.</b> (Defaults to false)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-emptyFn' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-property-emptyFn' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-emptyFn' class='name not-expandable'>emptyFn</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'><p>A reusable empty function</p>\n</div><div class='long'><p>A reusable empty function</p>\n</div></div></div><div id='property-enableForcedBoxModel' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-enableForcedBoxModel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-enableForcedBoxModel' class='name expandable'>enableForcedBoxModel</a><span> : Boolean</span></div><div class='description'><div class='short'>HIGHLY EXPERIMENTAL\nTrue to force css based border-box model override and turning off javascript based adjustments. ...</div><div class='long'><p>HIGHLY EXPERIMENTAL\nTrue to force css based border-box model override and turning off javascript based adjustments. This is a\nruntime configuration and must be set before onReady.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-enableFx' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-enableFx' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-enableFx' class='name not-expandable'>enableFx</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the <a href=\"#!/api/Ext.Fx\" rel=\"Ext.Fx\" class=\"docClass\">Ext.Fx</a> Class is available</p>\n</div><div class='long'><p>True if the <a href=\"#!/api/Ext.Fx\" rel=\"Ext.Fx\" class=\"docClass\">Ext.Fx</a> Class is available</p>\n</div></div></div><div id='property-enableGarbageCollector' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-enableGarbageCollector' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-enableGarbageCollector' class='name expandable'>enableGarbageCollector</a><span> : Boolean</span></div><div class='description'><div class='short'>True to automatically uncache orphaned Ext.Elements periodically (defaults to true) ...</div><div class='long'><p>True to automatically uncache orphaned Ext.Elements periodically (defaults to true)</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-enableListenerCollection' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-enableListenerCollection' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-enableListenerCollection' class='name expandable'>enableListenerCollection</a><span> : Boolean</span></div><div class='description'><div class='short'>True to automatically purge event listeners during garbageCollection (defaults to false). ...</div><div class='long'><p>True to automatically purge event listeners during garbageCollection (defaults to false).</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-enableNestedListenerRemoval' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-enableNestedListenerRemoval' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-enableNestedListenerRemoval' class='name expandable'>enableNestedListenerRemoval</a><span> : Boolean</span></div><div class='description'><div class='short'>EXPERIMENTAL - True to cascade listener removal to child elements when an element is removed. ...</div><div class='long'><p>EXPERIMENTAL - True to cascade listener removal to child elements when an element is removed.\nCurrently not optimized for performance.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-isAir' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isAir' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isAir' class='name not-expandable'>isAir</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected platform is Adobe Air.</p>\n</div><div class='long'><p>True if the detected platform is Adobe Air.</p>\n</div></div></div><div id='property-isBorderBox' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isBorderBox' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isBorderBox' class='name not-expandable'>isBorderBox</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser is Internet Explorer running in non-strict mode.</p>\n</div><div class='long'><p>True if the detected browser is Internet Explorer running in non-strict mode.</p>\n</div></div></div><div id='property-isChrome' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isChrome' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isChrome' class='name not-expandable'>isChrome</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser is Chrome.</p>\n</div><div class='long'><p>True if the detected browser is Chrome.</p>\n</div></div></div><div id='property-isGecko' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isGecko' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isGecko' class='name expandable'>isGecko</a><span> : Boolean</span></div><div class='description'><div class='short'>True if the detected browser uses the Gecko layout engine (e.g. ...</div><div class='long'><p>True if the detected browser uses the Gecko layout engine (e.g. Mozilla, Firefox).</p>\n</div></div></div><div id='property-isGecko2' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isGecko2' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isGecko2' class='name expandable'>isGecko2</a><span> : Boolean</span></div><div class='description'><div class='short'>True if the detected browser uses a pre-Gecko 1.9 layout engine (e.g. ...</div><div class='long'><p>True if the detected browser uses a pre-Gecko 1.9 layout engine (e.g. Firefox 2.x).</p>\n</div></div></div><div id='property-isGecko3' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isGecko3' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isGecko3' class='name expandable'>isGecko3</a><span> : Boolean</span></div><div class='description'><div class='short'>True if the detected browser uses a Gecko 1.9+ layout engine (e.g. ...</div><div class='long'><p>True if the detected browser uses a Gecko 1.9+ layout engine (e.g. Firefox 3.x).</p>\n</div></div></div><div id='property-isIE' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isIE' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isIE' class='name not-expandable'>isIE</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser is Internet Explorer.</p>\n</div><div class='long'><p>True if the detected browser is Internet Explorer.</p>\n</div></div></div><div id='property-isIE10' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isIE10' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isIE10' class='name not-expandable'>isIE10</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser is Internet Explorer 10.x</p>\n</div><div class='long'><p>True if the detected browser is Internet Explorer 10.x</p>\n</div></div></div><div id='property-isIE10p' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isIE10p' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isIE10p' class='name not-expandable'>isIE10p</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser is Internet Explorer 10.x or higher</p>\n</div><div class='long'><p>True if the detected browser is Internet Explorer 10.x or higher</p>\n</div></div></div><div id='property-isIE6' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isIE6' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isIE6' class='name not-expandable'>isIE6</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser is Internet Explorer 6.x.</p>\n</div><div class='long'><p>True if the detected browser is Internet Explorer 6.x.</p>\n</div></div></div><div id='property-isIE7' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isIE7' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isIE7' class='name not-expandable'>isIE7</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser is Internet Explorer 7.x.</p>\n</div><div class='long'><p>True if the detected browser is Internet Explorer 7.x.</p>\n</div></div></div><div id='property-isIE8' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isIE8' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isIE8' class='name not-expandable'>isIE8</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser is Internet Explorer 8.x.</p>\n</div><div class='long'><p>True if the detected browser is Internet Explorer 8.x.</p>\n</div></div></div><div id='property-isIE9' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isIE9' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isIE9' class='name not-expandable'>isIE9</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser is Internet Explorer 9.x.</p>\n</div><div class='long'><p>True if the detected browser is Internet Explorer 9.x.</p>\n</div></div></div><div id='property-isIE9m' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isIE9m' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isIE9m' class='name not-expandable'>isIE9m</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser is Internet Explorer 9.x or lower</p>\n</div><div class='long'><p>True if the detected browser is Internet Explorer 9.x or lower</p>\n</div></div></div><div id='property-isLinux' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isLinux' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isLinux' class='name not-expandable'>isLinux</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected platform is Linux.</p>\n</div><div class='long'><p>True if the detected platform is Linux.</p>\n</div></div></div><div id='property-isMac' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isMac' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isMac' class='name not-expandable'>isMac</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected platform is Mac OS.</p>\n</div><div class='long'><p>True if the detected platform is Mac OS.</p>\n</div></div></div><div id='property-isOpera' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isOpera' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isOpera' class='name not-expandable'>isOpera</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser is Opera.</p>\n</div><div class='long'><p>True if the detected browser is Opera.</p>\n</div></div></div><div id='property-isReady' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isReady' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isReady' class='name expandable'>isReady</a><span> : Boolean</span></div><div class='description'><div class='short'>True when the document is fully initialized and ready for action ...</div><div class='long'><p>True when the document is fully initialized and ready for action</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-isSafari' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isSafari' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isSafari' class='name not-expandable'>isSafari</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser is Safari.</p>\n</div><div class='long'><p>True if the detected browser is Safari.</p>\n</div></div></div><div id='property-isSafari2' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isSafari2' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isSafari2' class='name not-expandable'>isSafari2</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser is Safari 2.x.</p>\n</div><div class='long'><p>True if the detected browser is Safari 2.x.</p>\n</div></div></div><div id='property-isSafari3' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isSafari3' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isSafari3' class='name not-expandable'>isSafari3</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser is Safari 3.x.</p>\n</div><div class='long'><p>True if the detected browser is Safari 3.x.</p>\n</div></div></div><div id='property-isSafari4' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isSafari4' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isSafari4' class='name not-expandable'>isSafari4</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser is Safari 4.x.</p>\n</div><div class='long'><p>True if the detected browser is Safari 4.x.</p>\n</div></div></div><div id='property-isSecure' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isSecure' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isSecure' class='name not-expandable'>isSecure</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the page is running over SSL</p>\n</div><div class='long'><p>True if the page is running over SSL</p>\n</div></div></div><div id='property-isStrict' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isStrict' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isStrict' class='name not-expandable'>isStrict</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the browser is in strict (standards-compliant) mode, as opposed to quirks mode</p>\n</div><div class='long'><p>True if the browser is in strict (standards-compliant) mode, as opposed to quirks mode</p>\n</div></div></div><div id='property-isWebKit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isWebKit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isWebKit' class='name not-expandable'>isWebKit</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected browser uses WebKit.</p>\n</div><div class='long'><p>True if the detected browser uses WebKit.</p>\n</div></div></div><div id='property-isWindows' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-isWindows' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-isWindows' class='name not-expandable'>isWindows</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True if the detected platform is Windows.</p>\n</div><div class='long'><p>True if the detected platform is Windows.</p>\n</div></div></div><div id='property-useShims' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-property-useShims' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-useShims' class='name expandable'>useShims</a><span> : Boolean</span></div><div class='description'><div class='short'>By default, Ext intelligently decides whether floating elements should be shimmed. ...</div><div class='long'><p>By default, Ext intelligently decides whether floating elements should be shimmed. If you are using flash,\nyou may want to set this to true.</p>\n</div></div></div><div id='property-ux' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-property-ux' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-ux' class='name not-expandable'>ux</a><span> : Object</span></div><div class='description'><div class='short'><p>Namespace alloted for extensions to the framework.</p>\n</div><div class='long'><p>Namespace alloted for extensions to the framework.</p>\n</div></div></div><div id='property-version' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-version' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-version' class='name expandable'>version</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The version of the framework ...</div><div class='long'><p>The version of the framework</p>\n<p>Defaults to: <code>'3.4.1.1'</code></p></div></div></div><div id='property-versionDetail' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-property-versionDetail' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-property-versionDetail' class='name expandable'>versionDetail</a><span> : Object</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{major: 3, minor: 4, patch: 1.1}</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-addBehaviors' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-addBehaviors' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-addBehaviors' class='name expandable'>addBehaviors</a>( <span class='pre'>obj</span> )</div><div class='description'><div class='short'>Applies event listeners to elements by selectors when the document is ready. ...</div><div class='long'><p>Applies event listeners to elements by selectors when the document is ready.\nThe event name is specified with an <tt>&#64;</tt> suffix.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-addBehaviors\" rel=\"Ext-method-addBehaviors\" class=\"docClass\">Ext.addBehaviors</a>({\n    // add a listener for click on all anchors in element with id foo\n    '#foo a&#64;click' : function(e, t){\n        // do something\n    },\n\n    // add the same listener to multiple selectors (separated by comma BEFORE the &#64;)\n    '#foo a, #bar span.some-class&#64;mouseover' : function(){\n        // do something\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>obj</span> : Object<div class='sub-desc'><p>The list of behaviors to apply</p>\n</div></li></ul></div></div></div><div id='method-apply' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-apply' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-apply' class='name expandable'>apply</a>( <span class='pre'>obj, config, defaults</span> ) : Object</div><div class='description'><div class='short'>Copies all the properties of config to obj. ...</div><div class='long'><p>Copies all the properties of config to obj. apply</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>obj</span> : Object<div class='sub-desc'><p>The receiver of the properties</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>The source of the properties</p>\n</div></li><li><span class='pre'>defaults</span> : Object<div class='sub-desc'><p>A different object that will also be applied for default values</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>returns obj</p>\n</div></li></ul></div></div></div><div id='method-applyIf' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-applyIf' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-applyIf' class='name expandable'>applyIf</a>( <span class='pre'>obj, config</span> ) : Object</div><div class='description'><div class='short'>Copies all the properties of config to obj if they don't already exist. ...</div><div class='long'><p>Copies all the properties of config to obj if they don't already exist.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>obj</span> : Object<div class='sub-desc'><p>The receiver of the properties</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>The source of the properties</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>returns obj</p>\n</div></li></ul></div></div></div><div id='method-clean' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-clean' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-clean' class='name expandable'>clean</a>( <span class='pre'>arr</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Creates a copy of the passed Array with falsy values removed. ...</div><div class='long'><p>Creates a copy of the passed Array with falsy values removed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList<div class='sub-desc'><p>The Array from which to remove falsy values.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The new, compressed Array.</p>\n</div></li></ul></div></div></div><div id='method-copyTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-copyTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-copyTo' class='name expandable'>copyTo</a>( <span class='pre'>dest, source, names</span> ) : Object</div><div class='description'><div class='short'>Copies a set of named properties fom the source object to the destination object. ...</div><div class='long'><p>Copies a set of named properties fom the source object to the destination object.</p>\n\n<p>example:\n<pre><code>ImageComponent = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(<a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a>, {\n    initComponent: function() {\n        this.autoEl = { tag: 'img' };\n        MyComponent.superclass.initComponent.apply(this, arguments);\n        this.initialBox = <a href=\"#!/api/Ext-method-copyTo\" rel=\"Ext-method-copyTo\" class=\"docClass\">Ext.copyTo</a>({}, this.initialConfig, 'x,y,width,height');\n    }\n});\n</code></pre>\n\n</p><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>dest</span> : Object<div class='sub-desc'><p>The destination object.</p>\n</div></li><li><span class='pre'>source</span> : Object<div class='sub-desc'><p>The source object.</p>\n</div></li><li><span class='pre'>names</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an Array of property names, or a comma-delimited list\nof property names to copy.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The modified object.</p>\n</div></li></ul></div></div></div><div id='method-create' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/ComponentMgr.html#Ext-method-create' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-create' class='name expandable'>create</a>( <span class='pre'>config, defaultType</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Shorthand for Ext.ComponentMgr.create\nCreates a new Component from the specified config object using the\nconfig objec...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.ComponentMgr-method-create\" rel=\"Ext.ComponentMgr-method-create\" class=\"docClass\">Ext.ComponentMgr.create</a>\nCreates a new Component from the specified config object using the\nconfig object's xtype to determine the class to instantiate.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>A configuration object for the Component you wish to create.</p>\n</div></li><li><span class='pre'>defaultType</span> : Constructor<div class='sub-desc'><p>The constructor to provide the default Component type if\nthe config object does not contain a <code>xtype</code>. (Optional if the config contains a <code>xtype</code>).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>The newly instantiated Component.</p>\n</div></li></ul></div></div></div><div id='method-createDelegate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Function.html#Ext-method-createDelegate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-createDelegate' class='name expandable'>createDelegate</a>( <span class='pre'>fn, [scope], [args], [appendArgs]</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></div><div class='description'><div class='short'>Shorthand for Ext.util.Functions.createDelegate ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.util.Functions-method-createDelegate\" rel=\"Ext.util.Functions-method-createDelegate\" class=\"docClass\">Ext.util.Functions.createDelegate</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to delegate.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the function is executed.\n<b>If omitted, defaults to the browser window.</b></p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>Overrides arguments for the call. (Defaults to the arguments passed by the caller)</p>\n</div></li><li><span class='pre'>appendArgs</span> : Boolean/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>if True args are appended to call args instead of overriding,\nif a number the args are inserted at the specified position</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>The new function</p>\n</div></li></ul></div></div></div><div id='method-createInterceptor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Function.html#Ext-method-createInterceptor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-createInterceptor' class='name expandable'>createInterceptor</a>( <span class='pre'>origFn, newFn, [scope]</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></div><div class='description'><div class='short'>Shorthand for Ext.util.Functions.createInterceptor ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.util.Functions-method-createInterceptor\" rel=\"Ext.util.Functions-method-createInterceptor\" class=\"docClass\">Ext.util.Functions.createInterceptor</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>origFn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The original function.</p>\n</div></li><li><span class='pre'>newFn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call before the original</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the passed function is executed.\n<b>If omitted, defaults to the scope in which the original function is called or the browser window.</b></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>The new function</p>\n</div></li></ul></div></div></div><div id='method-createSequence' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Function.html#Ext-method-createSequence' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-createSequence' class='name expandable'>createSequence</a>( <span class='pre'>origFn, newFn, [scope]</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></div><div class='description'><div class='short'>Shorthand for Ext.util.Functions.createSequence ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.util.Functions-method-createSequence\" rel=\"Ext.util.Functions-method-createSequence\" class=\"docClass\">Ext.util.Functions.createSequence</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>origFn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The original function.</p>\n</div></li><li><span class='pre'>newFn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to sequence</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (this reference) in which the passed function is executed.\nIf omitted, defaults to the scope in which the original function is called or the browser window.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>The new function</p>\n</div></li></ul></div></div></div><div id='method-decode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/JSON.html#Ext-method-decode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-decode' class='name expandable'>decode</a>( <span class='pre'>json, [safe]</span> ) : Object</div><div class='description'><div class='short'>Shorthand for Ext.util.JSON.decode ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.util.JSON-method-decode\" rel=\"Ext.util.JSON-method-decode\" class=\"docClass\">Ext.util.JSON.decode</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>json</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The JSON string</p>\n</div></li><li><span class='pre'>safe</span> : Boolean (optional)<div class='sub-desc'><p>Whether to return null or throw an exception if the JSON is invalid.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The resulting object</p>\n</div></li></ul></div></div></div><div id='method-defer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Function.html#Ext-method-defer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-defer' class='name expandable'>defer</a>( <span class='pre'>fn, millis, [scope], [args], [appendArgs]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Shorthand for Ext.util.Functions.defer ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.util.Functions-method-defer\" rel=\"Ext.util.Functions-method-defer\" class=\"docClass\">Ext.util.Functions.defer</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to defer.</p>\n</div></li><li><span class='pre'>millis</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The number of milliseconds for the setTimeout call (if less than or equal to 0 the function is executed immediately)</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the function is executed.\n<b>If omitted, defaults to the browser window.</b></p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>Overrides arguments for the call. (Defaults to the arguments passed by the caller)</p>\n</div></li><li><span class='pre'>appendArgs</span> : Boolean/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>if True args are appended to call args instead of overriding,\nif a number the args are inserted at the specified position</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The timeout id that can be used with clearTimeout</p>\n</div></li></ul></div></div></div><div id='method-define' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-define' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-define' class='name expandable'>define</a>( <span class='pre'>className, data, createdFn</span> ) : Ext.Base</div><div class='description'><div class='short'>Defines a class or override. ...</div><div class='long'><p>Defines a class or override. A basic class is defined like this:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.awesome.Class', {\n     someProperty: 'something',\n\n     someMethod: function(s) {\n         alert(s + this.someProperty);\n     }\n\n     ...\n });\n\n var obj = new My.awesome.Class();\n\n obj.someMethod('Say '); // alerts 'Say something'\n</code></pre>\n\n<p>To create an anonymous class, pass <code>null</code> for the <code>className</code>:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>(null, {\n     constructor: function () {\n         // ...\n     }\n });\n</code></pre>\n\n<p>In some cases, it is helpful to create a nested scope to contain some private\nproperties. The best way to do this is to pass a function instead of an object\nas the second parameter. This function will be called to produce the class\nbody:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.foo.Bar', function () {\n     var id = 0;\n\n     return {\n         nextId: function () {\n             return ++id;\n         }\n     };\n });\n</code></pre>\n\n<p>When using this form of <code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a></code>, the function is passed a reference to its\nclass. This can be used as an efficient way to access any static properties you\nmay have:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.foo.Bar', function (Bar) {\n     return {\n         statics: {\n             staticMethod: function () {\n                 // ...\n             }\n         },\n\n         method: function () {\n             return Bar.staticMethod();\n         }\n     };\n });\n</code></pre>\n\n<p>To define an override, include the <code>override</code> property. The content of an\noverride is aggregated with the specified class in order to extend or modify\nthat class. This can be as simple as setting default property values or it can\nextend and/or replace methods. This can also extend the statics of the class.</p>\n\n<p>One use for an override is to break a large class into manageable pieces.</p>\n\n<pre><code> // File: /src/app/Panel.js\n\n <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.app.Panel', {\n     extend: 'Ext.panel.Panel',\n\n     constructor: function (config) {\n         this.callParent(arguments); // calls Ext.panel.Panel's constructor\n         //...\n     },\n\n     statics: {\n         method: function () {\n             return 'abc';\n         }\n     }\n });\n\n // File: /src/app/PanelPart2.js\n <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.app.PanelPart2', {\n     override: 'My.app.Panel',\n\n     constructor: function (config) {\n         this.callParent(arguments); // calls My.app.Panel's constructor\n         //...\n     }\n });\n</code></pre>\n\n<p>Another use of overrides is to provide optional parts of classes that can be\nindependently required. In this case, the class may even be unaware of the\noverride altogether.</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.ux.CoolTip', {\n     override: 'Ext.tip.ToolTip',\n\n     constructor: function (config) {\n         this.callParent(arguments); // calls Ext.tip.ToolTip's constructor\n         //...\n     }\n });\n</code></pre>\n\n<p>Overrides can also contain statics:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.app.BarMod', {\n     override: 'Ext.foo.Bar',\n\n     statics: {\n         method: function (x) {\n             return this.callParent([x * 2]); // call Ext.foo.Bar.method\n         }\n     }\n });\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The class name to create in string dot-namespaced format, for example:\n'My.very.awesome.Class', 'FeedViewer.plugin.CoolPager'\nIt is highly recommended to follow this simple convention:\n - The root and the class name are 'CamelCased'\n - Everything else is lower-cased\nPass <code>null</code> to create an anonymous class.</p>\n</div></li><li><span class='pre'>data</span> : Object<div class='sub-desc'><p>The key - value pairs of properties to apply to this class. Property names can be of any valid\nstrings, except those in the reserved listed below:\n - <code>mixins</code>\n - <code>statics</code>\n - <code>config</code>\n - <code>alias</code>\n - <code>self</code>\n - <code>singleton</code>\n - <code>alternateClassName</code>\n - <code>override</code></p>\n</div></li><li><span class='pre'>createdFn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>Optional callback to execute after the class is created, the execution scope of which\n(<code>this</code>) will be the newly created class itself.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Ext.Base</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-destroy' class='name expandable'>destroy</a>( <span class='pre'>args</span> )</div><div class='description'><div class='short'>Attempts to destroy any objects passed to it by removing all event listeners, removing them from the\nDOM (if applicab...</div><div class='long'><p>Attempts to destroy any objects passed to it by removing all event listeners, removing them from the\nDOM (if applicable) and calling their destroy functions (if available).  This method is primarily\nintended for arguments of type <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> and <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>, but any subclass of\n<a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a> can be passed in.  Any number of elements and/or components can be\npassed into this function in a single call as separate arguments.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : Mixed...<div class='sub-desc'><p>An <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>, <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>, or an Array of either of these to destroy</p>\n</div></li></ul></div></div></div><div id='method-destroyMembers' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-destroyMembers' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-destroyMembers' class='name expandable'>destroyMembers</a>( <span class='pre'>o, arg1, etc</span> )</div><div class='description'><div class='short'>Attempts to destroy and then remove a set of named properties of the passed object. ...</div><div class='long'><p>Attempts to destroy and then remove a set of named properties of the passed object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The object (most likely a Component) who's properties you wish to destroy.</p>\n</div></li><li><span class='pre'>arg1</span> : Mixed<div class='sub-desc'><p>The name of the property to destroy and remove from the object.</p>\n</div></li><li><span class='pre'>etc</span> : Mixed<div class='sub-desc'><p>... More property names to destroy and remove.</p>\n</div></li></ul></div></div></div><div id='method-each' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-each' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-each' class='name expandable'>each</a>( <span class='pre'>array, fn, scope</span> ) : Object</div><div class='description'><div class='short'>Iterates an array calling the supplied function. ...</div><div class='long'><p>Iterates an array calling the supplied function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>array</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList/Mixed<div class='sub-desc'><p>The array to be iterated. If this\nargument is not really an array, the supplied function is called once.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to be called with each item. If the\nsupplied function returns false, iteration stops and this method returns\nthe current <code>index</code>. This function is called with\nthe following arguments:</p>\n\n<div class=\"mdetail-params\"><ul>\n<li><code>item</code> : <i>Mixed</i>\n<div class=\"sub-desc\">The item at the current <code>index</code>\nin the passed <code>array</code></div></li>\n<li><code>index</code> : <i>Number</i>\n<div class=\"sub-desc\">The current index within the array</div></li>\n<li><code>allItems</code> : <i>Array</i>\n<div class=\"sub-desc\">The <code>array</code> passed as the first\nargument to <code><a href=\"#!/api/Ext-method-each\" rel=\"Ext-method-each\" class=\"docClass\">Ext.each</a></code>.</div></li>\n</ul></div>\n\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the specified function is executed.\nDefaults to the <code>item</code> at the current <code>index</code>\nwithin the passed <code>array</code>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>See description for the fn parameter.</p>\n</div></li></ul></div></div></div><div id='method-encode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/JSON.html#Ext-method-encode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-encode' class='name expandable'>encode</a>( <span class='pre'>o</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Shorthand for Ext.util.JSON.encode ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.util.JSON-method-encode\" rel=\"Ext.util.JSON-method-encode\" class=\"docClass\">Ext.util.JSON.encode</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Mixed<div class='sub-desc'><p>The variable to encode</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The JSON string</p>\n</div></li></ul></div></div></div><div id='method-escapeRe' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-escapeRe' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-escapeRe' class='name expandable'>escapeRe</a>( <span class='pre'>str</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Escapes the passed string for use in a regular expression ...</div><div class='long'><p>Escapes the passed string for use in a regular expression</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-extend' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-extend' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-extend' class='name expandable'>extend</a>( <span class='pre'>superclass, overrides</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></div><div class='description'><div class='short'>Extends one class to create a subclass and optionally overrides members with the passed literal. ...</div><div class='long'><p>Extends one class to create a subclass and optionally overrides members with the passed literal. This method\nalso adds the function \"override()\" to the subclass that can be used to override members of the class.</p>\n\n\n<p>For example, to create a subclass of Ext GridPanel:</p>\n\n<pre><code>MyGridPanel = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(<a href=\"#!/api/Ext.grid.GridPanel\" rel=\"Ext.grid.GridPanel\" class=\"docClass\">Ext.grid.GridPanel</a>, {\n    constructor: function(config) {\n\n//      Create configuration for this Grid.\n        var store = new <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>({...});\n        var colModel = new <a href=\"#!/api/Ext.grid.ColumnModel\" rel=\"Ext.grid.ColumnModel\" class=\"docClass\">Ext.grid.ColumnModel</a>({...});\n\n//      Create a new config object containing our computed properties\n//      *plus* whatever was in the config parameter.\n        config = <a href=\"#!/api/Ext-method-apply\" rel=\"Ext-method-apply\" class=\"docClass\">Ext.apply</a>({\n            store: store,\n            colModel: colModel\n        }, config);\n\n        MyGridPanel.superclass.constructor.call(this, config);\n\n//      Your postprocessing here\n    },\n\n    yourMethod: function() {\n        // etc.\n    }\n});\n</code></pre>\n\n\n\n\n<p>This function also supports a 3-argument call in which the subclass's constructor is\npassed as an argument. In this form, the parameters are as follows:</p>\n\n\n<div class=\"mdetail-params\"><ul>\n<li><code>subclass</code> : Function <div class=\"sub-desc\">The subclass constructor.</div></li>\n<li><code>superclass</code> : Function <div class=\"sub-desc\">The constructor of class being extended</div></li>\n<li><code>overrides</code> : Object <div class=\"sub-desc\">A literal with members which are copied into the subclass's\nprototype, and are therefore shared among all instances of the new class.</div></li>\n</ul></div>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superclass</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The constructor of class being extended.</p>\n</div></li><li><span class='pre'>overrides</span> : Object<div class='sub-desc'><p>A literal with members which are copied into the subclass's\nprototype, and are therefore shared between all instances of the new class.</p>\n\n\n<p>This may contain a special member named <tt><b>constructor</b></tt>. This is used\nto define the constructor of the new class, and is returned. If this property is\n<i>not</i> specified, a constructor is generated and returned which just calls the\nsuperclass's constructor passing on its parameters.</p>\n\n\n<p><b>It is essential that you call the superclass constructor in any provided constructor. See example code.</b></p>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>The subclass constructor from the <code>overrides</code> parameter, or a generated one if not provided.</p>\n</div></li></ul></div></div></div><div id='method-flatten' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-flatten' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-flatten' class='name expandable'>flatten</a>( <span class='pre'>arr</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Recursively flattens into 1-d Array. ...</div><div class='long'><p>Recursively flattens into 1-d Array. Injects Arrays inline.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The array to flatten</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The new, flattened array.</p>\n</div></li></ul></div></div></div><div id='method-fly' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Element.html#Ext-method-fly' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-fly' class='name expandable'>fly</a>( <span class='pre'>el, [named]</span> ) : Element</div><div class='description'><div class='short'>Gets the globally shared flyweight Element, with the passed node as the active element. ...</div><div class='long'><p>Gets the globally shared flyweight Element, with the passed node as the active element. Do not store a reference to this element -\nthe dom node can be overwritten by other code. Shorthand of <a href=\"#!/api/Ext.Element-method-fly\" rel=\"Ext.Element-method-fly\" class=\"docClass\">Ext.Element.fly</a></p>\n\n\n<p>Use this to make one-time references to DOM elements which are not going to be accessed again either by\napplication code, or by Ext's classes. If accessing an element which will be processed regularly, then <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">get</a>\nwill be more appropriate to take advantage of the caching provided by the <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> class.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement<div class='sub-desc'><p>The dom node or id</p>\n</div></li><li><span class='pre'>named</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Allows for creation of named reusable flyweights to prevent conflicts\n(e.g. internally Ext uses \"_global\")</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Element</span><div class='sub-desc'><p>The shared Element object (or null if no matching element was found)</p>\n</div></li></ul></div></div></div><div id='method-get' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Element.html#Ext-method-get' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-get' class='name expandable'>get</a>( <span class='pre'>el</span> ) : Element</div><div class='description'><div class='short'>Retrieves Ext.Element objects. ...</div><div class='long'><p>Retrieves <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> objects.</p>\n\n<p><b>This method does not retrieve <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a>s.</b> This method\nretrieves <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> objects which encapsulate DOM elements. To retrieve a Component by\nits ID, use <a href=\"#!/api/Ext.ComponentMgr-method-get\" rel=\"Ext.ComponentMgr-method-get\" class=\"docClass\">Ext.ComponentMgr.get</a>.</p>\n\n\n<p>Uses simple caching to consistently return the same object. Automatically fixes if an\nobject was recreated with the same id via AJAX or DOM.</p>\n\n\n<p>Shorthand of <a href=\"#!/api/Ext.Element-static-method-get\" rel=\"Ext.Element-static-method-get\" class=\"docClass\">Ext.Element.get</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The id of the node, a DOM Node or an existing Element.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Element</span><div class='sub-desc'><p>The Element object (or null if no matching element was found)</p>\n</div></li></ul></div></div></div><div id='method-getBody' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-getBody' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-getBody' class='name expandable'>getBody</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns the current document body as an Ext.Element. ...</div><div class='long'><p>Returns the current document body as an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> The document body</p>\n</div></li></ul></div></div></div><div id='method-getCmp' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-getCmp' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-getCmp' class='name expandable'>getCmp</a>( <span class='pre'>id</span> ) : Object</div><div class='description'><div class='short'>This is shorthand reference to Ext.ComponentMgr.get. ...</div><div class='long'><p>This is shorthand reference to <a href=\"#!/api/Ext.ComponentMgr-method-get\" rel=\"Ext.ComponentMgr-method-get\" class=\"docClass\">Ext.ComponentMgr.get</a>.\nLooks up an existing <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a> by <a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The component <a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> The Component, <tt>undefined</tt> if not found, or <tt>null</tt> if a\nClass was found.</p>\n</div></li></ul></div></div></div><div id='method-getDoc' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-getDoc' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-getDoc' class='name expandable'>getDoc</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns the current HTML document object as an Ext.Element. ...</div><div class='long'><p>Returns the current HTML document object as an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> The document</p>\n</div></li></ul></div></div></div><div id='method-getDom' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-getDom' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-getDom' class='name expandable'>getDom</a>( <span class='pre'>el</span> ) : Object</div><div class='description'><div class='short'>Return the dom node for the passed String (id), dom node, or Ext.Element. ...</div><div class='long'><p>Return the dom node for the passed String (id), dom node, or <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>.\nOptional 'strict' flag is needed for IE since it can return 'name' and\n'id' elements by using getElementById.\nHere are some examples:</p>\n\n<pre><code>// gets dom node based on id\nvar elDom = <a href=\"#!/api/Ext-method-getDom\" rel=\"Ext-method-getDom\" class=\"docClass\">Ext.getDom</a>('elId');\n// gets dom node based on the dom node\nvar elDom1 = <a href=\"#!/api/Ext-method-getDom\" rel=\"Ext-method-getDom\" class=\"docClass\">Ext.getDom</a>(elDom);\n\n// If we don&#39;t know if we are working with an\n// <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> or a dom node use <a href=\"#!/api/Ext-method-getDom\" rel=\"Ext-method-getDom\" class=\"docClass\">Ext.getDom</a>\nfunction(el){\n    var dom = <a href=\"#!/api/Ext-method-getDom\" rel=\"Ext-method-getDom\" class=\"docClass\">Ext.getDom</a>(el);\n    // do something with the dom node\n}\n</code></pre>\n\n\n<p><b>Note</b>: the dom node to be found actually needs to exist (be rendered, etc)\nwhen this method is called to be successful.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>HTMLElement</p>\n</div></li></ul></div></div></div><div id='method-getHead' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-getHead' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-getHead' class='name expandable'>getHead</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns the current document body as an Ext.Element. ...</div><div class='long'><p>Returns the current document body as an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> The document body</p>\n</div></li></ul></div></div></div><div id='method-getScrollBarWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-getScrollBarWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-getScrollBarWidth' class='name expandable'>getScrollBarWidth</a>( <span class='pre'>[force]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Utility method for getting the width of the browser scrollbar. ...</div><div class='long'><p>Utility method for getting the width of the browser scrollbar. This can differ depending on\noperating system settings, such as the theme or font size.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>force</span> : Boolean (optional)<div class='sub-desc'><p>true to force a recalculation of the value.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The width of the scrollbar.</p>\n</div></li></ul></div></div></div><div id='method-handleError' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Error.html#Ext-method-handleError' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-handleError' class='name expandable'>handleError</a>( <span class='pre'>e</span> )</div><div class='description'><div class='short'>Framework-wide error-handler. ...</div><div class='long'><p>Framework-wide error-handler.  Developers can override this method to provide\ncustom exception-handling.  Framework errors will often extend from the base\n<a href=\"#!/api/Ext.Error\" rel=\"Ext.Error\" class=\"docClass\">Ext.Error</a> class.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object/Error<div class='sub-desc'><p>The thrown exception object.</p>\n</div></li></ul></div></div></div><div id='method-id' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-id' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-id' class='name expandable'>id</a>( <span class='pre'>[el], [prefix]</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Generates unique ids. ...</div><div class='long'><p>Generates unique ids. If the element already has an id, it is unchanged</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed (optional)<div class='sub-desc'><p>The element to generate an id for</p>\n</div></li><li><span class='pre'>prefix</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Id prefix (defaults \"ext-gen\")</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The generated Id.</p>\n</div></li></ul></div></div></div><div id='method-invoke' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-invoke' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-invoke' class='name expandable'>invoke</a>( <span class='pre'>arr, methodName, args</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Invokes a method on each item in an Array. ...</div><div class='long'><p>Invokes a method on each item in an Array.</p>\n\n<pre><code>// Example:\n<a href=\"#!/api/Ext-method-invoke\" rel=\"Ext-method-invoke\" class=\"docClass\">Ext.invoke</a>(<a href=\"#!/api/Ext-method-query\" rel=\"Ext-method-query\" class=\"docClass\">Ext.query</a>(\"p\"), \"getAttribute\", \"id\");\n// [el1.getAttribute(\"id\"), el2.getAttribute(\"id\"), ..., elN.getAttribute(\"id\")]\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>|NodeList<div class='sub-desc'><p>The Array of items to invoke the method on.</p>\n</div></li><li><span class='pre'>methodName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The method name to invoke.</p>\n</div></li><li><span class='pre'>args</span> : ...*<div class='sub-desc'><p>Arguments to send into the method invocation.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The results of invoking the method on each item in the array.</p>\n</div></li></ul></div></div></div><div id='method-isArray' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-isArray' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-isArray' class='name expandable'>isArray</a>( <span class='pre'>value</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the passed value is a JavaScript array, otherwise false. ...</div><div class='long'><p>Returns true if the passed value is a JavaScript array, otherwise false.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isBoolean' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-isBoolean' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-isBoolean' class='name expandable'>isBoolean</a>( <span class='pre'>value</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the passed value is a boolean. ...</div><div class='long'><p>Returns true if the passed value is a boolean.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-isDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-isDate' class='name expandable'>isDate</a>( <span class='pre'>object</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the passed object is a JavaScript date object, otherwise false. ...</div><div class='long'><p>Returns true if the passed object is a JavaScript date object, otherwise false.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : Object<div class='sub-desc'><p>The object to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isDefined' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-isDefined' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-isDefined' class='name expandable'>isDefined</a>( <span class='pre'>value</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the passed value is not undefined. ...</div><div class='long'><p>Returns true if the passed value is not undefined.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-isElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-isElement' class='name expandable'>isElement</a>( <span class='pre'>value</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the passed value is an HTMLElement ...</div><div class='long'><p>Returns true if the passed value is an HTMLElement</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isEmpty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-isEmpty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-isEmpty' class='name expandable'>isEmpty</a>( <span class='pre'>value, [allowBlank]</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the passed value is empty. ...</div><div class='long'><p>Returns true if the passed value is empty.</p>\n\n\n<p>The value is deemed to be empty if it is<div class=\"mdetail-params\"><ul>\n<li>null</li>\n<li>undefined</li>\n<li>an empty array</li>\n<li>a zero length string (Unless the <tt>allowBlank</tt> parameter is <tt>true</tt>)</li>\n</ul></div>\n\n</p><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to test</p>\n</div></li><li><span class='pre'>allowBlank</span> : Boolean (optional)<div class='sub-desc'><p>true to allow empty strings (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isFunction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-isFunction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-isFunction' class='name expandable'>isFunction</a>( <span class='pre'>value</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the passed value is a JavaScript Function, otherwise false. ...</div><div class='long'><p>Returns true if the passed value is a JavaScript Function, otherwise false.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isNumber' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-isNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-isNumber' class='name expandable'>isNumber</a>( <span class='pre'>value</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the passed value is a number. ...</div><div class='long'><p>Returns true if the passed value is a number. Returns false for non-finite numbers.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-isObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-isObject' class='name expandable'>isObject</a>( <span class='pre'>value</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the passed value is a JavaScript Object, otherwise false. ...</div><div class='long'><p>Returns true if the passed value is a JavaScript Object, otherwise false.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isPrimitive' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-isPrimitive' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-isPrimitive' class='name expandable'>isPrimitive</a>( <span class='pre'>value</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the passed value is a JavaScript 'primitive', a string, number or boolean. ...</div><div class='long'><p>Returns true if the passed value is a JavaScript 'primitive', a string, number or boolean.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-isString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-isString' class='name expandable'>isString</a>( <span class='pre'>value</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the passed value is a string. ...</div><div class='long'><p>Returns true if the passed value is a string.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-iterate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-iterate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-iterate' class='name expandable'>iterate</a>( <span class='pre'>object, fn, scope</span> )</div><div class='description'><div class='short'>Iterates either the elements in an array, or each of the properties in an object. ...</div><div class='long'><p>Iterates either the elements in an array, or each of the properties in an object.\n<b>Note</b>: If you are only iterating arrays, it is better to call <a href=\"#!/api/Ext-method-each\" rel=\"Ext-method-each\" class=\"docClass\">each</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The object or array to be iterated</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to be called for each iteration.\nThe iteration will stop if the supplied function returns false, or\nall array elements / object properties have been covered. The signature\nvaries depending on the type of object being interated:</p>\n\n<div class=\"mdetail-params\"><ul>\n<li>Arrays : <tt>(Object item, Number index, Array allItems)</tt>\n<div class=\"sub-desc\">\nWhen iterating an array, the supplied function is called with each item.</div></li>\n<li>Objects : <tt>(String key, Object value, Object)</tt>\n<div class=\"sub-desc\">\nWhen iterating an object, the supplied function is called with each key-value pair in\nthe object, and the iterated object</div></li>\n</ul></div>\n\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the specified function is executed. Defaults to\nthe <code>object</code> being iterated.</p>\n</div></li></ul></div></div></div><div id='method-max' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-max' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-max' class='name expandable'>max</a>( <span class='pre'>arr, [comp]</span> )</div><div class='description'><div class='short'>Returns the maximum value in the Array ...</div><div class='long'><p>Returns the maximum value in the Array</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>|NodeList<div class='sub-desc'><p>The Array from which to select the maximum value.</p>\n</div></li><li><span class='pre'>comp</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>a function to perform the comparision which determines maximization.</p>\n\n<pre><code>              If omitted the \"&gt;\" operator will be used. Note: gt = 1; eq = 0; lt = -1\n</code></pre>\n\n<p>@return {Object} The maximum value in the Array.</p>\n</div></li></ul></div></div></div><div id='method-mean' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-mean' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-mean' class='name expandable'>mean</a>( <span class='pre'>arr</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Calculates the mean of the Array ...</div><div class='long'><p>Calculates the mean of the Array</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The Array to calculate the mean value of.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The mean.</p>\n</div></li></ul></div></div></div><div id='method-min' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-min' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-min' class='name expandable'>min</a>( <span class='pre'>arr, [comp]</span> )</div><div class='description'><div class='short'>Returns the minimum value in the Array. ...</div><div class='long'><p>Returns the minimum value in the Array.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>|NodeList<div class='sub-desc'><p>The Array from which to select the minimum value.</p>\n</div></li><li><span class='pre'>comp</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>a function to perform the comparision which determines minimization.</p>\n\n<pre><code>              If omitted the \"&lt;\" operator will be used. Note: gt = 1; eq = 0; lt = -1\n</code></pre>\n\n<p>@return {Object} The minimum value in the Array.</p>\n</div></li></ul></div></div></div><div id='method-namespace' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-namespace' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-namespace' class='name expandable'>namespace</a>( <span class='pre'>namespace1, namespace2, etc</span> ) : Object</div><div class='description'><div class='short'>Creates namespaces to be used for scoping variables and classes so that they are not global. ...</div><div class='long'><p>Creates namespaces to be used for scoping variables and classes so that they are not global.\nSpecifying the last node of a namespace implicitly creates all other nodes. Usage:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-namespace\" rel=\"Ext-method-namespace\" class=\"docClass\">Ext.namespace</a>('Company', 'Company.data');\n<a href=\"#!/api/Ext-method-namespace\" rel=\"Ext-method-namespace\" class=\"docClass\">Ext.namespace</a>('Company.data'); // equivalent and preferable to above syntax\nCompany.Widget = function() { ... }\nCompany.data.CustomStore = function(config) { ... }\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>namespace1</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>namespace2</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>etc</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The namespace object. (If multiple arguments are passed, this will be the last namespace created)</p>\n</div></li></ul></div></div></div><div id='method-ns' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-ns' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-ns' class='name expandable'>ns</a>( <span class='pre'>namespace1, namespace2, etc</span> ) : Object</div><div class='description'><div class='short'>Creates namespaces to be used for scoping variables and classes so that they are not global. ...</div><div class='long'><p>Creates namespaces to be used for scoping variables and classes so that they are not global.\nSpecifying the last node of a namespace implicitly creates all other nodes. Usage:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-namespace\" rel=\"Ext-method-namespace\" class=\"docClass\">Ext.namespace</a>('Company', 'Company.data');\n<a href=\"#!/api/Ext-method-namespace\" rel=\"Ext-method-namespace\" class=\"docClass\">Ext.namespace</a>('Company.data'); // equivalent and preferable to above syntax\nCompany.Widget = function() { ... }\nCompany.data.CustomStore = function(config) { ... }\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>namespace1</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>namespace2</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>etc</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The namespace object. (If multiple arguments are passed, this will be the last namespace created)</p>\n</div></li></ul></div></div></div><div id='method-num' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-num' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-num' class='name expandable'>num</a>( <span class='pre'>value, defaultValue</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Utility method for validating that a value is numeric, returning the specified default value if it is not. ...</div><div class='long'><p>Utility method for validating that a value is numeric, returning the specified default value if it is not.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>Should be a number, but any type will be handled appropriately</p>\n</div></li><li><span class='pre'>defaultValue</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The value to return if the original value is non-numeric</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>Value, if numeric, else defaultValue</p>\n</div></li></ul></div></div></div><div id='method-onReady' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/EventManager.html#Ext-method-onReady' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-onReady' class='name expandable'>onReady</a>( <span class='pre'>fn, [scope], [options]</span> )</div><div class='description'><div class='short'>Adds a listener to be notified when the document is ready (before onload and before images are loaded). ...</div><div class='long'><p>Adds a listener to be notified when the document is ready (before onload and before images are loaded). Shorthand of <a href=\"#!/api/Ext.EventManager-method-onDocumentReady\" rel=\"Ext.EventManager-method-onDocumentReady\" class=\"docClass\">Ext.EventManager.onDocumentReady</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the handler function executes. Defaults to the browser window.</p>\n</div></li><li><span class='pre'>options</span> : boolean (optional)<div class='sub-desc'><p>Options object as passed to <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">Ext.Element.addListener</a>. It is recommended that the options\n<code>{single: true}</code> be used so that the handler is removed on first invocation.</p>\n</div></li></ul></div></div></div><div id='method-override' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-override' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-override' class='name expandable'>override</a>( <span class='pre'>target, overrides</span> )</div><div class='description'><div class='short'>Overrides members of the specified target with the given values. ...</div><div class='long'><p>Overrides members of the specified <code>target</code> with the given values.</p>\n\n<p>If the <code>target</code> is a function, it is assumed to be a constructor and the contents\nof <code>overrides</code> are applied to its <code>prototype</code> using <a href=\"#!/api/Ext-method-apply\" rel=\"Ext-method-apply\" class=\"docClass\">Ext.apply</a>.</p>\n\n<p>If the <code>target</code> is an instance of a class created using <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">define</a>,\nthe <code>overrides</code> are applied to only that instance. In this case, methods are\nspecially processed to allow them to use Ext.Base.callParent.</p>\n\n<pre><code> var panel = new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({ ... });\n\n <a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(panel, {\n     initComponent: function () {\n         // extra processing...\n\n         this.callParent();\n     }\n });\n</code></pre>\n\n<p>If the <code>target</code> is none of these, the <code>overrides</code> are applied to the <code>target</code>\nusing <a href=\"#!/api/Ext-method-apply\" rel=\"Ext-method-apply\" class=\"docClass\">Ext.apply</a>.</p>\n\n<p>Please refer to <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a> for further details.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : Object<div class='sub-desc'><p>The target to override.</p>\n</div></li><li><span class='pre'>overrides</span> : Object<div class='sub-desc'><p>The properties to add or replace on <code>target</code>.</p>\n</div></li></ul></div></div></div><div id='method-partition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-partition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-partition' class='name expandable'>partition</a>( <span class='pre'>arr, [truth]</span> )</div><div class='description'><div class='short'>Partitions the set into two sets: a true set and a false set. ...</div><div class='long'><p>Partitions the set into two sets: a true set and a false set.\nExample:\nExample2:</p>\n\n<pre><code>// Example 1:\n<a href=\"#!/api/Ext-method-partition\" rel=\"Ext-method-partition\" class=\"docClass\">Ext.partition</a>([true, false, true, true, false]); // [[true, true, true], [false, false]]\n\n// Example 2:\n<a href=\"#!/api/Ext-method-partition\" rel=\"Ext-method-partition\" class=\"docClass\">Ext.partition</a>(\n    <a href=\"#!/api/Ext-method-query\" rel=\"Ext-method-query\" class=\"docClass\">Ext.query</a>(\"p\"),\n    function(val){\n        return val.className == \"class1\"\n    }\n);\n// true are those paragraph elements with a className of \"class1\",\n// false set are those that do not have that className.\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>|NodeList<div class='sub-desc'><p>The array to partition</p>\n</div></li><li><span class='pre'>truth</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>a function to determine truth.  If this is omitted the element</p>\n\n<pre><code>              itself must be able to be evaluated for its truthfulness.\n</code></pre>\n\n<p>@return {Array} [true<Array>,false<Array>]</p>\n</Array></Array></div></li></ul></div></div></div><div id='method-pluck' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-pluck' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-pluck' class='name expandable'>pluck</a>( <span class='pre'>arr, prop</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Plucks the value of a property from each item in the Array\n\n// Example:\nExt.pluck(Ext.query(\"p\"), \"className\"); // [e...</div><div class='long'><p>Plucks the value of a property from each item in the Array</p>\n\n<pre><code>// Example:\n<a href=\"#!/api/Ext-method-pluck\" rel=\"Ext-method-pluck\" class=\"docClass\">Ext.pluck</a>(<a href=\"#!/api/Ext-method-query\" rel=\"Ext-method-query\" class=\"docClass\">Ext.query</a>(\"p\"), \"className\"); // [el1.className, el2.className, ..., elN.className]\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>|NodeList<div class='sub-desc'><p>The Array of items to pluck the value from.</p>\n</div></li><li><span class='pre'>prop</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The property name to pluck from each element.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The value from each item in the Array.</p>\n</div></li></ul></div></div></div><div id='method-preg' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/ComponentMgr.html#Ext-method-preg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-preg' class='name expandable'>preg</a>( <span class='pre'>ptype, cls</span> )</div><div class='description'><div class='short'>Shorthand for Ext.ComponentMgr.registerPlugin ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.ComponentMgr-method-registerPlugin\" rel=\"Ext.ComponentMgr-method-registerPlugin\" class=\"docClass\">Ext.ComponentMgr.registerPlugin</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ptype</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The mnemonic string by which the Plugin class\nmay be looked up.</p>\n</div></li><li><span class='pre'>cls</span> : Constructor<div class='sub-desc'><p>The new Plugin class.</p>\n</div></li></ul></div></div></div><div id='method-query' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/DomQuery.html#Ext-method-query' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-query' class='name expandable'>query</a>( <span class='pre'>path, [root]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Selects an array of DOM nodes by CSS/XPath selector. ...</div><div class='long'><p>Selects an array of DOM nodes by CSS/XPath selector. Shorthand of Ext.DomQuery.select</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>path</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The selector/xpath query</p>\n</div></li><li><span class='pre'>root</span> : Node (optional)<div class='sub-desc'><p>The start of the query (defaults to document).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-reg' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/ComponentMgr.html#Ext-method-reg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-reg' class='name expandable'>reg</a>( <span class='pre'>xtype, cls</span> )</div><div class='description'><div class='short'>Shorthand for Ext.ComponentMgr.registerType ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.ComponentMgr-method-registerType\" rel=\"Ext.ComponentMgr-method-registerType\" class=\"docClass\">Ext.ComponentMgr.registerType</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The mnemonic string by which the Component class\nmay be looked up.</p>\n</div></li><li><span class='pre'>cls</span> : Constructor<div class='sub-desc'><p>The new Component class.</p>\n</div></li></ul></div></div></div><div id='method-removeNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-removeNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-removeNode' class='name expandable'>removeNode</a>( <span class='pre'>node</span> )</div><div class='description'><div class='short'>Removes this element from the document, removes all DOM event listeners, and deletes the cache reference. ...</div><div class='long'><p>Removes this element from the document, removes all DOM event listeners, and deletes the cache reference.\nAll DOM event listeners are removed from this element. If <a href=\"#!/api/Ext-property-enableNestedListenerRemoval\" rel=\"Ext-property-enableNestedListenerRemoval\" class=\"docClass\">enableNestedListenerRemoval</a> is\n<code>true</code>, then DOM event listeners are also removed from all child nodes. The body node\nwill be ignored if passed in.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : HTMLElement<div class='sub-desc'><p>The node to remove</p>\n</div></li></ul></div></div></div><div id='method-select' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/CompositeElementLite.html#Ext-method-select' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-select' class='name expandable'>select</a>( <span class='pre'>selector, [root]</span> ) : CompositeElementLite/CompositeElement</div><div class='description'><div class='short'>Selects elements based on the passed CSS selector to enable Element methods\nto be applied to many related elements in...</div><div class='long'><p>Selects elements based on the passed CSS selector to enable <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Element</a> methods\nto be applied to many related elements in one statement through the returned <a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">CompositeElement</a> or\n<a href=\"#!/api/Ext.CompositeElementLite\" rel=\"Ext.CompositeElementLite\" class=\"docClass\">CompositeElementLite</a> object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The CSS selector or an array of elements</p>\n</div></li><li><span class='pre'>root</span> : HTMLElement/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The root element of the query or id of the root</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>CompositeElementLite/CompositeElement</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-sum' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-sum' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-sum' class='name expandable'>sum</a>( <span class='pre'>arr</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Calculates the sum of the Array ...</div><div class='long'><p>Calculates the sum of the Array</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The Array to calculate the sum value of.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The sum.</p>\n</div></li></ul></div></div></div><div id='method-toArray' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-toArray' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-toArray' class='name expandable'>toArray</a>( <span class='pre'>the</span> ) : Object</div><div class='description'><div class='short'>Converts any iterable (numeric indices and a length property) into a true array\nDon't use this on strings. ...</div><div class='long'><p>Converts any iterable (numeric indices and a length property) into a true array\nDon't use this on strings. IE doesn't support \"abc\"[0] which this implementation depends on.\nFor strings, use this instead: \"abc\".match(/./g) => [a,b,c];</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>the</span> : Iterable<div class='sub-desc'><p>iterable object to be turned into a true Array.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>(Array) array</p>\n</div></li></ul></div></div></div><div id='method-type' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-type' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-type' class='name expandable'>type</a>( <span class='pre'>object</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the type of object that is passed in. ...</div><div class='long'><p>Returns the type of object that is passed in. If the object passed in is null or undefined it\nreturn false otherwise it returns one of the following values:<div class=\"mdetail-params\"><ul>\n<li><b>string</b>: If the object passed is a string</li>\n<li><b>number</b>: If the object passed is a number</li>\n<li><b>boolean</b>: If the object passed is a boolean value</li>\n<li><b>date</b>: If the object passed is a Date object</li>\n<li><b>function</b>: If the object passed is a function reference</li>\n<li><b>object</b>: If the object passed is an object</li>\n<li><b>array</b>: If the object passed is an array</li>\n<li><b>regexp</b>: If the object passed is a regular expression</li>\n<li><b>element</b>: If the object passed is a DOM Element</li>\n<li><b>nodelist</b>: If the object passed is a DOM NodeList</li>\n<li><b>textnode</b>: If the object passed is a DOM text node and contains something other than whitespace</li>\n<li><b>whitespace</b>: If the object passed is a DOM text node and contains only whitespace</li>\n</ul></div></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : Mixed<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-unique' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-unique' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-unique' class='name expandable'>unique</a>( <span class='pre'>arr</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Creates a copy of the passed Array, filtered to contain only unique values. ...</div><div class='long'><p>Creates a copy of the passed Array, filtered to contain only unique values.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The Array to filter</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The new Array containing unique values.</p>\n</div></li></ul></div></div></div><div id='method-urlAppend' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-urlAppend' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-urlAppend' class='name expandable'>urlAppend</a>( <span class='pre'>url, s</span> ) : Object</div><div class='description'><div class='short'>Appends content to the query string of a URL, handling logic for whether to place\na question mark or ampersand. ...</div><div class='long'><p>Appends content to the query string of a URL, handling logic for whether to place\na question mark or ampersand.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>url</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The URL to append to.</p>\n</div></li><li><span class='pre'>s</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The content to append to the URL.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>(String) The resulting URL</p>\n</div></li></ul></div></div></div><div id='method-urlDecode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-urlDecode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-urlDecode' class='name expandable'>urlDecode</a>( <span class='pre'>string, [overwrite]</span> ) : Object</div><div class='description'><div class='short'>Takes an encoded URL and and converts it to an object. ...</div><div class='long'><p>Takes an encoded URL and and converts it to an object. Example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-urlDecode\" rel=\"Ext-method-urlDecode\" class=\"docClass\">Ext.urlDecode</a>(\"foo=1&bar=2\"); // returns {foo: \"1\", bar: \"2\"}\n<a href=\"#!/api/Ext-method-urlDecode\" rel=\"Ext-method-urlDecode\" class=\"docClass\">Ext.urlDecode</a>(\"foo=1&bar=2&bar=3&bar=4\", false); // returns {foo: \"1\", bar: [\"2\", \"3\", \"4\"]}\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>string</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>overwrite</span> : Boolean (optional)<div class='sub-desc'><p>Items of the same name will overwrite previous values instead of creating an an array (Defaults to false).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>A literal with members</p>\n</div></li></ul></div></div></div><div id='method-urlEncode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext.html#Ext-method-urlEncode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-urlEncode' class='name expandable'>urlEncode</a>( <span class='pre'>o, [pre]</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Takes an object and converts it to an encoded URL. ...</div><div class='long'><p>Takes an object and converts it to an encoded URL. e.g. <a href=\"#!/api/Ext-method-urlEncode\" rel=\"Ext-method-urlEncode\" class=\"docClass\">Ext.urlEncode</a>({foo: 1, bar: 2}); would return \"foo=1&amp;bar=2\".  Optionally, property values can be arrays, instead of keys and the resulting string that's returned will contain a name/value pair for each array value.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>pre</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A prefix to add to the url encoded string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-value' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-value' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-value' class='name expandable'>value</a>( <span class='pre'>value, defaultValue, [allowBlank]</span> ) : Mixed</div><div class='description'><div class='short'>Utility method for returning a default value if the passed value is empty. ...</div><div class='long'><p>Utility method for returning a default value if the passed value is empty.</p>\n\n\n<p>The value is deemed to be empty if it is<div class=\"mdetail-params\"><ul>\n<li>null</li>\n<li>undefined</li>\n<li>an empty array</li>\n<li>a zero length string (Unless the <tt>allowBlank</tt> parameter is <tt>true</tt>)</li>\n</ul></div>\n\n</p><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to test</p>\n</div></li><li><span class='pre'>defaultValue</span> : Mixed<div class='sub-desc'><p>The value to return if the original value is empty</p>\n</div></li><li><span class='pre'>allowBlank</span> : Boolean (optional)<div class='sub-desc'><p>true to allow zero length strings to qualify as non-empty (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Mixed</span><div class='sub-desc'><p>value, if non-empty, else defaultValue</p>\n</div></li></ul></div></div></div><div id='method-zip' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext'>Ext</span><br/><a href='source/Ext-more.html#Ext-method-zip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext-method-zip' class='name expandable'>zip</a>( <span class='pre'>arr, [zipper]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Zips N sets together. ...</div><div class='long'><p>Zips N sets together.</p>\n\n\n<pre><code>// Example 1:\n<a href=\"#!/api/Ext-method-zip\" rel=\"Ext-method-zip\" class=\"docClass\">Ext.zip</a>([1,2,3],[4,5,6]); // [[1,4],[2,5],[3,6]]\n// Example 2:\n<a href=\"#!/api/Ext-method-zip\" rel=\"Ext-method-zip\" class=\"docClass\">Ext.zip</a>(\n    [ \"+\", \"-\", \"+\"],\n    [  12,  10,  22],\n    [  43,  15,  96],\n    function(a, b, c){\n        return \"$\" + a + \"\" + b + \".\" + c\n    }\n); // [\"$+12.43\", \"$-10.15\", \"$+22.96\"]\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : Arrays|NodeLists<div class='sub-desc'><p>This argument may be repeated. Array(s) to contribute values.</p>\n</div></li><li><span class='pre'>zipper</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>The last item in the argument list. This will drive how the items are zipped together.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The zipped set.</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":[],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"Ext-more.html#Ext","filename":"Ext-more.js"},{"href":"Ext.html#Ext","filename":"Ext.js"}],"linenr":1,"members":{"property":[{"tagname":"property","owner":"Ext","meta":{},"name":"BLANK_IMAGE_URL","id":"property-BLANK_IMAGE_URL"},{"tagname":"property","owner":"Ext","meta":{},"name":"SSL_SECURE_URL","id":"property-SSL_SECURE_URL"},{"tagname":"property","owner":"Ext","meta":{},"name":"USE_NATIVE_JSON","id":"property-USE_NATIVE_JSON"},{"tagname":"property","owner":"Ext","meta":{},"name":"emptyFn","id":"property-emptyFn"},{"tagname":"property","owner":"Ext","meta":{},"name":"enableForcedBoxModel","id":"property-enableForcedBoxModel"},{"tagname":"property","owner":"Ext","meta":{},"name":"enableFx","id":"property-enableFx"},{"tagname":"property","owner":"Ext","meta":{},"name":"enableGarbageCollector","id":"property-enableGarbageCollector"},{"tagname":"property","owner":"Ext","meta":{},"name":"enableListenerCollection","id":"property-enableListenerCollection"},{"tagname":"property","owner":"Ext","meta":{},"name":"enableNestedListenerRemoval","id":"property-enableNestedListenerRemoval"},{"tagname":"property","owner":"Ext","meta":{},"name":"isAir","id":"property-isAir"},{"tagname":"property","owner":"Ext","meta":{},"name":"isBorderBox","id":"property-isBorderBox"},{"tagname":"property","owner":"Ext","meta":{},"name":"isChrome","id":"property-isChrome"},{"tagname":"property","owner":"Ext","meta":{},"name":"isGecko","id":"property-isGecko"},{"tagname":"property","owner":"Ext","meta":{},"name":"isGecko2","id":"property-isGecko2"},{"tagname":"property","owner":"Ext","meta":{},"name":"isGecko3","id":"property-isGecko3"},{"tagname":"property","owner":"Ext","meta":{},"name":"isIE","id":"property-isIE"},{"tagname":"property","owner":"Ext","meta":{},"name":"isIE10","id":"property-isIE10"},{"tagname":"property","owner":"Ext","meta":{},"name":"isIE10p","id":"property-isIE10p"},{"tagname":"property","owner":"Ext","meta":{},"name":"isIE6","id":"property-isIE6"},{"tagname":"property","owner":"Ext","meta":{},"name":"isIE7","id":"property-isIE7"},{"tagname":"property","owner":"Ext","meta":{},"name":"isIE8","id":"property-isIE8"},{"tagname":"property","owner":"Ext","meta":{},"name":"isIE9","id":"property-isIE9"},{"tagname":"property","owner":"Ext","meta":{},"name":"isIE9m","id":"property-isIE9m"},{"tagname":"property","owner":"Ext","meta":{},"name":"isLinux","id":"property-isLinux"},{"tagname":"property","owner":"Ext","meta":{},"name":"isMac","id":"property-isMac"},{"tagname":"property","owner":"Ext","meta":{},"name":"isOpera","id":"property-isOpera"},{"tagname":"property","owner":"Ext","meta":{},"name":"isReady","id":"property-isReady"},{"tagname":"property","owner":"Ext","meta":{},"name":"isSafari","id":"property-isSafari"},{"tagname":"property","owner":"Ext","meta":{},"name":"isSafari2","id":"property-isSafari2"},{"tagname":"property","owner":"Ext","meta":{},"name":"isSafari3","id":"property-isSafari3"},{"tagname":"property","owner":"Ext","meta":{},"name":"isSafari4","id":"property-isSafari4"},{"tagname":"property","owner":"Ext","meta":{},"name":"isSecure","id":"property-isSecure"},{"tagname":"property","owner":"Ext","meta":{},"name":"isStrict","id":"property-isStrict"},{"tagname":"property","owner":"Ext","meta":{},"name":"isWebKit","id":"property-isWebKit"},{"tagname":"property","owner":"Ext","meta":{},"name":"isWindows","id":"property-isWindows"},{"tagname":"property","owner":"Ext","meta":{},"name":"useShims","id":"property-useShims"},{"tagname":"property","owner":"Ext","meta":{},"name":"ux","id":"property-ux"},{"tagname":"property","owner":"Ext","meta":{},"name":"version","id":"property-version"},{"tagname":"property","owner":"Ext","meta":{"private":true},"name":"versionDetail","id":"property-versionDetail"}],"cfg":[],"css_var":[],"method":[{"tagname":"method","owner":"Ext","meta":{},"name":"addBehaviors","id":"method-addBehaviors"},{"tagname":"method","owner":"Ext","meta":{},"name":"apply","id":"method-apply"},{"tagname":"method","owner":"Ext","meta":{},"name":"applyIf","id":"method-applyIf"},{"tagname":"method","owner":"Ext","meta":{},"name":"clean","id":"method-clean"},{"tagname":"method","owner":"Ext","meta":{},"name":"copyTo","id":"method-copyTo"},{"tagname":"method","owner":"Ext","meta":{},"name":"create","id":"method-create"},{"tagname":"method","owner":"Ext","meta":{},"name":"createDelegate","id":"method-createDelegate"},{"tagname":"method","owner":"Ext","meta":{},"name":"createInterceptor","id":"method-createInterceptor"},{"tagname":"method","owner":"Ext","meta":{},"name":"createSequence","id":"method-createSequence"},{"tagname":"method","owner":"Ext","meta":{},"name":"decode","id":"method-decode"},{"tagname":"method","owner":"Ext","meta":{},"name":"defer","id":"method-defer"},{"tagname":"method","owner":"Ext","meta":{"markdown":true},"name":"define","id":"method-define"},{"tagname":"method","owner":"Ext","meta":{},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext","meta":{},"name":"destroyMembers","id":"method-destroyMembers"},{"tagname":"method","owner":"Ext","meta":{},"name":"each","id":"method-each"},{"tagname":"method","owner":"Ext","meta":{},"name":"encode","id":"method-encode"},{"tagname":"method","owner":"Ext","meta":{},"name":"escapeRe","id":"method-escapeRe"},{"tagname":"method","owner":"Ext","meta":{},"name":"extend","id":"method-extend"},{"tagname":"method","owner":"Ext","meta":{},"name":"flatten","id":"method-flatten"},{"tagname":"method","owner":"Ext","meta":{},"name":"fly","id":"method-fly"},{"tagname":"method","owner":"Ext","meta":{},"name":"get","id":"method-get"},{"tagname":"method","owner":"Ext","meta":{},"name":"getBody","id":"method-getBody"},{"tagname":"method","owner":"Ext","meta":{},"name":"getCmp","id":"method-getCmp"},{"tagname":"method","owner":"Ext","meta":{},"name":"getDoc","id":"method-getDoc"},{"tagname":"method","owner":"Ext","meta":{},"name":"getDom","id":"method-getDom"},{"tagname":"method","owner":"Ext","meta":{},"name":"getHead","id":"method-getHead"},{"tagname":"method","owner":"Ext","meta":{},"name":"getScrollBarWidth","id":"method-getScrollBarWidth"},{"tagname":"method","owner":"Ext","meta":{},"name":"handleError","id":"method-handleError"},{"tagname":"method","owner":"Ext","meta":{},"name":"id","id":"method-id"},{"tagname":"method","owner":"Ext","meta":{},"name":"invoke","id":"method-invoke"},{"tagname":"method","owner":"Ext","meta":{},"name":"isArray","id":"method-isArray"},{"tagname":"method","owner":"Ext","meta":{},"name":"isBoolean","id":"method-isBoolean"},{"tagname":"method","owner":"Ext","meta":{},"name":"isDate","id":"method-isDate"},{"tagname":"method","owner":"Ext","meta":{},"name":"isDefined","id":"method-isDefined"},{"tagname":"method","owner":"Ext","meta":{},"name":"isElement","id":"method-isElement"},{"tagname":"method","owner":"Ext","meta":{},"name":"isEmpty","id":"method-isEmpty"},{"tagname":"method","owner":"Ext","meta":{},"name":"isFunction","id":"method-isFunction"},{"tagname":"method","owner":"Ext","meta":{},"name":"isNumber","id":"method-isNumber"},{"tagname":"method","owner":"Ext","meta":{},"name":"isObject","id":"method-isObject"},{"tagname":"method","owner":"Ext","meta":{},"name":"isPrimitive","id":"method-isPrimitive"},{"tagname":"method","owner":"Ext","meta":{},"name":"isString","id":"method-isString"},{"tagname":"method","owner":"Ext","meta":{},"name":"iterate","id":"method-iterate"},{"tagname":"method","owner":"Ext","meta":{},"name":"max","id":"method-max"},{"tagname":"method","owner":"Ext","meta":{},"name":"mean","id":"method-mean"},{"tagname":"method","owner":"Ext","meta":{},"name":"min","id":"method-min"},{"tagname":"method","owner":"Ext","meta":{},"name":"namespace","id":"method-namespace"},{"tagname":"method","owner":"Ext","meta":{},"name":"ns","id":"method-ns"},{"tagname":"method","owner":"Ext","meta":{},"name":"num","id":"method-num"},{"tagname":"method","owner":"Ext","meta":{},"name":"onReady","id":"method-onReady"},{"tagname":"method","owner":"Ext","meta":{},"name":"override","id":"method-override"},{"tagname":"method","owner":"Ext","meta":{},"name":"partition","id":"method-partition"},{"tagname":"method","owner":"Ext","meta":{},"name":"pluck","id":"method-pluck"},{"tagname":"method","owner":"Ext","meta":{},"name":"preg","id":"method-preg"},{"tagname":"method","owner":"Ext","meta":{},"name":"query","id":"method-query"},{"tagname":"method","owner":"Ext","meta":{},"name":"reg","id":"method-reg"},{"tagname":"method","owner":"Ext","meta":{},"name":"removeNode","id":"method-removeNode"},{"tagname":"method","owner":"Ext","meta":{},"name":"select","id":"method-select"},{"tagname":"method","owner":"Ext","meta":{},"name":"sum","id":"method-sum"},{"tagname":"method","owner":"Ext","meta":{},"name":"toArray","id":"method-toArray"},{"tagname":"method","owner":"Ext","meta":{},"name":"type","id":"method-type"},{"tagname":"method","owner":"Ext","meta":{},"name":"unique","id":"method-unique"},{"tagname":"method","owner":"Ext","meta":{},"name":"urlAppend","id":"method-urlAppend"},{"tagname":"method","owner":"Ext","meta":{},"name":"urlDecode","id":"method-urlDecode"},{"tagname":"method","owner":"Ext","meta":{},"name":"urlEncode","id":"method-urlEncode"},{"tagname":"method","owner":"Ext","meta":{},"name":"value","id":"method-value"},{"tagname":"method","owner":"Ext","meta":{},"name":"zip","id":"method-zip"}],"event":[],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext","singleton":true,"override":null,"inheritdoc":null,"id":"class-Ext","mixins":[],"mixedInto":[]});