#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::UserStatusCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. UserStatusCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::UserStatusCodeType

=head1 DESCRIPTION

These codes indicate the current state or status of a an eBay
user account.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Unknown

(out) User properties have never been set; this value should
seldom, if ever, be returned and typically represents a
problem



=cut


use constant Unknown => scalar('Unknown');


=head2 Suspended

(out) User has been suspended from selling and buying, such as
for violations of eBay terms or agreement



=cut


use constant Suspended => scalar('Suspended');


=head2 Confirmed

(out) User has completed online registration and has properly
responded to confirmation email; most users should fall
in this category



=cut


use constant Confirmed => scalar('Confirmed');


=head2 Unconfirmed

(out) User has completed online registration, but has either
not responded to confirmation email or has not yet been
sent the confirmation email



=cut


use constant Unconfirmed => scalar('Unconfirmed');


=head2 Ghost

(out) Registered users of AuctionWeb (pre-eBay) who never
re-registered on eBay



=cut


use constant Ghost => scalar('Ghost');


=head2 InMaintenance

(out) Temporary user record state indicating the record is in
the process of being changed by eBay; query user
information again to get new status



=cut


use constant InMaintenance => scalar('InMaintenance');


=head2 Deleted

(out) Records for the specified user have been deleted



=cut


use constant Deleted => scalar('Deleted');


=head2 CreditCardVerify

(out) User has completed registration and confirmation, but is
pending a verification of credit card information



=cut


use constant CreditCardVerify => scalar('CreditCardVerify');


=head2 AccountOnHold

(out) User's account is on hold, such as for non-payment of
amounts due eBay; user cannot sell or buy items



=cut


use constant AccountOnHold => scalar('AccountOnHold');


=head2 Merged

(out) User record has been merged with another account record
for the same user



=cut


use constant Merged => scalar('Merged');


=head2 RegistrationCodeMailOut

(out) User has completed online registration and has been sent
the confirmation email, but has not yet responded to the
confirmation email



=cut


use constant RegistrationCodeMailOut => scalar('RegistrationCodeMailOut');


=head2 TermPending

(out) User has been scheduled for account closure (typically
when a user has requested to have their account closed)
A user in this state should not be considered an active
user



=cut


use constant TermPending => scalar('TermPending');


=head2 UnconfirmedHalfOptIn

(out) User has completed the registration for Half.com and opted
to automatically also be registered with eBay, but the
registration confirmation is still pending



=cut


use constant UnconfirmedHalfOptIn => scalar('UnconfirmedHalfOptIn');


=head2 CreditCardVerifyHalfOptIn

(out) User has completed the registration for Half.com and opted
to automatically also be registered with eBay, but the
verification of credit card information is still pending



=cut


use constant CreditCardVerifyHalfOptIn => scalar('CreditCardVerifyHalfOptIn');


=head2 UnconfirmedPassport

(out) Signing in with Microsoft Passport is no longer supported.



=cut


use constant UnconfirmedPassport => scalar('UnconfirmedPassport');


=head2 CreditCardVerifyPassport

(out) Signing in with Microsoft Passport is no longer supported.



=cut


use constant CreditCardVerifyPassport => scalar('CreditCardVerifyPassport');


=head2 UnconfirmedExpress

(out) Half.com User; user has completed the registration for Half.com
and opted to automatically also be registered with eBay, but the
registration confirmation is still pending



=cut


use constant UnconfirmedExpress => scalar('UnconfirmedExpress');


=head2 Guest

(out) The user is a guest user. The user has not added a password and has not confirmed an email address.
The user has not signed up as a regular user, but has agreed to the User Agreement and Privacy Policy.
The user has been through the buying flow for a guest;
the user has been through checkout using the streamlined Buy-It-Now flow.



=cut


use constant Guest => scalar('Guest');


=head2 CustomCode

(out) Reserved for internal or future use



=cut


use constant CustomCode => scalar('CustomCode');







1;   
