/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngine;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.utils.CommonUtils;

public class AIEngineDescriptor
extends AbstractDescriptor {
    public static final String EXTENSION_ID = "com.dbeaver.ai.engine";
    private final IConfigurationElement contributorConfig;
    private final String id;
    private final AbstractDescriptor.ObjectType objectType;
    private final AbstractDescriptor.ObjectType propertiesType;
    private final boolean supportsFunctions;
    private final boolean providesMetadata;

    protected AIEngineDescriptor(@NotNull IConfigurationElement contributorConfig) {
        super(contributorConfig);
        this.contributorConfig = contributorConfig;
        this.id = contributorConfig.getAttribute("id");
        this.objectType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, contributorConfig, "class");
        this.supportsFunctions = CommonUtils.toBoolean((Object)contributorConfig.getAttribute("supportsFunctions"));
        this.propertiesType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, contributorConfig, "properties");
        this.providesMetadata = CommonUtils.toBoolean((Object)contributorConfig.getAttribute("providesMetadata"), (boolean)true);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getLabel() {
        return this.contributorConfig.getAttribute("label");
    }

    @Nullable
    public String getReplaces() {
        return this.contributorConfig.getAttribute("replaces");
    }

    @Nullable
    public String getFallbacks() {
        return this.contributorConfig.getAttribute("fallbacks");
    }

    public boolean isDefault() {
        return CommonUtils.toBoolean((Object)this.contributorConfig.getAttribute("default"));
    }

    public boolean isProvidesMetadata() {
        return this.providesMetadata;
    }

    public boolean isSupportsFunctions() {
        return this.supportsFunctions;
    }

    @NotNull
    public Class<? extends AIEngineProperties> getPropertiesType() {
        return this.propertiesType.getImplClass(AIEngineProperties.class);
    }

    @NotNull
    public <T extends AIEngineProperties> T createPropertiesInstance() throws DBException {
        return (T)((AIEngineProperties)this.propertiesType.createInstance(AIEngineProperties.class));
    }

    @NotNull
    public AbstractDescriptor.ObjectType getEngineObjectType() {
        return this.objectType;
    }

    @NotNull
    public AIEngine createEngineInstance() throws DBException {
        return this.createEngineInstance((AIEngineProperties)AISettingsManager.getInstance().getSettings().getEngineConfiguration(this.getId()));
    }

    @NotNull
    public AIEngine createEngineInstance(@NotNull AIEngineProperties properties) throws DBException {
        return (AIEngine)this.objectType.createInstance(AIEngine.class, new Object[]{properties});
    }
}

