/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind.patch;

import com.jsql.model.injection.strategy.blind.patch.Diff;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;

public class Patch {
    private final LinkedList<Diff> diffs = new LinkedList();
    private int start1;
    private int start2;
    private int length1;
    private int length2;

    public String toString() {
        Object coords1 = this.length1 == 0 ? this.start1 + ",0" : (this.length1 == 1 ? Integer.toString(this.start1 + 1) : this.start1 + 1 + "," + this.length1);
        Object coords2 = this.length2 == 0 ? this.start2 + ",0" : (this.length2 == 1 ? Integer.toString(this.start2 + 1) : this.start2 + 1 + "," + this.length2);
        StringBuilder text = new StringBuilder();
        text.append("@@ -").append((String)coords1).append(" +").append((String)coords2).append(" @@\n");
        for (Diff aDiff : this.diffs) {
            switch (aDiff.getOperation()) {
                case INSERT: {
                    text.append('+');
                    break;
                }
                case DELETE: {
                    text.append('-');
                    break;
                }
                case EQUAL: {
                    text.append(' ');
                }
            }
            text.append(URLEncoder.encode(aDiff.getText(), StandardCharsets.UTF_8).replace('+', ' ')).append("\n");
        }
        return Patch.unescapeForEncodeUriCompatability(text.toString());
    }

    public static String unescapeForEncodeUriCompatability(String str) {
        return str.replace("%21", "!").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%3B", ";").replace("%2F", "/").replace("%3F", "?").replace("%3A", ":").replace("%40", "@").replace("%26", "&").replace("%3D", "=").replace("%2B", "+").replace("%24", "$").replace("%2C", ",").replace("%23", "#");
    }

    public LinkedList<Diff> getDiffs() {
        return this.diffs;
    }

    public int getStart1() {
        return this.start1;
    }

    public void setStart1(int start1) {
        this.start1 = start1;
    }

    public int getStart2() {
        return this.start2;
    }

    public void setStart2(int start2) {
        this.start2 = start2;
    }

    public int getLength1() {
        return this.length1;
    }

    public void setLength1(int length1) {
        this.length1 = length1;
    }

    public int getLength2() {
        return this.length2;
    }

    public int setLength2(int length2) {
        this.length2 = length2;
        return length2;
    }
}

