/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.panel;

import com.formdev.flatlaf.icons.FlatRadioButtonMenuItemIcon;
import com.jsql.model.injection.method.AbstractMethodInjection;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.ParameterUtil;
import com.jsql.view.swing.panel.address.ActionEnterAddressBar;
import com.jsql.view.swing.panel.address.ModelAddressLine;
import com.jsql.view.swing.panel.address.PanelTrailingAddress;
import com.jsql.view.swing.panel.util.ButtonExpandText;
import com.jsql.view.swing.text.JPopupTextField;
import com.jsql.view.swing.text.JTextFieldPlaceholder;
import com.jsql.view.swing.text.JToolTipI18n;
import com.jsql.view.swing.text.listener.DocumentListenerEditing;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.RadioItemNonClosing;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PanelAddressBar
extends JPanel {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final AtomicReference<JTextField> atomicTextFieldAddress = new AtomicReference();
    private final AtomicReference<JTextField> atomicTextFieldRequest = new AtomicReference();
    private final AtomicReference<JTextField> atomicTextFieldHeader = new AtomicReference();
    private final AtomicReference<JRadioButton> atomicRadioRequest = new AtomicReference();
    private final AtomicReference<JRadioButton> atomicRadioMethod = new AtomicReference();
    private final AtomicReference<JRadioButton> atomicRadioHeader = new AtomicReference();
    private static final String KEY_ADDRESS_BAR_PLACEHOLDER = "ADDRESS_BAR_PLACEHOLDER";
    private static final String BUTTON_ADVANCED = "BUTTON_ADVANCED";
    private AbstractMethodInjection methodInjection = MediatorHelper.model().getMediatorMethod().getQuery();
    private String typeRequest = "GET";
    private final PanelTrailingAddress panelTrailingAddress;
    private boolean isAdvanceActivated = false;

    public PanelAddressBar() {
        ButtonGroup buttonGroup = new ButtonGroup();
        Stream.of(new ModelAddressLine("URL", MediatorHelper.model().getMediatorMethod().getQuery(), "QUERYSTRING", this.atomicRadioRequest, I18nUtil.valueByKey(KEY_ADDRESS_BAR_PLACEHOLDER), this.atomicTextFieldAddress), new ModelAddressLine("GET", MediatorHelper.model().getMediatorMethod().getRequest(), "REQUEST", this.atomicRadioMethod, "e.g. key=value&injectMe=", this.atomicTextFieldRequest), new ModelAddressLine("Header", MediatorHelper.model().getMediatorMethod().getHeader(), "HEADER", this.atomicRadioHeader, String.format("e.g. key: value\\r\\nCookie: cKey1=cValue1; cKey2=cValue2\\r\\n%s: %s %s\\r\\ninjectMe:", "Authorization", "Basic", "dXNlcjpwYXNz"), this.atomicTextFieldHeader)).forEach(modelLine -> {
            String i18nTooltip = String.format("FIELD_%s_TOOLTIP", modelLine.i18n);
            final AtomicReference<JToolTipI18n> tooltipTextfield = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey(i18nTooltip)));
            modelLine.textfield.set((JTextField)new JPopupTextField(new JTextFieldPlaceholder(modelLine.placeholder, modelLine.radio == this.atomicRadioRequest ? 18 : 0){

                @Override
                public JToolTip createToolTip() {
                    return (JToolTip)tooltipTextfield.get();
                }
            }).getProxy());
            I18nViewUtil.addComponentForKey(i18nTooltip, tooltipTextfield.get());
            modelLine.textfield.get().addActionListener(new ActionEnterAddressBar(this));
            modelLine.textfield.get().setVisible(false);
            modelLine.textfield.get().setToolTipText(I18nUtil.valueByKey(i18nTooltip));
            String i18nRadio = String.format("METHOD_%s_TOOLTIP", modelLine.i18n);
            final AtomicReference<JToolTipI18n> tooltipRadio = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey(i18nRadio)));
            modelLine.radio.set(new JRadioButton(modelLine.request){

                @Override
                public JToolTip createToolTip() {
                    return (JToolTip)tooltipRadio.get();
                }
            });
            I18nViewUtil.addComponentForKey(i18nRadio, tooltipRadio.get());
            modelLine.radio.get().setToolTipText(I18nUtil.valueByKey(i18nRadio));
            modelLine.radio.get().setSelected(modelLine.radio == this.atomicRadioRequest);
            modelLine.radio.get().setHorizontalTextPosition(2);
            modelLine.radio.get().setVisible(false);
            modelLine.radio.get().setBorder(BorderFactory.createEmptyBorder(modelLine.radio == this.atomicRadioRequest ? 0 : 6, 3, 0, 3));
            modelLine.radio.get().addActionListener(e -> MediatorHelper.panelAddressBar().setMethodInjection(modelLine.method));
            buttonGroup.add(modelLine.radio.get());
        });
        this.atomicTextFieldAddress.get().setFont(UiUtil.FONT_NON_MONO_BIG);
        this.atomicTextFieldAddress.get().setName("textFieldAddress");
        this.atomicTextFieldAddress.get().setPreferredSize(new Dimension(50, 32));
        this.atomicTextFieldAddress.get().setVisible(true);
        I18nViewUtil.addComponentForKey(KEY_ADDRESS_BAR_PLACEHOLDER, this.atomicTextFieldAddress.get());
        this.panelTrailingAddress = new PanelTrailingAddress(this);
        this.atomicTextFieldAddress.get().putClientProperty("JTextField.trailingComponent", this.panelTrailingAddress);
        this.atomicTextFieldAddress.get().putClientProperty("JTextField.leadingIcon", UiUtil.GLOBE.getIcon());
        this.atomicTextFieldRequest.get().putClientProperty("JTextField.trailingComponent", new ButtonExpandText(this.atomicTextFieldRequest.get()));
        this.atomicTextFieldHeader.get().putClientProperty("JTextField.trailingComponent", new ButtonExpandText(this.atomicTextFieldHeader.get()));
        this.initLayout();
    }

    private void initLayout() {
        JLabel advancedButton = this.initAdvancedButton();
        this.setLayout(new BoxLayout(this, 3));
        JPanel panelTextFields = new JPanel();
        GroupLayout groupLayout = new GroupLayout(panelTextFields);
        panelTextFields.setLayout(groupLayout);
        panelTextFields.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
        this.add(panelTextFields);
        final JPopupMenu popupMethods = new JPopupMenu();
        ButtonGroup buttonGroupMethods = new ButtonGroup();
        for (String method : new String[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"}) {
            RadioItemNonClosing newMenuItem = new RadioItemNonClosing(method, "GET".equals(method));
            newMenuItem.addActionListener(actionEvent -> {
                this.typeRequest = newMenuItem.getText();
                this.atomicRadioMethod.get().setText(this.typeRequest);
                this.atomicRadioMethod.get().requestFocusInWindow();
            });
            popupMethods.add(newMenuItem);
            buttonGroupMethods.add(newMenuItem);
        }
        final AtomicReference<JToolTipI18n> tooltipMethods = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey("METHOD_CUSTOM_TOOLTIP")));
        JPanel panelCustomMethod = new JPanel(new BorderLayout()){

            @Override
            public JToolTip createToolTip() {
                return (JToolTip)tooltipMethods.get();
            }
        };
        I18nViewUtil.addComponentForKey("METHOD_CUSTOM_TOOLTIP", tooltipMethods.get());
        Supplier<Color> colorBackground = () -> UIManager.getColor("MenuItem.background");
        Supplier<Color> colorSelectionBackground = () -> UIManager.getColor("MenuItem.selectionBackground");
        panelCustomMethod.setBackground(colorBackground.get());
        JRadioButton radioCustomMethod = new JRadioButton(){

            @Override
            public JToolTip createToolTip() {
                return (JToolTip)tooltipMethods.get();
            }
        };
        radioCustomMethod.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        radioCustomMethod.setIcon(new FlatRadioButtonMenuItemIcon());
        radioCustomMethod.setBackground(colorBackground.get());
        buttonGroupMethods.add(radioCustomMethod);
        final JTextField inputCustomMethod = (JTextField)new JPopupTextField("CUSTOM"){

            @Override
            public JToolTip createToolTip() {
                return (JToolTip)tooltipMethods.get();
            }
        }.getProxy();
        inputCustomMethod.addMouseListener(new MouseAdapter(radioCustomMethod){
            final /* synthetic */ 4 val$radioCustomMethod;
            {
                this.val$radioCustomMethod = var2_2;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.val$radioCustomMethod.setSelected(!this.val$radioCustomMethod.isSelected());
            }
        });
        inputCustomMethod.getDocument().addDocumentListener(new DocumentListenerEditing(){

            @Override
            public void process() {
                PanelAddressBar.this.validate(inputCustomMethod);
            }
        });
        radioCustomMethod.addActionListener(actionEvent -> this.validate(inputCustomMethod));
        String tooltipCustomMethod = "<html>Set user defined HTTP method.<br/>A valid method is limited to chars:<br>!#$%&'*+-.^_`|~0123456789<br>abcdefghijklmnopqrstuvwxyz<br>ABCDEFGHIJKLMNOPQRSTUVWXYZ</html>";
        MouseAdapter mouseAdapterSetBackground = new MouseAdapter(panelCustomMethod, colorSelectionBackground, radioCustomMethod, colorBackground){
            final /* synthetic */ 3 val$panelCustomMethod;
            final /* synthetic */ Supplier val$colorSelectionBackground;
            final /* synthetic */ 4 val$radioCustomMethod;
            final /* synthetic */ Supplier val$colorBackground;
            {
                this.val$panelCustomMethod = var2_2;
                this.val$colorSelectionBackground = supplier;
                this.val$radioCustomMethod = var4_4;
                this.val$colorBackground = supplier2;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                this.val$panelCustomMethod.setBackground((Color)this.val$colorSelectionBackground.get());
                this.val$radioCustomMethod.setBackground((Color)this.val$colorSelectionBackground.get());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                this.val$panelCustomMethod.setBackground((Color)this.val$colorBackground.get());
                this.val$radioCustomMethod.setBackground((Color)this.val$colorBackground.get());
            }
        };
        Arrays.asList(radioCustomMethod, inputCustomMethod, panelCustomMethod).forEach(component -> {
            component.addMouseListener(mouseAdapterSetBackground);
            component.setToolTipText(tooltipCustomMethod);
        });
        panelCustomMethod.add((Component)radioCustomMethod, "Before");
        panelCustomMethod.add((Component)inputCustomMethod, "Center");
        popupMethods.insert(panelCustomMethod, popupMethods.getComponentCount());
        this.atomicRadioMethod.get().addMouseListener(new MouseAdapter(radioCustomMethod, inputCustomMethod){
            final /* synthetic */ 4 val$radioCustomMethod;
            final /* synthetic */ JTextField val$inputCustomMethod;
            {
                this.val$radioCustomMethod = var3_3;
                this.val$inputCustomMethod = jTextField;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Arrays.stream(popupMethods.getComponents()).map(a -> (JComponent)a).forEach(JComponent::updateUI);
                this.val$radioCustomMethod.setIcon(new FlatRadioButtonMenuItemIcon());
                this.val$radioCustomMethod.updateUI();
                this.val$inputCustomMethod.updateUI();
                popupMethods.updateUI();
                if (ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale()))) {
                    this.val$radioCustomMethod.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
                } else {
                    this.val$radioCustomMethod.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
                }
                popupMethods.show(e.getComponent(), ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale())) ? e.getComponent().getX() - e.getComponent().getWidth() - popupMethods.getWidth() : e.getComponent().getX(), e.getComponent().getY() + e.getComponent().getHeight());
                popupMethods.setLocation(ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale())) ? e.getComponent().getLocationOnScreen().x + e.getComponent().getWidth() - popupMethods.getWidth() : e.getComponent().getLocationOnScreen().x, e.getComponent().getLocationOnScreen().y + e.getComponent().getHeight());
                popupMethods.applyComponentOrientation(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale()));
            }
        });
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.atomicRadioRequest.get()).addComponent(this.atomicRadioMethod.get()).addComponent(this.atomicRadioHeader.get())).addGroup(groupLayout.createParallelGroup().addComponent(this.atomicTextFieldAddress.get()).addComponent(this.atomicTextFieldRequest.get()).addComponent(this.atomicTextFieldHeader.get())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(advancedButton)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.atomicRadioRequest.get()).addComponent(this.atomicTextFieldAddress.get()).addComponent(advancedButton)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.atomicRadioMethod.get()).addComponent(this.atomicTextFieldRequest.get())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.atomicRadioHeader.get()).addComponent(this.atomicTextFieldHeader.get())));
    }

    private void validate(JTextField inputCustomMethod) {
        if (StringUtils.isEmpty(inputCustomMethod.getText())) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Missing custom method label");
        } else if (ParameterUtil.isInvalidName(inputCustomMethod.getText())) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, () -> String.format("Illegal method: \"%s\"", inputCustomMethod.getText()));
        } else {
            this.typeRequest = inputCustomMethod.getText();
            this.atomicRadioMethod.get().setText(this.typeRequest);
        }
    }

    private JLabel initAdvancedButton() {
        final AtomicReference<JToolTipI18n> tooltip = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey(BUTTON_ADVANCED)));
        JLabel advancedButton = new JLabel((Icon)UiUtil.ARROW_DOWN.getIcon()){

            @Override
            public JToolTip createToolTip() {
                return (JToolTip)tooltip.get();
            }
        };
        advancedButton.setName("advancedButton");
        advancedButton.setToolTipText(I18nUtil.valueByKey(BUTTON_ADVANCED));
        I18nViewUtil.addComponentForKey(BUTTON_ADVANCED, tooltip.get());
        advancedButton.addMouseListener(new MouseAdapter(advancedButton){
            final /* synthetic */ 10 val$advancedButton;
            {
                this.val$advancedButton = var2_2;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean isVisible = this.val$advancedButton.getIcon() == UiUtil.ARROW_DOWN.getIcon();
                PanelAddressBar.this.atomicTextFieldRequest.get().setVisible(isVisible);
                PanelAddressBar.this.atomicTextFieldHeader.get().setVisible(isVisible);
                PanelAddressBar.this.atomicRadioRequest.get().setVisible(isVisible);
                PanelAddressBar.this.atomicRadioMethod.get().setVisible(isVisible);
                PanelAddressBar.this.atomicRadioHeader.get().setVisible(isVisible);
                PanelAddressBar.this.isAdvanceActivated = isVisible;
                MediatorHelper.menubar().setVisible(isVisible);
                this.val$advancedButton.setIcon(isVisible ? UiUtil.ARROW_UP.getIcon() : UiUtil.ARROW_DOWN.getIcon());
            }
        });
        return advancedButton;
    }

    public void setMethodInjection(AbstractMethodInjection methodInjection) {
        this.methodInjection = methodInjection;
    }

    public boolean isAdvanceActivated() {
        return !this.isAdvanceActivated;
    }

    public JTextField getTextFieldAddress() {
        return this.atomicTextFieldAddress.get();
    }

    public JTextField getTextFieldRequest() {
        return this.atomicTextFieldRequest.get();
    }

    public JTextField getTextFieldHeader() {
        return this.atomicTextFieldHeader.get();
    }

    public AbstractMethodInjection getMethodInjection() {
        return this.methodInjection;
    }

    public PanelTrailingAddress getPanelTrailingAddress() {
        return this.panelTrailingAddress;
    }

    public String getTypeRequest() {
        return this.typeRequest;
    }

    public JRadioButton getAtomicRadioRequest() {
        return this.atomicRadioRequest.get();
    }

    public JRadioButton getAtomicRadioMethod() {
        return this.atomicRadioMethod.get();
    }

    public JRadioButton getAtomicRadioHeader() {
        return this.atomicRadioHeader.get();
    }
}

