% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowWeightedMeans.R
\name{rowWeightedMeans}
\alias{rowWeightedMeans}
\alias{rowWeightedMeans,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowWeightedMeans,ANY-method}
\alias{colWeightedMeans}
\alias{colWeightedMeans,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colWeightedMeans,ANY-method}
\title{Calculates the weighted mean for each row (column) of a matrix-like object}
\usage{
rowWeightedMeans(x, w = NULL, rows = NULL, cols = NULL, na.rm = FALSE,
  ..., useNames = TRUE)

\S4method{rowWeightedMeans}{matrix_OR_array_OR_table_OR_numeric}(x, w = NULL,
  rows = NULL, cols = NULL, na.rm = FALSE, ..., useNames = TRUE)

\S4method{rowWeightedMeans}{ANY}(x, w = NULL, rows = NULL, cols = NULL,
  na.rm = FALSE, ..., useNames = TRUE)

colWeightedMeans(x, w = NULL, rows = NULL, cols = NULL, na.rm = FALSE,
  ..., useNames = TRUE)

\S4method{colWeightedMeans}{matrix_OR_array_OR_table_OR_numeric}(x, w = NULL,
  rows = NULL, cols = NULL, na.rm = FALSE, ..., useNames = TRUE)

\S4method{colWeightedMeans}{ANY}(x, w = NULL, rows = NULL, cols = NULL,
  na.rm = FALSE, ..., useNames = TRUE)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{w}{A \code{\link{numeric}} vector of length K (N) that specifies by
how much each element is weighted.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{TRUE}} (default), names attributes of result are set. Else if \code{\link{FALSE}}, no naming support is done.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the weighted  mean for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowWeightedMeans}} /
\code{matrixStats::\link[matrixStats]{colWeightedMeans}}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)
w <- rnorm(n = 5, mean = 3)
rowWeightedMeans(mat, w = w[1:3])
colWeightedMeans(mat, w = w)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowWeightedMeans}()} and
\code{matrixStats::\link[matrixStats:rowWeightedMeans]{colWeightedMeans}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
\item See also \link{rowMeans2} for the corresponding unweighted function.
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
