# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.authorization.aio import AuthorizationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAuthorizationManagementRoleManagementPoliciesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AuthorizationManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_management_policies_get(self, resource_group):
        response = await self.client.role_management_policies.get(
            scope="str",
            role_management_policy_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_management_policies_update(self, resource_group):
        response = await self.client.role_management_policies.update(
            scope="str",
            role_management_policy_name="str",
            parameters={
                "description": "str",
                "displayName": "str",
                "effectiveRules": ["role_management_policy_rule"],
                "id": "str",
                "isOrganizationDefault": bool,
                "lastModifiedBy": {"displayName": "str", "email": "str", "id": "str", "type": "str"},
                "lastModifiedDateTime": "2020-02-20 00:00:00",
                "name": "str",
                "policyProperties": {"scope": {"displayName": "str", "id": "str", "type": "str"}},
                "rules": ["role_management_policy_rule"],
                "scope": "str",
                "type": "str",
            },
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_management_policies_delete(self, resource_group):
        response = await self.client.role_management_policies.delete(
            scope="str",
            role_management_policy_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_role_management_policies_list_for_scope(self, resource_group):
        response = self.client.role_management_policies.list_for_scope(
            scope="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
