# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.deviceregistry import DeviceRegistryMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-deviceregistry
# USAGE
    python create_or_replace_namespace_device.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = DeviceRegistryMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.namespace_devices.begin_create_or_replace(
        resource_group_name="myResourceGroup",
        namespace_name="adr-namespace-gbk0925-n01",
        device_name="dev-namespace-gbk0925-n01",
        resource={
            "location": "West Europe",
            "properties": {
                "attributes": {"deviceCategory": 16, "deviceOwner": "IT", "deviceType": "sensor"},
                "enabled": True,
                "endpoints": {
                    "outbound": {
                        "assigned": {
                            "eventGridEndpoint": {
                                "address": "https://myeventgridtopic.westeurope-1.eventgrid.azure.net/api/events",
                                "endpointType": "Microsoft.Devices/IoTHubs",
                            }
                        }
                    }
                },
                "externalDeviceId": "adr-smart-device3-7a848b15-af47-40a7-8c06-a3f43314d44f",
            },
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-10-01/CreateOrReplace_NamespaceDevice.json
if __name__ == "__main__":
    main()
