# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.avs import AVSClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAVSPrivateCloudsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AVSClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_clouds_list(self, resource_group):
        response = self.client.private_clouds.list(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_clouds_list_in_subscription(self, resource_group):
        response = self.client.private_clouds.list_in_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_clouds_get(self, resource_group):
        response = self.client.private_clouds.get(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_clouds_begin_create_or_update(self, resource_group):
        response = self.client.private_clouds.begin_create_or_update(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            private_cloud={
                "location": "str",
                "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                "id": "str",
                "identity": {"type": "str", "principalId": "str", "tenantId": "str"},
                "name": "str",
                "properties": {
                    "managementCluster": {
                        "clusterId": 0,
                        "clusterSize": 0,
                        "hosts": ["str"],
                        "provisioningState": "str",
                        "vsanDatastoreName": "str",
                    },
                    "networkBlock": "str",
                    "availability": {"secondaryZone": 0, "strategy": "str", "zone": 0},
                    "circuit": {
                        "expressRouteID": "str",
                        "expressRoutePrivatePeeringID": "str",
                        "primarySubnet": "str",
                        "secondarySubnet": "str",
                    },
                    "dnsZoneType": "str",
                    "encryption": {
                        "keyVaultProperties": {
                            "autoDetectedKeyVersion": "str",
                            "keyName": "str",
                            "keyState": "str",
                            "keyVaultUrl": "str",
                            "keyVersion": "str",
                            "versionType": "str",
                        },
                        "status": "str",
                    },
                    "endpoints": {
                        "hcxCloudManager": "str",
                        "hcxCloudManagerIp": "str",
                        "nsxtManager": "str",
                        "nsxtManagerIp": "str",
                        "vcenterIp": "str",
                        "vcsa": "str",
                    },
                    "extendedNetworkBlocks": ["str"],
                    "externalCloudLinks": ["str"],
                    "identitySources": [
                        {
                            "alias": "str",
                            "baseGroupDN": "str",
                            "baseUserDN": "str",
                            "domain": "str",
                            "name": "str",
                            "password": "str",
                            "primaryServer": "str",
                            "secondaryServer": "str",
                            "ssl": "str",
                            "username": "str",
                        }
                    ],
                    "internet": "str",
                    "managementNetwork": "str",
                    "nsxPublicIpQuotaRaised": "str",
                    "nsxtCertificateThumbprint": "str",
                    "nsxtPassword": "str",
                    "provisioningNetwork": "str",
                    "provisioningState": "str",
                    "secondaryCircuit": {
                        "expressRouteID": "str",
                        "expressRoutePrivatePeeringID": "str",
                        "primarySubnet": "str",
                        "secondarySubnet": "str",
                    },
                    "vcenterCertificateThumbprint": "str",
                    "vcenterPassword": "str",
                    "vcfLicense": "vcf_license",
                    "virtualNetworkId": "str",
                    "vmotionNetwork": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "zones": ["str"],
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_clouds_begin_update(self, resource_group):
        response = self.client.private_clouds.begin_update(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            private_cloud_update={
                "identity": {"type": "str", "principalId": "str", "tenantId": "str"},
                "properties": {
                    "availability": {"secondaryZone": 0, "strategy": "str", "zone": 0},
                    "dnsZoneType": "str",
                    "encryption": {
                        "keyVaultProperties": {
                            "autoDetectedKeyVersion": "str",
                            "keyName": "str",
                            "keyState": "str",
                            "keyVaultUrl": "str",
                            "keyVersion": "str",
                            "versionType": "str",
                        },
                        "status": "str",
                    },
                    "extendedNetworkBlocks": ["str"],
                    "identitySources": [
                        {
                            "alias": "str",
                            "baseGroupDN": "str",
                            "baseUserDN": "str",
                            "domain": "str",
                            "name": "str",
                            "password": "str",
                            "primaryServer": "str",
                            "secondaryServer": "str",
                            "ssl": "str",
                            "username": "str",
                        }
                    ],
                    "internet": "str",
                    "managementCluster": {
                        "clusterId": 0,
                        "clusterSize": 0,
                        "hosts": ["str"],
                        "provisioningState": "str",
                        "vsanDatastoreName": "str",
                    },
                },
                "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_clouds_begin_delete(self, resource_group):
        response = self.client.private_clouds.begin_delete(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_clouds_begin_rotate_vcenter_password(self, resource_group):
        response = self.client.private_clouds.begin_rotate_vcenter_password(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_clouds_begin_rotate_nsxt_password(self, resource_group):
        response = self.client.private_clouds.begin_rotate_nsxt_password(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_clouds_list_admin_credentials(self, resource_group):
        response = self.client.private_clouds.list_admin_credentials(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_clouds_get_vcf_license(self, resource_group):
        response = self.client.private_clouds.get_vcf_license(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )

        # please add some check logic here by yourself
        # ...
