/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.AbstractConnection;
import com.ericsson.otp.erlang.Link;
import com.ericsson.otp.erlang.Links;
import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangExit;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpMsg;
import com.ericsson.otp.erlang.OtpNode;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.erlang.OtpPeer;
import com.ericsson.otp.erlang.OtpTransport;
import java.io.IOException;

public class OtpCookedConnection
extends AbstractConnection {
    protected OtpNode self;
    protected Links links = null;

    OtpCookedConnection(OtpNode otpNode, OtpTransport otpTransport) throws IOException, OtpAuthException {
        super((OtpLocalNode)otpNode, otpTransport);
        this.self = otpNode;
        this.links = new Links(25);
        this.start();
    }

    OtpCookedConnection(OtpNode otpNode, OtpPeer otpPeer) throws IOException, OtpAuthException {
        super((OtpLocalNode)otpNode, otpPeer);
        this.self = otpNode;
        this.links = new Links(25);
        this.start();
    }

    @Override
    public void deliver(Exception exception) {
        this.self.deliverError(this, exception);
    }

    @Override
    public void deliver(OtpMsg otpMsg) {
        boolean bl = this.self.deliver(otpMsg);
        switch (otpMsg.type()) {
            case 1: {
                if (bl) break;
                try {
                    super.sendExit(otpMsg.getRecipientPid(), otpMsg.getSenderPid(), new OtpErlangAtom("noproc"));
                }
                catch (IOException iOException) {}
                break;
            }
        }
    }

    void send(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, OtpErlangObject otpErlangObject) throws IOException {
        this.sendBuf(otpErlangPid, otpErlangPid2, new OtpOutputStream(otpErlangObject));
    }

    void send(OtpErlangPid otpErlangPid, String string, OtpErlangObject otpErlangObject) throws IOException {
        this.sendBuf(otpErlangPid, string, new OtpOutputStream(otpErlangObject));
    }

    @Override
    public void close() {
        super.close();
        this.breakLinks();
    }

    @Override
    protected void finalize() {
        this.close();
    }

    void exit(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, OtpErlangObject otpErlangObject) {
        try {
            super.sendExit(otpErlangPid, otpErlangPid2, otpErlangObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void exit2(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, OtpErlangObject otpErlangObject) {
        try {
            super.sendExit2(otpErlangPid, otpErlangPid2, otpErlangObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void link(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2) throws OtpErlangExit {
        try {
            super.sendLink(otpErlangPid, otpErlangPid2);
        }
        catch (IOException iOException) {
            throw new OtpErlangExit("noproc", otpErlangPid2);
        }
    }

    void unlink(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, long l) {
        try {
            super.sendUnlink(otpErlangPid, otpErlangPid2, l);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void unlink_ack(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, long l) {
        try {
            super.sendUnlinkAck(otpErlangPid, otpErlangPid2, l);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void node_link(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, boolean bl) {
        if (bl) {
            this.links.addLink(otpErlangPid, otpErlangPid2, true);
        } else {
            this.links.removeLink(otpErlangPid, otpErlangPid2);
        }
    }

    synchronized void breakLinks() {
        Link[] linkArray;
        if (this.links != null && (linkArray = this.links.clearLinks()) != null) {
            int n = linkArray.length;
            for (int i = 0; i < n; ++i) {
                this.self.deliver(new OtpMsg(3, linkArray[i].remote(), linkArray[i].local(), new OtpErlangAtom("noconnection")));
            }
        }
    }
}

