"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notificationsDashboardsPlugin = void 0;
var _routes = require("./routes");
var _notificationsPlugin = require("./clusters/notificationsPlugin");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class notificationsDashboardsPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core, {
    dataSource
  }) {
    this.logger.debug("notificationsDashboards: Setup");
    const router = core.http.createRouter();
    const notificationsClient = core.opensearch.legacy.createClient('opensearch_notifications', {
      plugins: [_notificationsPlugin.NotificationsPlugin]
    });
    const dataSourceEnabled = !!dataSource;
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_notificationsPlugin.NotificationsPlugin);
    }
    core.http.registerRouteHandlerContext('notificationsContext', (context, request) => {
      return {
        logger: this.logger,
        notificationsClient
      };
    });

    // Register server side APIs
    (0, _routes.defineRoutes)(router, dataSourceEnabled);
    return {};
  }
  start(core) {
    this.logger.debug("notificationsDashboards: Started");
    return {};
  }
  stop() {}
}
exports.notificationsDashboardsPlugin = notificationsDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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