﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lexv2-models/LexModelsV2Request.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>

#include <utility>

namespace Aws {
namespace LexModelsV2 {
namespace Model {

/**
 */
class UpdateExportRequest : public LexModelsV2Request {
 public:
  AWS_LEXMODELSV2_API UpdateExportRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateExport"; }

  AWS_LEXMODELSV2_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique identifier Amazon Lex assigned to the export.</p>
   */
  inline const Aws::String& GetExportId() const { return m_exportId; }
  inline bool ExportIdHasBeenSet() const { return m_exportIdHasBeenSet; }
  template <typename ExportIdT = Aws::String>
  void SetExportId(ExportIdT&& value) {
    m_exportIdHasBeenSet = true;
    m_exportId = std::forward<ExportIdT>(value);
  }
  template <typename ExportIdT = Aws::String>
  UpdateExportRequest& WithExportId(ExportIdT&& value) {
    SetExportId(std::forward<ExportIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The new password to use to encrypt the export zip archive.</p>
   */
  inline const Aws::String& GetFilePassword() const { return m_filePassword; }
  inline bool FilePasswordHasBeenSet() const { return m_filePasswordHasBeenSet; }
  template <typename FilePasswordT = Aws::String>
  void SetFilePassword(FilePasswordT&& value) {
    m_filePasswordHasBeenSet = true;
    m_filePassword = std::forward<FilePasswordT>(value);
  }
  template <typename FilePasswordT = Aws::String>
  UpdateExportRequest& WithFilePassword(FilePasswordT&& value) {
    SetFilePassword(std::forward<FilePasswordT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_exportId;

  Aws::String m_filePassword;
  bool m_exportIdHasBeenSet = false;
  bool m_filePasswordHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
